/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.effect;

import com.davidm1a2.afraidofthedark.common.constants.ModParticles;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.FloatSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0014\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\t\u00a8\u0006\u0013"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/ExplosionSpellEffect;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/AOTDSpellEffect;", "()V", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "getRadius", "", "procEffect", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "reducedParticles", "", "setRadius", "radius", "Companion", "afraidofthedark"})
public final class ExplosionSpellEffect
extends AOTDSpellEffect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_RADIUS = "radius";

    public ExplosionSpellEffect() {
        super(new ResourceLocation("afraidofthedark", "explosion"));
        this.addEditableProperty(((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.floatProperty().withName("Radius")).withDescription("The explosion's radius.")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(Float.valueOf(2.0f))).withMinValue(Float.valueOf(1.0f))).withMaxValue(Float.valueOf(50.0f))).build());
    }

    @Override
    public void procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> instance, boolean reducedParticles) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(instance, "instance");
        ServerWorld world = state.getWorld();
        Vector3d position = state.getPosition();
        if (reducedParticles) {
            RegistryKey registryKey = world.func_234923_W_();
            Intrinsics.checkNotNullExpressionValue(registryKey, "world.dimension()");
            AOTDSpellEffect.Companion.createParticlesAt(0, 2, position, (RegistryKey<World>)registryKey, ModParticles.INSTANCE.getEXPLOSION());
        } else {
            RegistryKey registryKey = world.func_234923_W_();
            Intrinsics.checkNotNullExpressionValue(registryKey, "world.dimension()");
            AOTDSpellEffect.Companion.createParticlesAt(5, 10, position, (RegistryKey<World>)registryKey, ModParticles.INSTANCE.getEXPLOSION());
        }
        world.func_217385_a(null, position.field_72450_a, position.field_72448_b - (double)0.01f, position.field_72449_c, this.getRadius(instance), Explosion.Mode.BREAK);
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        float radius = this.getRadius(instance);
        return 25.0 + (double)(radius * radius * radius);
    }

    public final void setRadius(@NotNull SpellComponentInstance<SpellEffect> instance, float radius) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        instance.getData().func_74776_a(NBT_RADIUS, radius);
    }

    public final float getRadius(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74760_g(NBT_RADIUS);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/ExplosionSpellEffect$Companion;", "", "()V", "NBT_RADIUS", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

