/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.effect;

import com.davidm1a2.afraidofthedark.common.constants.ModParticles;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.IntSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.FoodStats;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0014\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\n\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/FeedSpellEffect;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/AOTDSpellEffect;", "()V", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "getHungerValue", "", "getSaturationValue", "procEffect", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "reducedParticles", "", "Companion", "afraidofthedark"})
public final class FeedSpellEffect
extends AOTDSpellEffect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_HUNGER_VALUE = "hunger_value";
    @NotNull
    private static final String NBT_SATURATION_VALUE = "saturation_value";

    public FeedSpellEffect() {
        super(new ResourceLocation("afraidofthedark", "feed"));
        this.addEditableProperty(((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.intProperty().withName("Hunger Amount")).withDescription("The amount of food half 'drumsticks' to restore.")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(2)).withMinValue(1)).withMaxValue(300)).build());
        this.addEditableProperty(((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.intProperty().withName("Saturation Amount")).withDescription("The amount of saturation restore.")).withSetter(3.INSTANCE)).withGetter(4.INSTANCE)).withDefaultValue(1)).withMinValue(0)).build());
    }

    @Override
    public void procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> instance, boolean reducedParticles) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(instance, "instance");
        Entity entity = state.getEntity();
        if (entity instanceof PlayerEntity) {
            Vector3d vector3d = state.getPosition();
            RegistryKey registryKey = ((PlayerEntity)entity).field_70170_p.func_234923_W_();
            Intrinsics.checkNotNullExpressionValue(registryKey, "entity.level.dimension()");
            AOTDSpellEffect.Companion.createParticlesAt(1, 2, vector3d, (RegistryKey<World>)registryKey, ModParticles.INSTANCE.getGROW());
            FoodStats foodStats = ((PlayerEntity)entity).func_71024_bL();
            foodStats.func_75122_a(this.getHungerValue(instance), (float)this.getSaturationValue(instance));
        }
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return 10.0 + (double)this.getHungerValue(instance) / 2.0 + (double)this.getSaturationValue(instance) * 2.0;
    }

    public final int getHungerValue(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74762_e(NBT_HUNGER_VALUE);
    }

    public final int getSaturationValue(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74762_e(NBT_SATURATION_VALUE);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/FeedSpellEffect$Companion;", "", "()V", "NBT_HUNGER_VALUE", "", "NBT_SATURATION_VALUE", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

