/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.effect;

import com.davidm1a2.afraidofthedark.common.constants.ModParticles;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/GrowSpellEffect;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/AOTDSpellEffect;", "()V", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "procEffect", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "reducedParticles", "", "afraidofthedark"})
public final class GrowSpellEffect
extends AOTDSpellEffect {
    public GrowSpellEffect() {
        super(new ResourceLocation("afraidofthedark", "grow"));
    }

    @Override
    public void procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> instance, boolean reducedParticles) {
        BlockPos blockPos;
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(instance, "instance");
        ServerWorld world = state.getWorld();
        BlockPos position = state.getBlockPosition();
        BlockState blockState = world.func_180495_p(position);
        if (!(blockState.func_177230_c() instanceof IGrowable)) {
            blockPos = position.func_177984_a();
            Intrinsics.checkNotNullExpressionValue(blockPos, "position.above()");
            position = blockPos;
            blockState = world.func_180495_p(position);
        }
        if (blockState.func_177230_c() instanceof IGrowable) {
            if (reducedParticles) {
                Vector3d vector3d = state.getPosition();
                blockPos = world.func_234923_W_();
                Intrinsics.checkNotNullExpressionValue(blockPos, "world.dimension()");
                AOTDSpellEffect.Companion.createParticlesAround(1, 3, vector3d, (RegistryKey<World>)blockPos, ModParticles.INSTANCE.getGROW(), 2.0);
            } else {
                Vector3d vector3d = state.getPosition();
                blockPos = world.func_234923_W_();
                Intrinsics.checkNotNullExpressionValue(blockPos, "world.dimension()");
                AOTDSpellEffect.Companion.createParticlesAround(8, 16, vector3d, (RegistryKey<World>)blockPos, ModParticles.INSTANCE.getGROW(), 2.0);
            }
            blockPos = blockState.func_177230_c();
            if (blockPos == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.block.IGrowable");
            }
            ((IGrowable)blockPos).func_225535_a_(world, world.field_73012_v, position, blockState);
        }
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return 15.0;
    }
}

