/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.effect;

import com.davidm1a2.afraidofthedark.common.constants.ModParticles;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.FloatSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.IntSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentProperty;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0014\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\f\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0016\u001a\u00020\tJ\u001c\u0010\u0017\u001a\u00020\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0018\u001a\u00020\tJ\u001c\u0010\u0019\u001a\u00020\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001a\u001a\u00020\u000e\u00a8\u0006\u001c"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/PotionEffectSpellEffect;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/AOTDSpellEffect;", "()V", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "getPotionDuration", "", "getPotionRadius", "", "getPotionStrength", "getPotionType", "Lnet/minecraft/potion/Effect;", "procEffect", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "reducedParticles", "", "setPotionDuration", "duration", "setPotionStrength", "strength", "setPotionType", "effect", "Companion", "afraidofthedark"})
public final class PotionEffectSpellEffect
extends AOTDSpellEffect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_POTION_TYPE = "potion_type";
    @NotNull
    private static final String NBT_POTION_STRENGTH = "potion_strength";
    @NotNull
    private static final String NBT_POTION_DURATION = "potion_duration";
    @NotNull
    private static final String NBT_POTION_RADIUS = "potion_radius";

    public PotionEffectSpellEffect() {
        super(new ResourceLocation("afraidofthedark", "potion_effect"));
        this.addEditableProperty(new SpellComponentProperty("Potion Type", "The type of potion effect to apply. Must be using the minecraft naming convention, like 'minecraft:speed'.", 1.INSTANCE, 2.INSTANCE, 3.INSTANCE));
        this.addEditableProperty(((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.intProperty().withName("Potion Strength")).withDescription("The level of the potion to apply, ex. 4 means apply 'Potion Type' at level 4.")).withSetter(4.INSTANCE)).withGetter(5.INSTANCE)).withDefaultValue(1)).withMinValue(1)).build());
        this.addEditableProperty(((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.intProperty().withName("Potion Duration")).withDescription("The number of ticks the potion effect should run for.")).withSetter(6.INSTANCE)).withGetter(7.INSTANCE)).withDefaultValue(20)).withMinValue(1)).build());
        this.addEditableProperty(((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.floatProperty().withName("Potion Cloud Radius")).withDescription("The size of the potion cloud if the potion is delivered to a block and not an entity.")).withSetter(8.INSTANCE)).withGetter(9.INSTANCE)).withDefaultValue(Float.valueOf(2.0f))).withMinValue(Float.valueOf(0.0f))).build());
    }

    @Override
    public void procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> instance, boolean reducedParticles) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(instance, "instance");
        Vector3d exactPosition = state.getPosition();
        Effect potionType = this.getPotionType(instance);
        int potionStrength = this.getPotionStrength(instance);
        int potionDuration = this.getPotionDuration(instance);
        Entity entityHit = state.getEntity();
        if (entityHit != null) {
            if (entityHit instanceof LivingEntity) {
                RegistryKey registryKey = ((LivingEntity)entityHit).field_70170_p.func_234923_W_();
                Intrinsics.checkNotNullExpressionValue(registryKey, "entityHit.level.dimension()");
                AOTDSpellEffect.Companion.createParticlesAt(1, 3, exactPosition, (RegistryKey<World>)registryKey, ModParticles.INSTANCE.getSPELL_HIT());
                ((LivingEntity)entityHit).func_195064_c(new EffectInstance(potionType, potionDuration, potionStrength));
            }
        } else {
            World world = (World)state.getWorld();
            AreaEffectCloudEntity aoePotion = new AreaEffectCloudEntity(world, exactPosition.field_72450_a, exactPosition.field_72448_b, exactPosition.field_72449_c);
            aoePotion.func_184496_a(new EffectInstance(potionType, potionDuration, potionStrength));
            Entity entity = state.getCasterEntity();
            aoePotion.func_184481_a(entity instanceof LivingEntity ? (LivingEntity)entity : null);
            aoePotion.func_184483_a(this.getPotionRadius(instance));
            aoePotion.func_184487_c(0.0f);
            aoePotion.func_184486_b(potionDuration);
            world.func_217376_c((Entity)aoePotion);
            entity = world.func_234923_W_();
            Intrinsics.checkNotNullExpressionValue(entity, "world.dimension()");
            AOTDSpellEffect.Companion.createParticlesAt(2, 6, exactPosition, (RegistryKey<World>)entity, ModParticles.INSTANCE.getSPELL_HIT());
        }
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        float f = this.getPotionRadius(instance);
        boolean bl = false;
        f = (float)Math.sqrt(f);
        float f2 = 1.0f;
        boolean bl2 = false;
        return 15.0 + (double)((float)(this.getPotionDuration(instance) * this.getPotionStrength(instance)) * Math.max(f, f2));
    }

    public final void setPotionType(@NotNull SpellComponentInstance<SpellEffect> instance, @NotNull Effect effect) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        Intrinsics.checkNotNullParameter(effect, "effect");
        instance.getData().func_74778_a(NBT_POTION_TYPE, String.valueOf(effect.getRegistryName()));
    }

    @NotNull
    public final Effect getPotionType(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(instance.getData().func_74779_i(NBT_POTION_TYPE)));
        Intrinsics.checkNotNull(effect);
        Effect effect2 = effect;
        return effect2;
    }

    public final void setPotionStrength(@NotNull SpellComponentInstance<SpellEffect> instance, int strength) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        instance.getData().func_74768_a(NBT_POTION_STRENGTH, strength);
    }

    public final int getPotionStrength(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74762_e(NBT_POTION_STRENGTH);
    }

    public final void setPotionDuration(@NotNull SpellComponentInstance<SpellEffect> instance, int duration) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        instance.getData().func_74768_a(NBT_POTION_DURATION, duration);
    }

    public final int getPotionDuration(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74762_e(NBT_POTION_DURATION);
    }

    public final float getPotionRadius(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74760_g(NBT_POTION_RADIUS);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/PotionEffectSpellEffect$Companion;", "", "()V", "NBT_POTION_DURATION", "", "NBT_POTION_RADIUS", "NBT_POTION_STRENGTH", "NBT_POTION_TYPE", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

