/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.tileEntity;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IPlayerVoidChestData;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.constants.ModTileEntities;
import com.davidm1a2.afraidofthedark.common.dimension.IslandUtility;
import com.davidm1a2.afraidofthedark.common.dimension.PlayerTeleportExtensionsKt;
import com.davidm1a2.afraidofthedark.common.network.handler.PacketHandler;
import com.davidm1a2.afraidofthedark.common.network.packets.other.VoidChestPacket;
import com.davidm1a2.afraidofthedark.common.tileEntity.core.AOTDTickingTileEntity;
import com.mojang.authlib.GameProfile;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.NameTagItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012J\u0010\u0010%\u001a\u00020#2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020\u001dH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/davidm1a2/afraidofthedark/common/tileEntity/VoidChestTileEntity;", "Lcom/davidm1a2/afraidofthedark/common/tileEntity/core/AOTDTickingTileEntity;", "Lnet/minecraft/tileentity/IChestLid;", "()V", "friends", "", "Ljava/util/UUID;", "indexToGoTo", "", "lastInteraction", "", "<set-?>", "", "lidAngle", "getLidAngle", "()F", "owner", "playerToSend", "Lnet/minecraft/entity/player/PlayerEntity;", "previousLidAngle", "getPreviousLidAngle", "shouldBeOpen", "", "getID", "playerName", "", "getOpenNess", "partialTicks", "interact", "", "entityPlayer", "load", "blockState", "Lnet/minecraft/block/BlockState;", "compound", "Lnet/minecraft/nbt/CompoundNBT;", "openChest", "save", "tick", "Companion", "afraidofthedark"})
public final class VoidChestTileEntity
extends AOTDTickingTileEntity
implements IChestLid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float lidAngle;
    private float previousLidAngle;
    private boolean shouldBeOpen;
    @Nullable
    private UUID owner;
    @NotNull
    private final Set<UUID> friends;
    private int indexToGoTo;
    @Nullable
    private PlayerEntity playerToSend;
    private long lastInteraction;
    @NotNull
    private static final String NBT_OWNER = "owner";
    @NotNull
    private static final String NBT_INDEX_TO_GO_TO = "index_to_go_to";
    @NotNull
    private static final String NBT_FRIENDS = "friends";
    private static final int MILLIS_TO_CLOSE_CHEST = 2000;
    private static final double PULL_FORCE = 1.0;
    private static final float OPEN_CLOSE_SPEED = 0.1f;
    private static final double DISTANCE_TO_SEND_PLAYER = 2.0;

    public VoidChestTileEntity() {
        super(ModTileEntities.INSTANCE.getVOID_CHEST());
        boolean bl = false;
        this.friends = new LinkedHashSet();
    }

    public final float getLidAngle() {
        return this.lidAngle;
    }

    public final float getPreviousLidAngle() {
        return this.previousLidAngle;
    }

    public float func_195480_a(float partialTicks) {
        return this.lidAngle;
    }

    @Override
    public void func_73660_a() {
        Vector3d velocity22;
        World world;
        super.func_73660_a();
        int x = this.func_174877_v().func_177958_n();
        int y = this.func_174877_v().func_177956_o();
        int z = this.func_174877_v().func_177952_p();
        if (this.getTicksExisted() % (long)10 == 0L && System.currentTimeMillis() - this.lastInteraction > 2000L) {
            this.shouldBeOpen = false;
        }
        this.previousLidAngle = this.lidAngle;
        if (this.shouldBeOpen && this.lidAngle == 0.0f) {
            world = this.field_145850_b;
            Intrinsics.checkNotNull(world);
            World world2 = world;
            double d = (double)x + 0.5;
            double d2 = (double)y + 0.5;
            double d3 = (double)z + 0.5;
            world = this.field_145850_b;
            Intrinsics.checkNotNull(world);
            world2.func_184148_a(null, d, d2, d3, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.shouldBeOpen && this.playerToSend != null) {
            Vector3d vector3d = Vector3d.func_237489_a_((Vector3i)((Vector3i)this.func_174877_v()));
            PlayerEntity playerEntity = this.playerToSend;
            Intrinsics.checkNotNull(playerEntity);
            double d = playerEntity.func_226277_ct_();
            playerEntity = this.playerToSend;
            Intrinsics.checkNotNull(playerEntity);
            double d4 = playerEntity.func_226278_cu_();
            playerEntity = this.playerToSend;
            Intrinsics.checkNotNull(playerEntity);
            velocity22 = vector3d.func_178786_a(d, d4, playerEntity.func_226281_cx_()).func_72432_b();
            PlayerEntity playerEntity2 = this.playerToSend;
            Intrinsics.checkNotNull(playerEntity2);
            double distanceSqToPlayer = playerEntity2.func_195048_a(Vector3d.func_237489_a_((Vector3i)((Vector3i)this.func_174877_v())));
            Vector3d adjustedVelocity = velocity22.func_186678_a(RangesKt.coerceIn(1.0 / distanceSqToPlayer, 0.01, 0.25));
            PlayerEntity playerEntity3 = this.playerToSend;
            Intrinsics.checkNotNull(playerEntity3);
            playerEntity3.func_70024_g(adjustedVelocity.field_72450_a, adjustedVelocity.field_72448_b, adjustedVelocity.field_72449_c);
        }
        if (!this.shouldBeOpen && this.lidAngle > 0.0f || this.shouldBeOpen && this.lidAngle < 1.0f) {
            this.lidAngle = this.shouldBeOpen ? this.lidAngle + 0.1f : this.lidAngle - 0.1f;
            this.lidAngle = RangesKt.coerceIn(this.lidAngle, 0.0f, 1.0f);
            if ((double)this.lidAngle < 0.5 && (double)this.previousLidAngle >= 0.5) {
                velocity22 = this.field_145850_b;
                Intrinsics.checkNotNull(velocity22);
                Vector3d vector3d = velocity22;
                double d = (double)x + 0.5;
                double d5 = (double)y + 0.5;
                double d6 = (double)z + 0.5;
                velocity22 = this.field_145850_b;
                Intrinsics.checkNotNull(velocity22);
                vector3d.func_184148_a(null, d, d5, d6, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, velocity22.field_73012_v.nextFloat() * 0.1f + 0.9f);
                if (this.playerToSend != null) {
                    velocity22 = this.field_145850_b;
                    Intrinsics.checkNotNull(velocity22);
                    if (Intrinsics.areEqual(velocity22.func_234923_W_(), World.field_234918_g_)) {
                        velocity22 = this.playerToSend;
                        Intrinsics.checkNotNull(velocity22);
                        double velocity22 = velocity22.func_195048_a(Vector3d.func_237489_a_((Vector3i)((Vector3i)this.func_174877_v())));
                        boolean bl = false;
                        if (Math.sqrt(velocity22) < 2.0) {
                            World velocity22 = this.field_145850_b;
                            Intrinsics.checkNotNull(velocity22);
                            if (!velocity22.field_72995_K) {
                                PlayerEntity playerEntity = this.playerToSend;
                                Intrinsics.checkNotNull(playerEntity);
                                IPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData(playerEntity);
                                playerEntity = this.playerToSend;
                                Intrinsics.checkNotNull(playerEntity);
                                if (Intrinsics.areEqual(playerEntity.func_146103_bH().getId(), this.owner)) {
                                    playerVoidChestData.setFriendsIndex(-1);
                                } else {
                                    playerVoidChestData.setFriendsIndex(this.indexToGoTo);
                                }
                                playerEntity = this.playerToSend;
                                if (playerEntity == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
                                }
                                PlayerTeleportExtensionsKt.teleport((ServerPlayerEntity)playerEntity, ModDimensions.INSTANCE.getVOID_CHEST_WORLD());
                            }
                        }
                    } else {
                        world = this.field_145850_b;
                        Intrinsics.checkNotNull(world);
                        if (!world.field_72995_K) {
                            world = this.playerToSend;
                            Intrinsics.checkNotNull(world);
                            World world3 = world;
                            ITextComponent iTextComponent = (ITextComponent)new TranslationTextComponent("message.afraidofthedark.void_chest.wrong_dimension");
                            world = this.playerToSend;
                            Intrinsics.checkNotNull(world);
                            world3.func_145747_a(iTextComponent, world.func_110124_au());
                        }
                    }
                }
            }
        }
    }

    public final void interact(@NotNull PlayerEntity entityPlayer) {
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        World world = this.field_145850_b;
        Intrinsics.checkNotNull(world);
        if (!world.field_72995_K) {
            ItemStack heldItem;
            if (this.owner == null) {
                this.owner = entityPlayer.func_146103_bH().getId();
                World world2 = this.field_145850_b;
                Intrinsics.checkNotNull(world2);
                MinecraftServer minecraftServer = world2.func_73046_m();
                Intrinsics.checkNotNull(minecraftServer);
                Object[] objectArray = minecraftServer.func_71218_a(ModDimensions.INSTANCE.getVOID_CHEST_WORLD());
                Intrinsics.checkNotNull(objectArray);
                Object[] objectArray2 = objectArray;
                World voidChestWorld = (World)objectArray2;
                IPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData(entityPlayer);
                this.indexToGoTo = IslandUtility.INSTANCE.getOrAssignPlayerPositionalIndex(voidChestWorld, playerVoidChestData);
                objectArray = new Object[]{entityPlayer.func_146103_bH().getName()};
                entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.void_chest.owner_set", objectArray), entityPlayer.func_110124_au());
            } else if (Intrinsics.areEqual(entityPlayer.func_146103_bH().getId(), this.owner)) {
                heldItem = entityPlayer.func_184614_ca();
                if (heldItem.func_77973_b() instanceof NameTagItem) {
                    Object[] objectArray = heldItem.func_151000_E().getString();
                    Intrinsics.checkNotNullExpressionValue(objectArray, "heldItem.displayName.string");
                    UUID friendsUUID = this.getID((String)objectArray);
                    if (friendsUUID != null) {
                        if (!this.friends.contains(friendsUUID)) {
                            this.friends.add(friendsUUID);
                            objectArray = new Object[]{heldItem.func_151000_E()};
                            entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.void_chest.friend_add", objectArray), entityPlayer.func_110124_au());
                        } else {
                            this.friends.remove(friendsUUID);
                            objectArray = new Object[]{heldItem.func_151000_E()};
                            entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.void_chest.friend_remove", objectArray), entityPlayer.func_110124_au());
                        }
                    } else {
                        objectArray = new Object[]{heldItem.func_151000_E()};
                        entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.void_chest.invalid_account", objectArray), entityPlayer.func_110124_au());
                    }
                } else {
                    this.openChest(entityPlayer);
                    PacketHandler packetHandler = AfraidOfTheDark.Companion.getPacketHandler();
                    VoidChestPacket voidChestPacket = new VoidChestPacket((Entity)entityPlayer, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
                    RegistryKey registryKey = World.field_234918_g_;
                    Intrinsics.checkNotNullExpressionValue(registryKey, "OVERWORLD");
                    packetHandler.sendToDimension(voidChestPacket, (RegistryKey<World>)registryKey);
                }
            } else if (this.friends.contains(entityPlayer.func_146103_bH().getId())) {
                heldItem = entityPlayer.func_184614_ca();
                if (heldItem.func_77973_b() instanceof NameTagItem) {
                    entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.void_chest.no_edit_access"), entityPlayer.func_110124_au());
                } else {
                    this.openChest(entityPlayer);
                    PacketHandler packetHandler = AfraidOfTheDark.Companion.getPacketHandler();
                    VoidChestPacket voidChestPacket = new VoidChestPacket((Entity)entityPlayer, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
                    RegistryKey registryKey = World.field_234918_g_;
                    Intrinsics.checkNotNullExpressionValue(registryKey, "OVERWORLD");
                    packetHandler.sendToDimension(voidChestPacket, (RegistryKey<World>)registryKey);
                }
            } else {
                entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.void_chest.no_access"), entityPlayer.func_110124_au());
            }
        }
    }

    public final void openChest(@Nullable PlayerEntity entityPlayer) {
        this.lastInteraction = System.currentTimeMillis();
        this.shouldBeOpen = true;
        this.playerToSend = entityPlayer;
    }

    private final UUID getID(String playerName) {
        World world = this.field_145850_b;
        Intrinsics.checkNotNull(world);
        MinecraftServer minecraftServer = world.func_73046_m();
        Intrinsics.checkNotNull(minecraftServer);
        GameProfile gameProfileForUsername = minecraftServer.func_152358_ax().func_152655_a(playerName);
        minecraftServer = gameProfileForUsername;
        return minecraftServer == null ? null : minecraftServer.getId();
    }

    @Override
    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        super.func_189515_b(compound);
        if (this.owner != null) {
            UUID uUID = this.owner;
            Intrinsics.checkNotNull(uUID);
            compound.func_186854_a(NBT_OWNER, uUID);
        }
        compound.func_74768_a(NBT_INDEX_TO_GO_TO, this.indexToGoTo);
        ListNBT friendNBT = new ListNBT();
        Iterable $this$forEach$iv = this.friends;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            friendNBT.add((Object)LongNBT.func_229698_a_((long)it.getLeastSignificantBits()));
            friendNBT.add((Object)LongNBT.func_229698_a_((long)it.getMostSignificantBits()));
        }
        compound.func_218657_a(NBT_FRIENDS, (INBT)friendNBT);
        return compound;
    }

    @Override
    public void func_230337_a_(@NotNull BlockState blockState, @NotNull CompoundNBT compound) {
        Intrinsics.checkNotNullParameter(blockState, "blockState");
        Intrinsics.checkNotNullParameter(compound, "compound");
        super.func_230337_a_(blockState, compound);
        this.owner = compound.func_74764_b("ownerMost") && compound.func_74764_b("ownerLeast") ? compound.func_186857_a(NBT_OWNER) : (UUID)null;
        this.indexToGoTo = compound.func_74762_e(NBT_INDEX_TO_GO_TO);
        ListNBT friendIDParts = compound.func_150295_c(NBT_FRIENDS, 4);
        for (int i = 0; i < friendIDParts.size(); i += 2) {
            INBT friendIDLeast = friendIDParts.get(i);
            INBT friendIDMost = friendIDParts.get(i + 1);
            if (!(friendIDLeast instanceof LongNBT) || !(friendIDMost instanceof LongNBT)) continue;
            this.friends.add(new UUID(((LongNBT)friendIDMost).func_150291_c(), ((LongNBT)friendIDLeast).func_150291_c()));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/tileEntity/VoidChestTileEntity$Companion;", "", "()V", "DISTANCE_TO_SEND_PLAYER", "", "MILLIS_TO_CLOSE_CHEST", "", "NBT_FRIENDS", "", "NBT_INDEX_TO_GO_TO", "NBT_OWNER", "OPEN_CLOSE_SPEED", "", "PULL_FORCE", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

