/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.biomes.extras;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001MB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\tH\u0002J \u00105\u001a\u0002062\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0005H\u0002J \u0010;\u001a\u00020\u00032\u0006\u00100\u001a\u0002012\u0006\u0010(\u001a\u00020)2\u0006\u0010<\u001a\u00020\tH\u0016J\b\u0010=\u001a\u000206H\u0002J\b\u0010>\u001a\u000206H\u0002J\b\u0010?\u001a\u000206H\u0002J\b\u0010@\u001a\u000206H\u0002J\u0010\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\tH\u0002J\u0018\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020\tH\u0002J\u0010\u0010G\u001a\u0002092\u0006\u0010H\u001a\u00020\u0015H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010I\u001a\u00020\u0015H\u0002J\u0018\u0010J\u001a\u0002062\u0006\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020\tH\u0002J\b\u0010K\u001a\u000206H\u0016J\b\u0010L\u001a\u00020\u0003H\u0002R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\b\u0012\u00060\u0013R\u00020\u0000\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000e\"\u0004\b!\u0010\u0010R\u001a\u0010\"\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001a\u0010%\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000e\"\u0004\b'\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u000e\"\u0004\b,\u0010\u0010R\u001a\u0010-\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001c\"\u0004\b/\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/davidm1a2/afraidofthedark/common/biomes/extras/AOTDWorldGenBigTree;", "Lnet/minecraft/world/gen/feature/WorldGenAbstractTree;", "notify", "", "wood", "Lnet/minecraft/block/state/IBlockState;", "leaves", "(ZLnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;)V", "basePos", "Lnet/minecraft/util/math/BlockPos;", "kotlin.jvm.PlatformType", "branchSlope", "", "getBranchSlope", "()D", "setBranchSlope", "(D)V", "foliageCoords", "", "Lcom/davidm1a2/afraidofthedark/common/biomes/extras/AOTDWorldGenBigTree$FoliageCoordinates;", "height", "", "heightAttenuation", "getHeightAttenuation", "setHeightAttenuation", "heightLimit", "heightLimitMax", "getHeightLimitMax", "()I", "setHeightLimitMax", "(I)V", "leafDensity", "getLeafDensity", "setLeafDensity", "leafDistanceLimit", "getLeafDistanceLimit", "setLeafDistanceLimit", "leafIntegrity", "getLeafIntegrity", "setLeafIntegrity", "rand", "Ljava/util/Random;", "scaleWidth", "getScaleWidth", "setScaleWidth", "trunkSize", "getTrunkSize", "setTrunkSize", "world", "Lnet/minecraft/world/World;", "checkBlockLine", "posOne", "posTwo", "crossSection", "", "pos", "leafSize", "", "leafBlock", "generate", "position", "generateLeafNodeBases", "generateLeafNodeList", "generateLeaves", "generateTrunk", "getGreatestDistance", "posIn", "getLogAxis", "Lnet/minecraft/block/BlockLog$EnumAxis;", "startBlockPos", "endBlockPos", "layerSize", "y", "leafDistance", "limb", "setDecorationDefaults", "validTreeLocation", "FoliageCoordinates", "afraidofthedark"})
public final class AOTDWorldGenBigTree
extends WorldGenAbstractTree {
    private Random rand;
    private World world;
    private BlockPos basePos;
    private int heightLimit;
    private int height;
    private List<FoliageCoordinates> foliageCoords;
    private double heightAttenuation;
    private double branchSlope;
    private double scaleWidth;
    private double leafDensity;
    private int trunkSize;
    private int heightLimitMax;
    private int leafDistanceLimit;
    private double leafIntegrity;
    private final IBlockState wood;
    private final IBlockState leaves;

    public final double getHeightAttenuation() {
        return this.heightAttenuation;
    }

    public final void setHeightAttenuation(double d) {
        this.heightAttenuation = d;
    }

    public final double getBranchSlope() {
        return this.branchSlope;
    }

    public final void setBranchSlope(double d) {
        this.branchSlope = d;
    }

    public final double getScaleWidth() {
        return this.scaleWidth;
    }

    public final void setScaleWidth(double d) {
        this.scaleWidth = d;
    }

    public final double getLeafDensity() {
        return this.leafDensity;
    }

    public final void setLeafDensity(double d) {
        this.leafDensity = d;
    }

    public final int getTrunkSize() {
        return this.trunkSize;
    }

    public final void setTrunkSize(int n) {
        this.trunkSize = n;
    }

    public final int getHeightLimitMax() {
        return this.heightLimitMax;
    }

    public final void setHeightLimitMax(int n) {
        this.heightLimitMax = n;
    }

    public final int getLeafDistanceLimit() {
        return this.leafDistanceLimit;
    }

    public final void setLeafDistanceLimit(int n) {
        this.leafDistanceLimit = n;
    }

    public final double getLeafIntegrity() {
        return this.leafIntegrity;
    }

    public final void setLeafIntegrity(double d) {
        this.leafIntegrity = d;
    }

    public boolean func_180709_b(@NotNull World world, @NotNull Random rand, @NotNull BlockPos position) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(rand, "rand");
        Intrinsics.checkParameterIsNotNull(position, "position");
        this.world = world;
        this.basePos = position;
        this.rand = new Random(rand.nextLong());
        if (this.heightLimit == 0) {
            Random random = this.rand;
            if (random == null) {
                Intrinsics.throwUninitializedPropertyAccessException("rand");
            }
            this.heightLimit = 5 + random.nextInt(this.heightLimitMax);
        }
        if (!this.validTreeLocation()) {
            this.world = null;
            bl = false;
        } else {
            this.generateLeafNodeList();
            this.generateLeaves();
            this.generateTrunk();
            this.generateLeafNodeBases();
            this.world = null;
            bl = true;
        }
        return bl;
    }

    public void func_175904_e() {
        this.leafDistanceLimit = 5;
    }

    private final boolean validTreeLocation() {
        boolean bl;
        IBlockState blockBelowTreeState;
        BlockPos posBelowTree = this.basePos.func_177977_b();
        World world = this.world;
        if (world == null) {
            Intrinsics.throwNpe();
        }
        IBlockState iBlockState = blockBelowTreeState = world.func_180495_p(posBelowTree);
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "blockBelowTreeState");
        Block block = iBlockState.func_177230_c();
        World world2 = this.world;
        if (world2 == null) {
            Intrinsics.throwNpe();
        }
        Block block2 = Blocks.field_150345_g;
        if (block2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraftforge.common.IPlantable");
        }
        boolean isSoil = block.canSustainPlant(blockBelowTreeState, (IBlockAccess)world2, posBelowTree, EnumFacing.UP, (IPlantable)block2);
        if (!isSoil) {
            bl = false;
        } else {
            BlockPos blockPos = this.basePos;
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "basePos");
            BlockPos blockPos2 = this.basePos.func_177981_b(this.heightLimit - 1);
            Intrinsics.checkExpressionValueIsNotNull(blockPos2, "basePos.up(heightLimit - 1)");
            int blocksAvailableAbove = this.checkBlockLine(blockPos, blockPos2);
            if (blocksAvailableAbove == -1) {
                bl = true;
            } else if (blocksAvailableAbove < 6) {
                bl = false;
            } else {
                this.heightLimit = blocksAvailableAbove;
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateLeafNodeList() {
        List list;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        double d = this.leafDensity * (double)this.heightLimit / 13.0;
        double d2 = 2.0;
        double d3 = 1.382;
        int n = 0;
        double d4 = Math.pow(d, d2);
        int leafDensityConverted = (int)(d3 + d4);
        if (leafDensityConverted < 1) {
            leafDensityConverted = 1;
        }
        BlockPos blockPos = this.basePos;
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "basePos");
        int maxHeight = blockPos.func_177956_o() + this.height;
        int k = this.heightLimit - this.leafDistanceLimit;
        AOTDWorldGenBigTree aOTDWorldGenBigTree = this;
        boolean bl = false;
        aOTDWorldGenBigTree.foliageCoords = list = (List)new ArrayList();
        List<FoliageCoordinates> list2 = this.foliageCoords;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        BlockPos blockPos2 = this.basePos.func_177981_b(k);
        Intrinsics.checkExpressionValueIsNotNull(blockPos2, "basePos.up(k)");
        list2.add(new FoliageCoordinates(blockPos2, maxHeight));
        while (k >= 0) {
            float f = this.layerSize(k);
            if (f >= 0.0f) {
                int n2 = 0;
                n = leafDensityConverted;
                while (n2 < n) {
                    void l;
                    double d5 = this.scaleWidth * (double)f;
                    Random random = this.rand;
                    if (random == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("rand");
                    }
                    double d0 = d5 * ((double)random.nextFloat() + 0.328);
                    Random random2 = this.rand;
                    if (random2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("rand");
                    }
                    double d1 = (double)(random2.nextFloat() * 2.0f) * Math.PI;
                    double d6 = d0;
                    boolean bl2 = false;
                    d4 = Math.sin(d1);
                    double d22 = d6 * d4 + 0.5;
                    d6 = d0;
                    boolean bl3 = false;
                    d4 = Math.cos(d1);
                    double d32 = d6 * d4 + 0.5;
                    BlockPos blockpos = this.basePos.func_177963_a(d22, (double)(k - 1), d32);
                    BlockPos blockpos1 = blockpos.func_177981_b(this.leafDistanceLimit);
                    BlockPos blockPos3 = blockpos;
                    Intrinsics.checkExpressionValueIsNotNull(blockPos3, "blockpos");
                    BlockPos blockPos4 = blockpos1;
                    Intrinsics.checkExpressionValueIsNotNull(blockPos4, "blockpos1");
                    if (this.checkBlockLine(blockPos3, blockPos4) == -1) {
                        BlockPos blockPos5 = this.basePos;
                        Intrinsics.checkExpressionValueIsNotNull(blockPos5, "basePos");
                        int i1 = blockPos5.func_177958_n() - blockpos.func_177958_n();
                        BlockPos blockPos6 = this.basePos;
                        Intrinsics.checkExpressionValueIsNotNull(blockPos6, "basePos");
                        int j1 = blockPos6.func_177952_p() - blockpos.func_177952_p();
                        double d7 = i1 * i1 + j1 * j1;
                        d6 = blockpos.func_177956_o();
                        boolean bl4 = false;
                        d4 = Math.sqrt(d7);
                        double d42 = d6 - d4 * this.branchSlope;
                        int k1 = d42 > (double)maxHeight ? maxHeight : (int)d42;
                        BlockPos blockPos7 = this.basePos;
                        Intrinsics.checkExpressionValueIsNotNull(blockPos7, "basePos");
                        int n3 = blockPos7.func_177958_n();
                        BlockPos blockPos8 = this.basePos;
                        Intrinsics.checkExpressionValueIsNotNull(blockPos8, "basePos");
                        BlockPos blockpos2 = new BlockPos(n3, k1, blockPos8.func_177952_p());
                        if (this.checkBlockLine(blockpos2, blockpos) == -1) {
                            List<FoliageCoordinates> list3 = this.foliageCoords;
                            if (list3 == null) {
                                Intrinsics.throwNpe();
                            }
                            list3.add(new FoliageCoordinates(blockpos, blockpos2.func_177956_o()));
                        }
                    }
                    ++l;
                }
            }
            --k;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void crossSection(BlockPos pos, float leafSize, IBlockState leafBlock) {
        block11: {
            int i = (int)((double)leafSize + 0.618);
            int n = -i;
            int n2 = i;
            if (n > n2) break block11;
            while (true) {
                void j;
                block12: {
                    int n3;
                    int n4;
                    if ((n4 = -i) > (n3 = i)) break block12;
                    while (true) {
                        void k;
                        block13: {
                            BlockPos blockpos;
                            block14: {
                                IBlockState state;
                                boolean bl = false;
                                double d = (double)Math.abs((int)j) + 0.5;
                                double d2 = 2.0;
                                boolean bl2 = false;
                                double d3 = Math.pow(d, d2);
                                boolean bl3 = false;
                                int n5 = Math.abs((int)k);
                                double d4 = (double)n5 + 0.5;
                                d2 = 2.0;
                                bl2 = false;
                                double d5 = Math.pow(d4, d2);
                                if (!(d3 + d5 <= (double)(leafSize * leafSize))) break block13;
                                blockpos = pos.func_177982_a((int)j, 0, (int)k);
                                World world = this.world;
                                if (world == null) {
                                    Intrinsics.throwNpe();
                                }
                                IBlockState iBlockState = state = world.func_180495_p(blockpos);
                                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "state");
                                Block block = iBlockState.func_177230_c();
                                World world2 = this.world;
                                if (world2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                if (block.isAir(state, (IBlockAccess)world2, blockpos)) break block14;
                                Block block2 = state.func_177230_c();
                                World world3 = this.world;
                                if (world3 == null) {
                                    Intrinsics.throwNpe();
                                }
                                if (!block2.isLeaves(state, (IBlockAccess)world3, blockpos)) break block13;
                            }
                            Random random = this.rand;
                            if (random == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("rand");
                            }
                            if (random.nextDouble() < this.leafIntegrity) {
                                World world = this.world;
                                if (world == null) {
                                    Intrinsics.throwNpe();
                                }
                                this.func_175903_a(world, blockpos, leafBlock);
                            }
                        }
                        if (k == n3) break;
                        ++k;
                    }
                }
                if (j == n2) break;
                ++j;
            }
        }
    }

    private final float layerSize(int y) {
        float f;
        if ((float)y < (float)this.heightLimit * 0.3f) {
            f = -1.0f;
        } else {
            float f2 = (float)this.heightLimit / 2.0f;
            float f1 = f2 - (float)y;
            float f3 = f2 * f2 - f1 * f1;
            boolean bl = false;
            float f22 = (float)Math.sqrt(f3);
            if (f1 == 0.0f) {
                f22 = f2;
            } else {
                boolean bl2 = false;
                if (Math.abs(f1) >= f2) {
                    return 0.0f;
                }
            }
            f = f22 * 0.5f;
        }
        return f;
    }

    private final float leafSize(int leafDistance) {
        int n = leafDistance;
        return 0 <= n && this.leafDistanceLimit > n ? (leafDistance != 0 && leafDistance != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    /*
     * WARNING - void declaration
     */
    private final void limb(BlockPos startBlockPos, BlockPos endBlockPos) {
        BlockPos blockpos;
        BlockPos blockPos = blockpos = endBlockPos.func_177982_a(-startBlockPos.func_177958_n(), -startBlockPos.func_177956_o(), -startBlockPos.func_177952_p());
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "blockpos");
        int i = this.getGreatestDistance(blockPos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        int n = 0;
        int n2 = i;
        if (n <= n2) {
            while (true) {
                void j;
                BlockPos blockpos1;
                BlockPos blockPos2 = blockpos1 = startBlockPos.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
                Intrinsics.checkExpressionValueIsNotNull(blockPos2, "blockpos1");
                BlockLog.EnumAxis logAxis = this.getLogAxis(startBlockPos, blockPos2);
                World world = this.world;
                if (world == null) {
                    Intrinsics.throwNpe();
                }
                this.func_175903_a(world, blockpos1, this.wood.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)logAxis));
                if (j == n2) break;
                ++j;
            }
        }
    }

    private final int getGreatestDistance(BlockPos posIn) {
        int n = posIn.func_177958_n();
        int n2 = 0;
        int i = Math.abs(n);
        n2 = posIn.func_177956_o();
        int n3 = 0;
        int j = Math.abs(n2);
        n3 = posIn.func_177952_p();
        boolean bl = false;
        int k = Math.abs(n3);
        return k > i && k > j ? k : (j > i ? j : i);
    }

    private final BlockLog.EnumAxis getLogAxis(BlockPos startBlockPos, BlockPos endBlockPos) {
        BlockLog.EnumAxis logAxis = BlockLog.EnumAxis.Y;
        int n = endBlockPos.func_177958_n() - startBlockPos.func_177958_n();
        int n2 = 0;
        int xDistance = Math.abs(n);
        n2 = endBlockPos.func_177952_p() - startBlockPos.func_177952_p();
        boolean bl = false;
        int zDistance = Math.abs(n2);
        bl = false;
        int k = Math.max(xDistance, zDistance);
        if (k > 0) {
            logAxis = xDistance == k ? BlockLog.EnumAxis.X : BlockLog.EnumAxis.Z;
        }
        return logAxis;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateLeaves() {
        List<FoliageCoordinates> list = this.foliageCoords;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (FoliageCoordinates foliageCoordinates : list) {
            int n = 0;
            int n2 = this.leafDistanceLimit;
            while (n < n2) {
                void i;
                BlockPos blockPos = foliageCoordinates.func_177981_b((int)i);
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "foliageCoordinates.up(i)");
                float f = this.leafSize((int)i);
                IBlockState iBlockState = this.leaves.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.FALSE);
                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "leaves.withProperty(Bloc\u2026 java.lang.Boolean.FALSE)");
                this.crossSection(blockPos, f, iBlockState);
                ++i;
            }
        }
    }

    private final void generateTrunk() {
        BlockPos blockpos = this.basePos;
        BlockPos blockpos1 = this.basePos.func_177981_b(this.height);
        BlockPos blockPos = blockpos;
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "blockpos");
        BlockPos blockPos2 = blockpos1;
        Intrinsics.checkExpressionValueIsNotNull(blockPos2, "blockpos1");
        this.limb(blockPos, blockPos2);
        if (this.trunkSize == 2) {
            BlockPos blockPos3 = blockpos.func_177974_f();
            Intrinsics.checkExpressionValueIsNotNull(blockPos3, "blockpos.east()");
            BlockPos blockPos4 = blockpos1.func_177974_f();
            Intrinsics.checkExpressionValueIsNotNull(blockPos4, "blockpos1.east()");
            this.limb(blockPos3, blockPos4);
            BlockPos blockPos5 = blockpos.func_177974_f().func_177968_d();
            Intrinsics.checkExpressionValueIsNotNull(blockPos5, "blockpos.east().south()");
            BlockPos blockPos6 = blockpos1.func_177974_f().func_177968_d();
            Intrinsics.checkExpressionValueIsNotNull(blockPos6, "blockpos1.east().south()");
            this.limb(blockPos5, blockPos6);
            BlockPos blockPos7 = blockpos.func_177968_d();
            Intrinsics.checkExpressionValueIsNotNull(blockPos7, "blockpos.south()");
            BlockPos blockPos8 = blockpos1.func_177968_d();
            Intrinsics.checkExpressionValueIsNotNull(blockPos8, "blockpos1.south()");
            this.limb(blockPos7, blockPos8);
        }
    }

    private final void generateLeafNodeBases() {
        List<FoliageCoordinates> list = this.foliageCoords;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (FoliageCoordinates foliageCoordinates : list) {
            int i = foliageCoordinates.getBranchBase();
            BlockPos blockPos = this.basePos;
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "basePos");
            int n = blockPos.func_177958_n();
            BlockPos blockPos2 = this.basePos;
            Intrinsics.checkExpressionValueIsNotNull(blockPos2, "basePos");
            BlockPos blockpos = new BlockPos(n, i, blockPos2.func_177952_p());
            if (!(Intrinsics.areEqual(blockpos, (Object)foliageCoordinates) ^ true)) continue;
            BlockPos blockPos3 = this.basePos;
            Intrinsics.checkExpressionValueIsNotNull(blockPos3, "basePos");
            if (!((double)(i - blockPos3.func_177956_o()) >= (double)this.heightLimit * 0.2)) continue;
            this.limb(blockpos, foliageCoordinates);
            World world = this.world;
            if (world == null) {
                Intrinsics.throwNpe();
            }
            this.func_175903_a(world, foliageCoordinates.func_177981_b(this.leafDistanceLimit / 2), this.wood.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int checkBlockLine(BlockPos posOne, BlockPos posTwo) {
        int n;
        BlockPos blockpos;
        BlockPos blockPos = blockpos = posTwo.func_177982_a(-posOne.func_177958_n(), -posOne.func_177956_o(), -posOne.func_177952_p());
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "blockpos");
        int i = this.getGreatestDistance(blockPos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        if (i == 0) {
            n = -1;
        } else {
            int n2 = 0;
            int n3 = i;
            if (n2 <= n3) {
                while (true) {
                    void j;
                    BlockPos blockpos1 = posOne.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
                    World world = this.world;
                    if (world == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!this.isReplaceable(world, blockpos1)) {
                        return (int)j;
                    }
                    if (j == n3) break;
                    ++j;
                }
            }
            n = -1;
        }
        return n;
    }

    public AOTDWorldGenBigTree(boolean notify, @NotNull IBlockState wood, @NotNull IBlockState leaves) {
        Intrinsics.checkParameterIsNotNull(wood, "wood");
        Intrinsics.checkParameterIsNotNull(leaves, "leaves");
        super(notify);
        this.wood = wood;
        this.leaves = leaves;
        this.basePos = BlockPos.field_177992_a;
        this.heightAttenuation = 0.618;
        this.branchSlope = 0.381;
        this.scaleWidth = 1.0;
        this.leafDensity = 1.0;
        this.trunkSize = 1;
        this.heightLimitMax = 16;
        this.leafDistanceLimit = 4;
        this.leafIntegrity = 1.0;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/biomes/extras/AOTDWorldGenBigTree$FoliageCoordinates;", "Lnet/minecraft/util/math/BlockPos;", "pos", "branchBase", "", "(Lcom/davidm1a2/afraidofthedark/common/biomes/extras/AOTDWorldGenBigTree;Lnet/minecraft/util/math/BlockPos;I)V", "getBranchBase", "()I", "afraidofthedark"})
    private final class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public final int getBranchBase() {
            return this.branchBase;
        }

        public FoliageCoordinates(BlockPos pos, int branchBase) {
            Intrinsics.checkParameterIsNotNull(pos, "pos");
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = branchBase;
        }
    }
}

