/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.block.mangrove;

import com.davidm1a2.afraidofthedark.common.block.core.AOTDBlockSapling;
import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/davidm1a2/afraidofthedark/common/block/mangrove/BlockMangroveSapling;", "Lcom/davidm1a2/afraidofthedark/common/block/core/AOTDBlockSapling;", "()V", "causeTreeToGrow", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "random", "Ljava/util/Random;", "generateBase", "generateBranches", "topOfTrunk", "generateLeafCluster", "location", "setBlockIfPossible", "blockState", "Companion", "afraidofthedark"})
public final class BlockMangroveSapling
extends AOTDBlockSapling {
    private static final IBlockState MANGROVE_LOG_UP;
    private static final IBlockState MANGROVE_LEAVES;
    private static final Set<Block> REPLACEABLE_BLOCKS;
    public static final Companion Companion;

    @Override
    public void causeTreeToGrow(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Random random) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(random, "random");
        Block block = Blocks.field_150350_a;
        Intrinsics.checkExpressionValueIsNotNull(block, "Blocks.AIR");
        world.func_175656_a(pos, block.func_176223_P());
        BlockPos topOfTrunk = this.generateBase(world, pos, random);
        this.generateBranches(world, topOfTrunk, random);
    }

    /*
     * WARNING - void declaration
     */
    private final BlockPos generateBase(World world, BlockPos pos, Random random) {
        int heightBeforeTrunk = random.nextInt(4) + 4;
        int numRoots = random.nextInt(5) + 4;
        int n = 0;
        int n2 = numRoots;
        while (n < n2) {
            void i;
            EnumFacing xOffsetDirection = random.nextBoolean() ? EnumFacing.NORTH : EnumFacing.SOUTH;
            EnumFacing zOffsetDirection = random.nextBoolean() ? EnumFacing.EAST : EnumFacing.WEST;
            int xDistanceFromTrunk = random.nextInt(3) + 3;
            int zDistanceFromTrunk = random.nextInt(3) + 3;
            BlockPos currentPos = pos.func_177967_a(xOffsetDirection, xDistanceFromTrunk).func_177967_a(zOffsetDirection, zDistanceFromTrunk);
            int n3 = 0;
            int n4 = heightBeforeTrunk;
            while (n3 < n4) {
                void j;
                if (xDistanceFromTrunk != 0 && random.nextBoolean()) {
                    currentPos = currentPos.func_177972_a(xOffsetDirection.func_176734_d());
                    --xDistanceFromTrunk;
                }
                if (zDistanceFromTrunk != 0 && random.nextBoolean()) {
                    currentPos = currentPos.func_177972_a(zOffsetDirection.func_176734_d());
                    --zDistanceFromTrunk;
                }
                BlockPos blockPos = currentPos;
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "currentPos");
                IBlockState iBlockState = MANGROVE_LOG_UP;
                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "MANGROVE_LOG_UP");
                this.setBlockIfPossible(world, blockPos, iBlockState);
                if (random.nextDouble() < 0.1) {
                    BlockPos blockPos2 = random.nextBoolean() ? currentPos.func_177984_a() : currentPos.func_177977_b();
                    Intrinsics.checkExpressionValueIsNotNull(blockPos2, "if (random.nextBoolean()\u2026() else currentPos.down()");
                    IBlockState iBlockState2 = MANGROVE_LOG_UP;
                    Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "MANGROVE_LOG_UP");
                    this.setBlockIfPossible(world, blockPos2, iBlockState2);
                }
                currentPos = currentPos.func_177984_a();
                ++j;
            }
            while (xDistanceFromTrunk > 0 || zDistanceFromTrunk > 0) {
                if (xDistanceFromTrunk != 0) {
                    currentPos = currentPos.func_177972_a(xOffsetDirection.func_176734_d());
                    --xDistanceFromTrunk;
                }
                if (zDistanceFromTrunk != 0) {
                    currentPos = currentPos.func_177972_a(zOffsetDirection.func_176734_d());
                    --zDistanceFromTrunk;
                }
                BlockPos blockPos = currentPos;
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "currentPos");
                IBlockState iBlockState = MANGROVE_LOG_UP;
                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "MANGROVE_LOG_UP");
                this.setBlockIfPossible(world, blockPos, iBlockState);
            }
            ++i;
        }
        int trunkHeight = random.nextInt(4) + 6;
        BlockPos currentPos = pos.func_177981_b(heightBeforeTrunk);
        int xOffsetDirection = 0;
        int n5 = trunkHeight;
        while (xOffsetDirection < n5) {
            void i;
            if (random.nextDouble() < 0.1) {
                currentPos = currentPos.func_177972_a(EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)]);
            }
            BlockPos blockPos = currentPos;
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "currentPos");
            IBlockState iBlockState = MANGROVE_LOG_UP;
            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "MANGROVE_LOG_UP");
            this.setBlockIfPossible(world, blockPos, iBlockState);
            currentPos = currentPos.func_177984_a();
            ++i;
        }
        BlockPos blockPos = currentPos;
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "currentPos");
        return blockPos;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateBranches(World world, BlockPos topOfTrunk, Random random) {
        this.generateLeafCluster(world, topOfTrunk, random);
        int numBranches = random.nextInt(3) + 3;
        int n = 0;
        int n2 = numBranches;
        while (n < n2) {
            void i;
            EnumFacing branchDir1 = EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)];
            EnumFacing branchDir2 = random.nextBoolean() ? branchDir1.func_176746_e() : branchDir1.func_176735_f();
            int branchLength = random.nextInt(5) + 3;
            BlockPos currentBranchPos = topOfTrunk.func_177972_a(random.nextBoolean() ? branchDir1 : branchDir2);
            int n3 = 0;
            int n4 = branchLength;
            while (n3 < n4) {
                void j;
                BlockPos blockPos = currentBranchPos;
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "currentBranchPos");
                IBlockState iBlockState = MANGROVE_LOG_UP;
                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "MANGROVE_LOG_UP");
                this.setBlockIfPossible(world, blockPos, iBlockState);
                if (random.nextDouble() < 0.1) {
                    this.generateLeafCluster(world, currentBranchPos, random);
                }
                currentBranchPos = currentBranchPos.func_177972_a(random.nextBoolean() ? branchDir1 : branchDir2);
                if (random.nextDouble() < 0.2) {
                    currentBranchPos = currentBranchPos.func_177984_a();
                }
                ++j;
            }
            BlockPos blockPos = currentBranchPos;
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "currentBranchPos");
            this.generateLeafCluster(world, blockPos, random);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateLeafCluster(World world, BlockPos location, Random random) {
        IBlockState iBlockState = MANGROVE_LOG_UP;
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "MANGROVE_LOG_UP");
        this.setBlockIfPossible(world, location, iBlockState);
        int n = -2;
        int n2 = 2;
        while (n <= n2) {
            void x;
            int n3 = -1;
            int n4 = 1;
            while (n3 <= n4) {
                void y;
                int n5 = -2;
                int n6 = 2;
                while (n5 <= n6) {
                    void z;
                    BlockPos leafPos = location.func_177982_a((int)x, (int)y, (int)z);
                    double d = leafPos.func_177951_i((Vec3i)location);
                    int n7 = 0;
                    double d2 = Math.sqrt(d);
                    double d3 = y == false ? 2.5 : 2.0;
                    if (d2 < d3 && random.nextDouble() < 0.9) {
                        if (random.nextDouble() < 0.03) {
                            BlockPos blockPos = leafPos;
                            Intrinsics.checkExpressionValueIsNotNull(blockPos, "leafPos");
                            IBlockState iBlockState2 = MANGROVE_LOG_UP;
                            Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "MANGROVE_LOG_UP");
                            this.setBlockIfPossible(world, blockPos, iBlockState2);
                            int vineLength = random.nextInt(3) + 2;
                            int n8 = 1;
                            n7 = vineLength;
                            if (n8 <= n7) {
                                while (true) {
                                    void i;
                                    BlockPos blockPos2 = leafPos.func_177979_c((int)i);
                                    Intrinsics.checkExpressionValueIsNotNull(blockPos2, "leafPos.down(i)");
                                    IBlockState iBlockState3 = MANGROVE_LEAVES;
                                    Intrinsics.checkExpressionValueIsNotNull(iBlockState3, "MANGROVE_LEAVES");
                                    this.setBlockIfPossible(world, blockPos2, iBlockState3);
                                    if (i != n7) {
                                        ++i;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else {
                            BlockPos blockPos = leafPos;
                            Intrinsics.checkExpressionValueIsNotNull(blockPos, "leafPos");
                            IBlockState iBlockState4 = MANGROVE_LEAVES;
                            Intrinsics.checkExpressionValueIsNotNull(iBlockState4, "MANGROVE_LEAVES");
                            this.setBlockIfPossible(world, blockPos, iBlockState4);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private final void setBlockIfPossible(World world, BlockPos location, IBlockState blockState) {
        IBlockState current;
        IBlockState iBlockState = current = world.func_180495_p(location);
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "current");
        if (REPLACEABLE_BLOCKS.contains(iBlockState.func_177230_c())) {
            world.func_175656_a(location, blockState);
        }
    }

    public BlockMangroveSapling() {
        super("mangrove_sapling");
    }

    static {
        Companion = new Companion(null);
        MANGROVE_LOG_UP = ModBlocks.INSTANCE.getMANGROVE().func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
        MANGROVE_LEAVES = ModBlocks.INSTANCE.getMANGROVE_LEAVES().func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        REPLACEABLE_BLOCKS = SetsKt.setOf((Block)Blocks.field_150329_H, Blocks.field_150350_a, (Block)Blocks.field_150362_t, (Block)Blocks.field_150361_u, (Block)Blocks.field_150355_j, (Block)Blocks.field_150358_i, (Block)Blocks.field_150349_c, (Block)ModBlocks.INSTANCE.getMANGROVE_LEAVES());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/common/block/mangrove/BlockMangroveSapling$Companion;", "", "()V", "MANGROVE_LEAVES", "Lnet/minecraft/block/state/IBlockState;", "kotlin.jvm.PlatformType", "MANGROVE_LOG_UP", "REPLACEABLE_BLOCKS", "", "Lnet/minecraft/block/Block;", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

