/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.capabilities.player.spell;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.IAOTDPlayerSpellManager;
import com.davidm1a2.afraidofthedark.common.packets.capabilityPackets.SyncClearSpells;
import com.davidm1a2.afraidofthedark.common.packets.capabilityPackets.SyncSpell;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/player/spell/AOTDPlayerSpellManagerImpl;", "Lcom/davidm1a2/afraidofthedark/common/capabilities/player/spell/IAOTDPlayerSpellManager;", "()V", "keybindToSpellId", "Lcom/google/common/collect/BiMap;", "", "Ljava/util/UUID;", "spellIdToSpell", "", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "addOrUpdateSpell", "", "spell", "clearSpells", "deleteSpell", "getKeybindingForSpell", "getSpellById", "spellId", "getSpellForKeybinding", "key", "getSpells", "", "isServerSide", "", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "keybindExists", "keybindSpell", "sync", "syncAll", "unbindSpell", "afraidofthedark"})
public final class AOTDPlayerSpellManagerImpl
implements IAOTDPlayerSpellManager {
    private final BiMap<String, UUID> keybindToSpellId;
    private final Map<UUID, Spell> spellIdToSpell;

    @Override
    public void addOrUpdateSpell(@NotNull Spell spell) {
        Intrinsics.checkParameterIsNotNull(spell, "spell");
        this.spellIdToSpell.put(spell.getId(), spell);
    }

    @Override
    public void deleteSpell(@NotNull Spell spell) {
        Intrinsics.checkParameterIsNotNull(spell, "spell");
        this.spellIdToSpell.remove(spell.getId());
        this.keybindToSpellId.inverse().remove((Object)spell.getId());
    }

    @Override
    public void clearSpells() {
        this.spellIdToSpell.clear();
        this.keybindToSpellId.clear();
    }

    @Override
    @NotNull
    public List<Spell> getSpells() {
        return CollectionsKt.toList((Iterable)this.spellIdToSpell.values());
    }

    @Override
    public void keybindSpell(@NotNull String key, @NotNull Spell spell) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(spell, "spell");
        if (this.spellIdToSpell.containsKey(spell.getId())) {
            this.keybindToSpellId.forcePut((Object)key, (Object)spell.getId());
        } else {
            AfraidOfTheDark.Companion.getINSTANCE().getLogger().error("Cannot bind a spell that isn't registered!");
        }
    }

    @Override
    public void unbindSpell(@NotNull Spell spell) {
        Intrinsics.checkParameterIsNotNull(spell, "spell");
        this.keybindToSpellId.inverse().remove((Object)spell.getId());
    }

    @Override
    public boolean keybindExists(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        return this.keybindToSpellId.containsKey((Object)key);
    }

    @Override
    @Nullable
    public String getKeybindingForSpell(@NotNull Spell spell) {
        Intrinsics.checkParameterIsNotNull(spell, "spell");
        return (String)this.keybindToSpellId.inverse().getOrDefault((Object)spell.getId(), null);
    }

    @Override
    @Nullable
    public Spell getSpellForKeybinding(@NotNull String key) {
        Spell spell;
        Intrinsics.checkParameterIsNotNull(key, "key");
        UUID spellUUID = (UUID)this.keybindToSpellId.getOrDefault((Object)key, null);
        if (spellUUID != null) {
            Map<UUID, Spell> map2 = this.spellIdToSpell;
            Object v = null;
            boolean bl = false;
            Map<UUID, Spell> map3 = map2;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            spell = map3.getOrDefault(spellUUID, (Spell)v);
        } else {
            spell = null;
        }
        return spell;
    }

    @Override
    @Nullable
    public Spell getSpellById(@NotNull UUID spellId) {
        Intrinsics.checkParameterIsNotNull(spellId, "spellId");
        Map<UUID, Spell> map2 = this.spellIdToSpell;
        Object v = null;
        boolean bl = false;
        Map<UUID, Spell> map3 = map2;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        return map3.getOrDefault(spellId, (Spell)v);
    }

    @Override
    public void syncAll(@NotNull EntityPlayer entityPlayer) {
        Intrinsics.checkParameterIsNotNull(entityPlayer, "entityPlayer");
        if (this.isServerSide(entityPlayer)) {
            AfraidOfTheDark.Companion.getINSTANCE().getPacketHandler().sendTo(new SyncClearSpells(), (EntityPlayerMP)entityPlayer);
        } else {
            AfraidOfTheDark.Companion.getINSTANCE().getPacketHandler().sendToServer(new SyncClearSpells());
        }
        Iterable $this$forEach$iv = this.spellIdToSpell.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Spell it = (Spell)element$iv;
            boolean bl = false;
            this.sync(entityPlayer, it);
        }
    }

    @Override
    public void sync(@NotNull EntityPlayer entityPlayer, @NotNull Spell spell) {
        Intrinsics.checkParameterIsNotNull(entityPlayer, "entityPlayer");
        Intrinsics.checkParameterIsNotNull(spell, "spell");
        String keybind = this.getKeybindingForSpell(spell);
        SyncSpell syncSpellPacket = new SyncSpell(spell, keybind);
        if (this.isServerSide(entityPlayer)) {
            AfraidOfTheDark.Companion.getINSTANCE().getPacketHandler().sendTo(syncSpellPacket, (EntityPlayerMP)entityPlayer);
        } else {
            AfraidOfTheDark.Companion.getINSTANCE().getPacketHandler().sendToServer(syncSpellPacket);
        }
    }

    private final boolean isServerSide(EntityPlayer entityPlayer) {
        return !entityPlayer.field_70170_p.field_72995_K;
    }

    public AOTDPlayerSpellManagerImpl() {
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkExpressionValueIsNotNull(hashBiMap, "HashBiMap.create()");
        this.keybindToSpellId = (BiMap)hashBiMap;
        AOTDPlayerSpellManagerImpl aOTDPlayerSpellManagerImpl = this;
        boolean bl = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        aOTDPlayerSpellManagerImpl.spellIdToSpell = linkedHashMap;
    }
}

