/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.dimension;

import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IAOTDIslandData;
import com.davidm1a2.afraidofthedark.common.capabilities.world.IslandVisitorData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockAir;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/dimension/IslandUtility;", "", "()V", "findValidSpawnLocation", "Lnet/minecraft/util/math/BlockPos;", "world", "Lnet/minecraft/world/World;", "blockPos", "searchDistance", "", "getOrAssignPlayerPositionalIndex", "islandData", "Lcom/davidm1a2/afraidofthedark/common/capabilities/player/dimension/IAOTDIslandData;", "isValidSpawnLocation", "", "afraidofthedark"})
public final class IslandUtility {
    public static final IslandUtility INSTANCE;

    public final int getOrAssignPlayerPositionalIndex(@NotNull World world, @NotNull IAOTDIslandData islandData) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(islandData, "islandData");
        if (islandData.getPositionalIndex() == -1) {
            IslandVisitorData islandVisitorData = IslandVisitorData.Companion.get(world);
            if (islandVisitorData == null) {
                Intrinsics.throwNpe();
            }
            int playersNewPositionalIndex = islandVisitorData.addAndReturnNewVisitor();
            islandData.setPositionalIndex(playersNewPositionalIndex);
        }
        return islandData.getPositionalIndex();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BlockPos findValidSpawnLocation(@NotNull World world, @NotNull BlockPos blockPos, int searchDistance) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        int xCenter = blockPos.func_177958_n();
        int yCenter = blockPos.func_177956_o();
        int zCenter = blockPos.func_177952_p();
        int n = xCenter - searchDistance / 2;
        int n2 = xCenter + searchDistance / 2;
        while (n < n2) {
            void x;
            int n3 = yCenter - searchDistance / 2;
            int n4 = yCenter + searchDistance / 2;
            while (n3 < n4) {
                void y;
                int n5 = zCenter - searchDistance / 2;
                int n6 = zCenter + searchDistance / 2;
                while (n5 < n6) {
                    void z;
                    if (this.isValidSpawnLocation(world, new BlockPos((int)x, (int)y, (int)z))) {
                        return new BlockPos((int)x, (int)y, (int)z);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidSpawnLocation(@NotNull World world, @NotNull BlockPos blockPos) {
        Material bottomBlockMaterial;
        IBlockState bottomBlock;
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        IBlockState iBlockState = bottomBlock = world.func_180495_p(blockPos);
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "bottomBlock");
        Material material = bottomBlockMaterial = iBlockState.func_185904_a();
        Intrinsics.checkExpressionValueIsNotNull(material, "bottomBlockMaterial");
        if (!material.func_76220_a()) return false;
        if (!bottomBlockMaterial.func_76230_c()) return false;
        IBlockState iBlockState2 = world.func_180495_p(blockPos.func_177984_a());
        Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "world.getBlockState(blockPos.up())");
        if (!(iBlockState2.func_177230_c() instanceof BlockAir)) return false;
        IBlockState iBlockState3 = world.func_180495_p(blockPos.func_177981_b(2));
        Intrinsics.checkExpressionValueIsNotNull(iBlockState3, "world.getBlockState(blockPos.up(2))");
        if (!(iBlockState3.func_177230_c() instanceof BlockAir)) return false;
        return true;
    }

    private IslandUtility() {
    }

    static {
        IslandUtility islandUtility;
        INSTANCE = islandUtility = new IslandUtility();
    }
}

