/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.dimension.nightmare;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.constants.ModBiomes;
import com.davidm1a2.afraidofthedark.common.constants.ModStructures;
import com.davidm1a2.afraidofthedark.common.worldGeneration.WorldExtensionsKt;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.StructureNightmareIsland;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J \u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/dimension/nightmare/NightmareChunkGenerator;", "Lnet/minecraft/world/gen/IChunkGenerator;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "generateChunk", "Lnet/minecraft/world/chunk/Chunk;", "x", "", "z", "generateStructures", "", "chunkIn", "getNearestStructurePos", "Lnet/minecraft/util/math/BlockPos;", "worldIn", "structureName", "", "position", "findUnexplored", "getPossibleCreatures", "", "Lnet/minecraft/world/biome/Biome$SpawnListEntry;", "creatureType", "Lnet/minecraft/entity/EnumCreatureType;", "pos", "isInsideStructure", "populate", "", "recreateStructures", "chunk", "afraidofthedark"})
public final class NightmareChunkGenerator
implements IChunkGenerator {
    private final World world;

    public boolean func_185933_a(@NotNull Chunk chunkIn, int x, int z) {
        Intrinsics.checkParameterIsNotNull(chunkIn, "chunkIn");
        return false;
    }

    @NotNull
    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] biome = chunk.func_76605_m();
        Intrinsics.checkExpressionValueIsNotNull(biome, "biome");
        ArraysKt.fill$default(biome, (byte)Biome.func_185362_a((Biome)ModBiomes.INSTANCE.getNIGHTMARE()), 0, 0, 6, null);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        int islandWidth = ModStructures.INSTANCE.getNIGHTMARE_ISLAND().getXWidth();
        int islandLength = ModStructures.INSTANCE.getNIGHTMARE_ISLAND().getZLength();
        int blocksBetweenIslands = AfraidOfTheDark.Companion.getINSTANCE().getConfigurationHandler().getBlocksBetweenIslands();
        int zPos = z * 16;
        if (zPos >= 0 && zPos <= islandLength + 15) {
            int xPos = x * 16;
            int islandIndex = xPos / blocksBetweenIslands;
            int relativeXPos = xPos % blocksBetweenIslands;
            if (relativeXPos >= 0 && relativeXPos <= islandWidth + 15) {
                BlockPos islandPos = new BlockPos(islandIndex * blocksBetweenIslands, 0, 0);
                StructureNightmareIsland structureNightmareIsland = ModStructures.INSTANCE.getNIGHTMARE_ISLAND();
                BiomeProvider biomeProvider = this.world.func_72959_q();
                Intrinsics.checkExpressionValueIsNotNull(biomeProvider, "world.biomeProvider");
                NBTTagCompound data = structureNightmareIsland.generateStructureData(this.world, islandPos, biomeProvider);
                ChunkPos chunkPos = new ChunkPos(x, z);
                ModStructures.INSTANCE.getNIGHTMARE_ISLAND().generate(this.world, chunkPos, data);
                WorldExtensionsKt.relightChunk(this.world, chunkPos);
            }
        }
    }

    @NotNull
    public List<Biome.SpawnListEntry> func_177458_a(@NotNull EnumCreatureType creatureType, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull(creatureType, "creatureType");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        List list = this.world.func_180494_b(pos).func_76747_a(creatureType);
        Intrinsics.checkExpressionValueIsNotNull(list, "world.getBiome(pos).getSpawnableList(creatureType)");
        return list;
    }

    @Nullable
    public BlockPos func_180513_a(@NotNull World worldIn, @NotNull String structureName, @NotNull BlockPos position, boolean findUnexplored) {
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Intrinsics.checkParameterIsNotNull(structureName, "structureName");
        Intrinsics.checkParameterIsNotNull(position, "position");
        return null;
    }

    public void func_180514_a(@NotNull Chunk chunk, int x, int z) {
        Intrinsics.checkParameterIsNotNull(chunk, "chunk");
    }

    public boolean func_193414_a(@NotNull World worldIn, @NotNull String structureName, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Intrinsics.checkParameterIsNotNull(structureName, "structureName");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        return false;
    }

    public NightmareChunkGenerator(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        this.world = world;
    }
}

