/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.entity.bolt;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014R\u0014\u0010\r\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/bolt/EntityBolt;", "Lnet/minecraft/entity/projectile/EntityThrowable;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "x", "", "y", "z", "(Lnet/minecraft/world/World;DDD)V", "thrower", "Lnet/minecraft/entity/EntityLivingBase;", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;)V", "chanceToDropHitEntity", "getChanceToDropHitEntity", "()D", "chanceToDropHitGround", "getChanceToDropHitGround", "damage", "", "getDamage", "()I", "damageSourceProducer", "Lkotlin/Function1;", "Lnet/minecraft/entity/player/EntityPlayer;", "Lnet/minecraft/util/DamageSource;", "getDamageSourceProducer", "()Lkotlin/jvm/functions/Function1;", "drop", "Lnet/minecraft/item/Item;", "getDrop", "()Lnet/minecraft/item/Item;", "onImpact", "", "result", "Lnet/minecraft/util/math/RayTraceResult;", "afraidofthedark"})
public abstract class EntityBolt
extends EntityThrowable {
    private final int damage = 6;
    private final double chanceToDropHitEntity = 0.4;
    private final double chanceToDropHitGround = 0.8;

    @NotNull
    public abstract Function1<EntityPlayer, DamageSource> getDamageSourceProducer();

    @NotNull
    public abstract Item getDrop();

    public int getDamage() {
        return this.damage;
    }

    public double getChanceToDropHitEntity() {
        return this.chanceToDropHitEntity;
    }

    public double getChanceToDropHitGround() {
        return this.chanceToDropHitGround;
    }

    protected void func_70184_a(@NotNull RayTraceResult result) {
        Intrinsics.checkParameterIsNotNull(result, "result");
        if (!this.field_70170_p.field_72995_K) {
            Entity entityHit = result.field_72308_g;
            if (entityHit != null) {
                if (this.field_70192_c instanceof EntityPlayer) {
                    EntityLivingBase entityLivingBase = this.field_70192_c;
                    if (entityLivingBase == null) {
                        throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                    }
                    entityHit.func_70097_a(this.getDamageSourceProducer().invoke((EntityPlayer)entityLivingBase), (float)this.getDamage());
                }
                if (Math.random() < this.getChanceToDropHitEntity()) {
                    entityHit.func_145779_a(this.getDrop(), 1);
                }
            } else if (Math.random() < this.getChanceToDropHitGround()) {
                this.func_145779_a(this.getDrop(), 1);
            }
        }
        this.func_70106_y();
    }

    public EntityBolt(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        super(world);
        this.damage = 6;
        this.chanceToDropHitEntity = 0.4;
        this.chanceToDropHitGround = 0.8;
    }

    public EntityBolt(@NotNull World world, double x, double y, double z) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        super(world, x, y, z);
        this.damage = 6;
        this.chanceToDropHitEntity = 0.4;
        this.chanceToDropHitGround = 0.8;
    }

    public EntityBolt(@NotNull World world, @NotNull EntityLivingBase thrower) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(thrower, "thrower");
        super(world, thrower);
        this.damage = 6;
        this.chanceToDropHitEntity = 0.4;
        this.chanceToDropHitGround = 0.8;
    }
}

