/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.entity.enaria;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IAOTDPlayerResearch;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.entity.enaria.EnariaAttacks;
import com.davidm1a2.afraidofthedark.common.entity.enaria.EntityAIAttackEnaria;
import com.davidm1a2.afraidofthedark.common.entity.enaria.EntityAIFollowPlayer;
import com.davidm1a2.afraidofthedark.common.entity.enaria.animation.ChannelArmthrow;
import com.davidm1a2.afraidofthedark.common.entity.enaria.animation.ChannelAutoattack;
import com.davidm1a2.afraidofthedark.common.entity.enaria.animation.ChannelSpell;
import com.davidm1a2.afraidofthedark.common.entity.enaria.animation.ChannelWalk;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.IMCAnimatedModel;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.AnimationHandler;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.ChannelMode;
import com.davidm1a2.afraidofthedark.common.packets.otherPackets.PlayEnariasFightMusic;
import com.davidm1a2.afraidofthedark.common.registry.research.Research;
import java.util.Iterator;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u001bH\u0014J\b\u0010$\u001a\u00020\u000eH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0016H\u0014J\b\u0010(\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001dH\u0016J\b\u0010+\u001a\u00020\u0016H\u0016J\b\u0010,\u001a\u00020\u0016H\u0016J\b\u0010-\u001a\u00020\u0016H\u0016J\u0010\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u00102\u001a\u00020\u00162\u0006\u0010/\u001a\u000200H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00064"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/enaria/EntityEnaria;", "Lnet/minecraft/entity/monster/EntityMob;", "Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/IMCAnimatedModel;", "world", "Lnet/minecraft/world/World;", "allowedRegion", "Lnet/minecraft/util/math/AxisAlignedBB;", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/AxisAlignedBB;)V", "(Lnet/minecraft/world/World;)V", "getAllowedRegion", "()Lnet/minecraft/util/math/AxisAlignedBB;", "setAllowedRegion", "(Lnet/minecraft/util/math/AxisAlignedBB;)V", "animHandler", "Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/animation/AnimationHandler;", "bossInfo", "Lnet/minecraft/world/BossInfoServer;", "enariaAttacks", "Lcom/davidm1a2/afraidofthedark/common/entity/enaria/EnariaAttacks;", "getEnariaAttacks", "()Lcom/davidm1a2/afraidofthedark/common/entity/enaria/EnariaAttacks;", "addTrackingPlayer", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "applyEntityAttributes", "attackEntityFrom", "", "source", "Lnet/minecraft/util/DamageSource;", "amount", "", "canBeRidden", "entityIn", "Lnet/minecraft/entity/Entity;", "canDespawn", "getAnimationHandler", "getDisplayName", "Lnet/minecraft/util/text/ITextComponent;", "initEntityAI", "isNonBoss", "onDeath", "cause", "onEntityUpdate", "onLivingUpdate", "onUpdate", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "removeTrackingPlayer", "writeEntityToNBT", "Companion", "afraidofthedark"})
public final class EntityEnaria
extends EntityMob
implements IMCAnimatedModel {
    private final AnimationHandler animHandler;
    private final BossInfoServer bossInfo;
    @NotNull
    public AxisAlignedBB allowedRegion;
    @NotNull
    private final EnariaAttacks enariaAttacks;
    private static final double MOVE_SPEED = 0.6;
    private static final double FOLLOW_RANGE = 64.0;
    private static final double MAX_HEALTH = 400.0;
    private static final double ATTACK_DAMAGE = 12.0;
    private static final double KNOCKBACK_RESISTANCE = 0.5;
    private static final double RESEARCH_UNLOCK_RANGE = 100.0;
    private static final String NBT_IS_VALID = "is_valid";
    private static final String NBT_LAST_HIT = "last_hit";
    private static final int MAX_DAMAGE_IN_1_HIT = 10;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AxisAlignedBB getAllowedRegion() {
        AxisAlignedBB axisAlignedBB = this.allowedRegion;
        if (axisAlignedBB == null) {
            Intrinsics.throwUninitializedPropertyAccessException("allowedRegion");
        }
        return axisAlignedBB;
    }

    public final void setAllowedRegion(@NotNull AxisAlignedBB axisAlignedBB) {
        Intrinsics.checkParameterIsNotNull(axisAlignedBB, "<set-?>");
        this.allowedRegion = axisAlignedBB;
    }

    @NotNull
    public final EnariaAttacks getEnariaAttacks() {
        return this.enariaAttacks;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackEnaria(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowPlayer((EntityLiving)this, 8.0, 128.0, 32.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 20.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.animHandler.update();
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K && (this.field_70159_w > 0.05 || this.field_70179_y > 0.05 || this.field_70159_w < -0.05 || this.field_70179_y < -0.05) && !this.animHandler.isAnimationActive("spell") && !this.animHandler.isAnimationActive("autoattack") && !this.animHandler.isAnimationActive("armthrow") && !this.animHandler.isAnimationActive("walk")) {
            AnimationHandler.playAnimation$default(this.animHandler, "walk", 0.0f, 2, null);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            if (this.field_70173_aa == 1 && !this.getEntityData().func_74767_n(NBT_IS_VALID)) {
                this.func_70106_y();
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        IAttributeInstance iAttributeInstance = this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        Intrinsics.checkExpressionValueIsNotNull(iAttributeInstance, "attributeMap.getAttribut\u2026terAttributes.MAX_HEALTH)");
        iAttributeInstance.func_111128_a(400.0);
        IAttributeInstance iAttributeInstance2 = this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b);
        Intrinsics.checkExpressionValueIsNotNull(iAttributeInstance2, "attributeMap.getAttribut\u2026rAttributes.FOLLOW_RANGE)");
        iAttributeInstance2.func_111128_a(64.0);
        IAttributeInstance iAttributeInstance3 = this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111266_c);
        Intrinsics.checkExpressionValueIsNotNull(iAttributeInstance3, "attributeMap.getAttribut\u2026tes.KNOCKBACK_RESISTANCE)");
        iAttributeInstance3.func_111128_a(0.5);
        IAttributeInstance iAttributeInstance4 = this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        Intrinsics.checkExpressionValueIsNotNull(iAttributeInstance4, "attributeMap.getAttribut\u2026ttributes.MOVEMENT_SPEED)");
        iAttributeInstance4.func_111128_a(0.6);
        IAttributeInstance iAttributeInstance5 = this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
        Intrinsics.checkExpressionValueIsNotNull(iAttributeInstance5, "attributeMap.getAttribut\u2026Attributes.ATTACK_DAMAGE)");
        iAttributeInstance5.func_111128_a(12.0);
    }

    public boolean func_70097_a(@NotNull DamageSource source, float amount) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        if (!this.field_70170_p.field_72995_K) {
            long timeBetweenHits = System.currentTimeMillis() - this.getEntityData().func_74763_f(NBT_LAST_HIT);
            this.getEntityData().func_74772_a(NBT_LAST_HIT, timeBetweenHits);
            float amount2 = amount;
            if (amount2 == FloatCompanionObject.INSTANCE.getMAX_VALUE()) {
                return super.func_70097_a(source, amount2);
            }
            if (amount2 > (float)10) {
                amount2 = 10;
            }
            if (source instanceof EntityDamageSource) {
                Entity damageSource = source.func_76346_g();
                if (damageSource instanceof EntityPlayer) {
                    IAOTDPlayerResearch iAOTDPlayerResearch = CapabilityExtensionsKt.getResearch((EntityPlayer)damageSource);
                    Research research = ModResearches.INSTANCE.getENARIA().getPreRequisite();
                    if (research == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!iAOTDPlayerResearch.isResearched(research)) {
                        damageSource.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:enaria.dont_understand", new Object[0]));
                        return false;
                    }
                }
                if (StringsKt.equals(source.field_76373_n, "silver_damage", true)) {
                    float f = 1.0f;
                    float f2 = (float)timeBetweenHits / 1000.0f;
                    boolean bl = false;
                    float amountModifier = Math.min(f, f2);
                    if (this.field_70146_Z.nextInt(40) == 0) {
                        this.enariaAttacks.randomTeleport();
                    }
                    return super.func_70097_a(source, amount2 * amountModifier);
                }
                if (this.field_70146_Z.nextInt(60) == 0) {
                    this.enariaAttacks.randomTeleport();
                }
            } else if (Intrinsics.areEqual(source, DamageSource.field_76379_h)) {
                if (this.field_70146_Z.nextBoolean()) {
                    this.enariaAttacks.randomTeleport();
                }
            } else if (this.field_70146_Z.nextInt(100) == 0) {
                this.enariaAttacks.randomTeleport();
            }
        }
        return (double)this.func_110143_aJ() >= 2.0 ? super.func_70097_a(DamageSource.field_76377_j, 1.0f) : false;
    }

    public void func_70645_a(@NotNull DamageSource cause) {
        Intrinsics.checkParameterIsNotNull(cause, "cause");
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && cause instanceof EntityDamageSource && cause.func_76346_g() instanceof EntityPlayer) {
            Iterator iterator2 = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(100.0)).iterator();
            while (iterator2.hasNext()) {
                EntityPlayer entityPlayer;
                EntityPlayer entityPlayer2 = entityPlayer = (EntityPlayer)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(entityPlayer2, "entityPlayer");
                IAOTDPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch(entityPlayer2);
                if (!playerResearch.canResearch(ModResearches.INSTANCE.getENARIA())) continue;
                playerResearch.setResearch(ModResearches.INSTANCE.getENARIA(), true);
                playerResearch.sync(entityPlayer, true);
            }
        }
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return (ITextComponent)new TextComponentString("\u00a7c\u00a7l" + this.func_95999_t());
    }

    protected boolean func_184228_n(@NotNull Entity entityIn) {
        Intrinsics.checkParameterIsNotNull(entityIn, "entityIn");
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    @NotNull
    public AnimationHandler getAnimationHandler() {
        return this.animHandler;
    }

    public void func_184178_b(@NotNull EntityPlayerMP player) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        super.func_184178_b(player);
        AfraidOfTheDark.Companion.getINSTANCE().getPacketHandler().sendTo(new PlayEnariasFightMusic(this, true), player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(@NotNull EntityPlayerMP player) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        super.func_184203_c(player);
        AfraidOfTheDark.Companion.getINSTANCE().getPacketHandler().sendTo(new PlayEnariasFightMusic(this, false), player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70014_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull(compound, "compound");
        super.func_70014_b(compound);
        AxisAlignedBB axisAlignedBB = this.allowedRegion;
        if (axisAlignedBB == null) {
            Intrinsics.throwUninitializedPropertyAccessException("allowedRegion");
        }
        compound.func_74780_a("minX", axisAlignedBB.field_72340_a);
        AxisAlignedBB axisAlignedBB2 = this.allowedRegion;
        if (axisAlignedBB2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("allowedRegion");
        }
        compound.func_74780_a("minY", axisAlignedBB2.field_72338_b);
        AxisAlignedBB axisAlignedBB3 = this.allowedRegion;
        if (axisAlignedBB3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("allowedRegion");
        }
        compound.func_74780_a("minZ", axisAlignedBB3.field_72339_c);
        AxisAlignedBB axisAlignedBB4 = this.allowedRegion;
        if (axisAlignedBB4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("allowedRegion");
        }
        compound.func_74780_a("maxX", axisAlignedBB4.field_72336_d);
        AxisAlignedBB axisAlignedBB5 = this.allowedRegion;
        if (axisAlignedBB5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("allowedRegion");
        }
        compound.func_74780_a("maxY", axisAlignedBB5.field_72337_e);
        AxisAlignedBB axisAlignedBB6 = this.allowedRegion;
        if (axisAlignedBB6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("allowedRegion");
        }
        compound.func_74780_a("maxZ", axisAlignedBB6.field_72334_f);
    }

    public void func_70037_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull(compound, "compound");
        super.func_70037_a(compound);
        this.allowedRegion = new AxisAlignedBB(compound.func_74769_h("minX"), compound.func_74769_h("minY"), compound.func_74769_h("minZ"), compound.func_74769_h("maxX"), compound.func_74769_h("maxY"), compound.func_74769_h("maxZ"));
    }

    public EntityEnaria(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        super(world);
        this.animHandler = new AnimationHandler(new ChannelWalk("walk", 59.0f, 59, ChannelMode.LINEAR), new ChannelArmthrow("armthrow", 61.0f, 61, ChannelMode.LINEAR), new ChannelAutoattack("autoattack", 70.0f, 51, ChannelMode.LINEAR), new ChannelSpell("spell", 90.0f, 121, ChannelMode.LINEAR));
        BossInfo bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
        if (bossInfo == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.world.BossInfoServer");
        }
        this.bossInfo = (BossInfoServer)bossInfo;
        this.func_70105_a(0.8f, 1.8f);
        this.func_96094_a("Enaria");
        this.bossInfo.func_186739_a(this.func_145748_c_());
        this.field_70728_aV = 300;
        this.field_70178_ae = true;
        Random random = this.field_70146_Z;
        Intrinsics.checkExpressionValueIsNotNull(random, "rand");
        this.enariaAttacks = new EnariaAttacks(this, random);
    }

    public EntityEnaria(@NotNull World world, @NotNull AxisAlignedBB allowedRegion) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(allowedRegion, "allowedRegion");
        this(world);
        this.getEntityData().func_74757_a(NBT_IS_VALID, true);
        this.allowedRegion = allowedRegion;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/enaria/EntityEnaria$Companion;", "", "()V", "ATTACK_DAMAGE", "", "FOLLOW_RANGE", "KNOCKBACK_RESISTANCE", "MAX_DAMAGE_IN_1_HIT", "", "MAX_HEALTH", "MOVE_SPEED", "NBT_IS_VALID", "", "NBT_LAST_HIT", "RESEARCH_UNLOCK_RANGE", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

