/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation;

import com.davidm1a2.afraidofthedark.client.entity.mcAnimatorLib.MCAModelRenderer;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.MathExtensionsKt;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.Channel;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.ChannelMode;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.CustomChannel;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.KeyFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nJ\b\u0010\u0013\u001a\u00020\u0011H\u0003J\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u000fH\u0007J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u001b\u001a\u00020\u0015J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0004H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/animation/AnimationHandler;", "", "animChannels", "", "Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/animation/Channel;", "([Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/animation/Channel;)V", "animCurrentChannels", "", "animCurrentFrame", "", "", "", "animPrevTime", "", "availableAnimChannels", "", "isAnimationActive", "", "name", "isGamePaused", "performAnimationInModel", "", "parts", "Lcom/davidm1a2/afraidofthedark/client/entity/mcAnimatorLib/MCAModelRenderer;", "playAnimation", "startingFrame", "stopAnimation", "update", "updateAnimation", "channel", "afraidofthedark"})
public final class AnimationHandler {
    private final Set<Channel> animCurrentChannels;
    private final Map<String, Long> animPrevTime;
    private final Map<String, Float> animCurrentFrame;
    private final Map<String, Channel> availableAnimChannels;

    public final void update() {
        Iterator<Channel> it = this.animCurrentChannels.iterator();
        while (it.hasNext()) {
            Channel anim = it.next();
            boolean animStatus = this.updateAnimation(anim);
            if (animStatus) continue;
            this.animPrevTime.remove(anim.getName());
            this.animCurrentFrame.remove(anim.getName());
            it.remove();
        }
    }

    public final void playAnimation(@NotNull String name, float startingFrame) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Channel channel = this.availableAnimChannels.get(name);
        if (channel != null) {
            this.animCurrentChannels.add(channel);
            this.animPrevTime.put(name, System.nanoTime());
            this.animCurrentFrame.put(name, Float.valueOf(startingFrame));
        } else {
            String string = "The animation called " + name + " doesn't exist!";
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    public static /* synthetic */ void playAnimation$default(AnimationHandler animationHandler, String string, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        animationHandler.playAnimation(string, f);
    }

    public final void stopAnimation(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Channel channel = this.availableAnimChannels.get(name);
        if (channel != null) {
            if (this.animCurrentChannels.contains(channel)) {
                this.animCurrentChannels.remove(channel);
                this.animPrevTime.remove(name);
                this.animCurrentFrame.remove(name);
            }
        } else {
            String string = "The animation called " + name + " doesn't exist!";
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    public final boolean isAnimationActive(@NotNull String name) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Iterable $this$any$iv = this.animCurrentChannels;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Channel it = (Channel)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getName(), name)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean updateAnimation(Channel channel) {
        boolean bl;
        Side side;
        FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
        Intrinsics.checkExpressionValueIsNotNull(fMLCommonHandler, "FMLCommonHandler.instance()");
        Side side2 = side = fMLCommonHandler.getEffectiveSide();
        Intrinsics.checkExpressionValueIsNotNull(side2, "side");
        if (side2.isServer() || side.isClient() && !this.isGamePaused()) {
            if (channel.getMode() != ChannelMode.CUSTOM) {
                long currentTime;
                double deltaTime;
                float numberOfSkippedFrames;
                float prevFrame;
                float currentFrame;
                Long l = this.animPrevTime.get(channel.getName());
                if (l == null) {
                    Intrinsics.throwNpe();
                }
                long prevTime = ((Number)l).longValue();
                Float f = this.animCurrentFrame.get(channel.getName());
                if (f == null) {
                    Intrinsics.throwNpe();
                }
                if ((currentFrame = (prevFrame = ((Number)f).floatValue()) + (numberOfSkippedFrames = (float)((deltaTime = (double)((currentTime = System.nanoTime()) - prevTime) / 1.0E9) * (double)channel.getFps()))) < (float)(channel.getTotalFrames() - 1)) {
                    this.animPrevTime.put(channel.getName(), currentTime);
                    this.animCurrentFrame.put(channel.getName(), Float.valueOf(currentFrame));
                    bl = true;
                } else {
                    if (channel.getMode() == ChannelMode.LOOP) {
                        this.animPrevTime.put(channel.getName(), currentTime);
                        this.animCurrentFrame.put(channel.getName(), Float.valueOf(0.0f));
                        return true;
                    }
                    bl = false;
                }
            } else {
                bl = true;
            }
        } else {
            long currentTime = System.nanoTime();
            this.animPrevTime.put(channel.getName(), currentTime);
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SideOnly(value=Side.CLIENT)
    private final boolean isGamePaused() {
        Minecraft minecraft;
        Minecraft minecraft2 = minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull(minecraft2, "minecraft");
        if (!minecraft2.func_71356_B()) return false;
        if (minecraft.field_71462_r == null) return false;
        GuiScreen guiScreen = minecraft.field_71462_r;
        if (guiScreen == null) {
            Intrinsics.throwNpe();
        }
        if (!guiScreen.func_73868_f()) return false;
        IntegratedServer integratedServer = minecraft.func_71401_C();
        if (integratedServer == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(integratedServer, "minecraft.integratedServer!!");
        if (integratedServer.func_71344_c()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @SideOnly(value=Side.CLIENT)
    public final void performAnimationInModel(@NotNull Map<String, MCAModelRenderer> parts) {
        Intrinsics.checkParameterIsNotNull(parts, "parts");
        Object object = parts;
        boolean bl = false;
        Iterator<Map.Entry<String, MCAModelRenderer>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, MCAModelRenderer> entry;
            Map.Entry<String, MCAModelRenderer> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            MCAModelRenderer box = entry2.getValue();
            boolean anyRotationApplied = false;
            boolean anyTranslationApplied = false;
            boolean anyCustomAnimationRunning = false;
            for (Channel channel : this.animCurrentChannels) {
                if (channel.getMode() != ChannelMode.CUSTOM) {
                    Vector3f currentPosition;
                    int n;
                    KeyFrame nextTranslationKeyFrame;
                    int n2;
                    boolean bl3;
                    KeyFrame prevTranslationKeyFrame;
                    int n3;
                    boolean bl4;
                    KeyFrame it;
                    KeyFrame nextRotationKeyFrame;
                    int n4;
                    boolean bl5;
                    void boxName;
                    KeyFrame prevRotationKeyFrame;
                    Float f = this.animCurrentFrame.get(channel.getName());
                    if (f == null) {
                        Intrinsics.throwNpe();
                    }
                    float currentFrame = ((Number)f).floatValue();
                    Float f2 = this.animCurrentFrame.get(channel.getName());
                    if (f2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((prevRotationKeyFrame = channel.getPreviousRotationKeyFrameForBox((String)boxName, ((Number)f2).floatValue())) != null) {
                        KeyFrame keyFrame;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        KeyFrame it2 = keyFrame;
                        bl5 = false;
                        n4 = channel.getKeyFramePosition(it2);
                    } else {
                        n4 = 0;
                    }
                    int prevRotationKeyFramePosition = n4;
                    Float f3 = this.animCurrentFrame.get(channel.getName());
                    if (f3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((nextRotationKeyFrame = channel.getNextRotationKeyFrameForBox((String)boxName, ((Number)f3).floatValue())) != null) {
                        KeyFrame keyFrame;
                        boolean it2 = false;
                        bl5 = false;
                        it = keyFrame;
                        bl4 = false;
                        n3 = channel.getKeyFramePosition(it);
                    } else {
                        n3 = 0;
                    }
                    int nextRotationKeyFramePosition = n3;
                    float slerpProgress = (currentFrame - (float)prevRotationKeyFramePosition) / (float)(nextRotationKeyFramePosition - prevRotationKeyFramePosition);
                    slerpProgress = RangesKt.coerceIn(slerpProgress, 0.0f, 1.0f);
                    if (prevRotationKeyFramePosition == 0 && prevRotationKeyFrame == null && nextRotationKeyFramePosition != 0) {
                        Quat4f currentQuat = new Quat4f();
                        Quat4f quat4f = box.getDefaultRotationAsQuat4f();
                        if (quat4f == null) {
                            Intrinsics.throwNpe();
                        }
                        KeyFrame keyFrame = nextRotationKeyFrame;
                        if (keyFrame == null) {
                            Intrinsics.throwNpe();
                        }
                        Quat4f quat4f2 = keyFrame.getModelRotations$afraidofthedark().get(boxName);
                        if (quat4f2 == null) {
                            Intrinsics.throwNpe();
                        }
                        MathExtensionsKt.slerp(currentQuat, quat4f, quat4f2, slerpProgress);
                        MathExtensionsKt.transposeAndReturn(MathExtensionsKt.setAndReturn(box.getRotationMatrix(), currentQuat));
                        anyRotationApplied = true;
                    } else if (prevRotationKeyFramePosition == 0 && prevRotationKeyFrame != null && nextRotationKeyFramePosition != 0) {
                        Quat4f currentQuat = new Quat4f();
                        Quat4f quat4f = prevRotationKeyFrame.getModelRotations$afraidofthedark().get(boxName);
                        if (quat4f == null) {
                            Intrinsics.throwNpe();
                        }
                        KeyFrame keyFrame = nextRotationKeyFrame;
                        if (keyFrame == null) {
                            Intrinsics.throwNpe();
                        }
                        Quat4f quat4f3 = keyFrame.getModelRotations$afraidofthedark().get(boxName);
                        if (quat4f3 == null) {
                            Intrinsics.throwNpe();
                        }
                        MathExtensionsKt.slerp(currentQuat, quat4f, quat4f3, slerpProgress);
                        MathExtensionsKt.transposeAndReturn(MathExtensionsKt.setAndReturn(box.getRotationMatrix(), currentQuat));
                        anyRotationApplied = true;
                    } else if (prevRotationKeyFramePosition != 0 && nextRotationKeyFramePosition != 0) {
                        Quat4f currentQuat = new Quat4f();
                        KeyFrame keyFrame = prevRotationKeyFrame;
                        if (keyFrame == null) {
                            Intrinsics.throwNpe();
                        }
                        Quat4f quat4f = keyFrame.getModelRotations$afraidofthedark().get(boxName);
                        if (quat4f == null) {
                            Intrinsics.throwNpe();
                        }
                        KeyFrame keyFrame2 = nextRotationKeyFrame;
                        if (keyFrame2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Quat4f quat4f4 = keyFrame2.getModelRotations$afraidofthedark().get(boxName);
                        if (quat4f4 == null) {
                            Intrinsics.throwNpe();
                        }
                        MathExtensionsKt.slerp(currentQuat, quat4f, quat4f4, slerpProgress);
                        MathExtensionsKt.transposeAndReturn(MathExtensionsKt.setAndReturn(box.getRotationMatrix(), currentQuat));
                        anyRotationApplied = true;
                    }
                    Float f4 = this.animCurrentFrame.get(channel.getName());
                    if (f4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((prevTranslationKeyFrame = channel.getPreviousTranslationKeyFrameForBox((String)boxName, ((Number)f4).floatValue())) != null) {
                        bl4 = false;
                        boolean bl8 = false;
                        KeyFrame it3 = it;
                        bl3 = false;
                        n2 = channel.getKeyFramePosition(it3);
                    } else {
                        n2 = 0;
                    }
                    int prevTranslationsKeyFramePosition = n2;
                    Float f5 = this.animCurrentFrame.get(channel.getName());
                    if (f5 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((nextTranslationKeyFrame = channel.getNextTranslationKeyFrameForBox((String)boxName, ((Number)f5).floatValue())) != null) {
                        KeyFrame keyFrame;
                        boolean it3 = false;
                        bl3 = false;
                        KeyFrame it4 = keyFrame;
                        boolean bl9 = false;
                        n = channel.getKeyFramePosition(it4);
                    } else {
                        n = 0;
                    }
                    int nextTranslationsKeyFramePosition = n;
                    float lerpProgress = (currentFrame - (float)prevTranslationsKeyFramePosition) / (float)(nextTranslationsKeyFramePosition - prevTranslationsKeyFramePosition);
                    lerpProgress = RangesKt.coerceAtMost(lerpProgress, 1.0f);
                    if (prevTranslationsKeyFramePosition == 0 && prevTranslationKeyFrame == null && nextTranslationsKeyFramePosition != 0) {
                        Vector3f startPosition = box.getRotationPointAsVector();
                        KeyFrame keyFrame = nextTranslationKeyFrame;
                        if (keyFrame == null) {
                            Intrinsics.throwNpe();
                        }
                        Vector3f endPosition = keyFrame.getModelTranslations$afraidofthedark().get(boxName);
                        currentPosition = new Vector3f(startPosition);
                        currentPosition.interpolate((Tuple3f)endPosition, lerpProgress);
                        box.func_78793_a(currentPosition.x, currentPosition.y, currentPosition.z);
                        anyTranslationApplied = true;
                        continue;
                    }
                    if (prevTranslationsKeyFramePosition == 0 && prevTranslationKeyFrame != null && nextTranslationsKeyFramePosition != 0) {
                        Vector3f startPosition = prevTranslationKeyFrame.getModelTranslations$afraidofthedark().get(boxName);
                        KeyFrame keyFrame = nextTranslationKeyFrame;
                        if (keyFrame == null) {
                            Intrinsics.throwNpe();
                        }
                        Vector3f endPosition = keyFrame.getModelTranslations$afraidofthedark().get(boxName);
                        currentPosition = new Vector3f(startPosition);
                        currentPosition.interpolate((Tuple3f)endPosition, lerpProgress);
                        box.func_78793_a(currentPosition.x, currentPosition.y, currentPosition.z);
                        anyTranslationApplied = true;
                        continue;
                    }
                    if (prevTranslationsKeyFramePosition == 0 || nextTranslationsKeyFramePosition == 0) continue;
                    KeyFrame keyFrame = prevTranslationKeyFrame;
                    if (keyFrame == null) {
                        Intrinsics.throwNpe();
                    }
                    Vector3f startPosition = keyFrame.getModelTranslations$afraidofthedark().get(boxName);
                    KeyFrame keyFrame3 = nextTranslationKeyFrame;
                    if (keyFrame3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Vector3f endPosition = keyFrame3.getModelTranslations$afraidofthedark().get(boxName);
                    currentPosition = new Vector3f(startPosition);
                    currentPosition.interpolate((Tuple3f)endPosition, lerpProgress);
                    box.func_78793_a(currentPosition.x, currentPosition.y, currentPosition.z);
                    anyTranslationApplied = true;
                    continue;
                }
                anyCustomAnimationRunning = true;
                Channel channel2 = channel;
                if (channel2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.CustomChannel");
                }
                ((CustomChannel)channel2).update(parts, this);
            }
            if (!anyRotationApplied && !anyCustomAnimationRunning) {
                box.resetRotationMatrix();
            }
            if (anyTranslationApplied || anyCustomAnimationRunning) continue;
            box.resetRotationPoint();
        }
    }

    /*
     * WARNING - void declaration
     */
    public AnimationHandler(Channel ... animChannels) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(animChannels, "animChannels");
        AnimationHandler animationHandler = this;
        boolean bl = false;
        Object object = new LinkedHashSet();
        animationHandler.animCurrentChannels = object;
        animationHandler = this;
        bl = false;
        animationHandler.animPrevTime = object = (Map)new LinkedHashMap();
        animationHandler = this;
        bl = false;
        animationHandler.animCurrentFrame = object = (Map)new LinkedHashMap();
        Channel[] channelArray = animChannels;
        animationHandler = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var7_10 = $this$mapTo$iv$iv;
        int n = ((void)var7_10).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_14 = item$iv$iv = var7_10[i];
            object = destination$iv$iv;
            boolean bl2 = false;
            Pair<String, void> pair = TuplesKt.to(it.getName(), it);
            object.add(pair);
        }
        object = (List)destination$iv$iv;
        animationHandler.availableAnimChannels = MapsKt.toMap((Iterable)object);
    }
}

