/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.entity.spell.projectile;

import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.IMCAnimatedModel;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.AnimationHandler;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.ChannelMode;
import com.davidm1a2.afraidofthedark.common.entity.spell.projectile.animation.ChannelSpellProjectileIdle;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionStateBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.SpellDeliveryMethodProjectile;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/BE\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0001H\u0014J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\u0011H\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J\b\u0010$\u001a\u00020\bH\u0017J\b\u0010%\u001a\u00020\u001cH\u0016J\b\u0010&\u001a\u00020!H\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020!H\u0016J\u0010\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020!2\u0006\u0010,\u001a\u00020-H\u0014R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/spell/projectile/EntitySpellProjectile;", "Lnet/minecraft/entity/Entity;", "Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/IMCAnimatedModel;", "world", "Lnet/minecraft/world/World;", "spell", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "spellIndex", "", "spellCaster", "position", "Lnet/minecraft/util/math/Vec3d;", "velocity", "shooter", "(Lnet/minecraft/world/World;Lcom/davidm1a2/afraidofthedark/common/spell/Spell;ILnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/entity/Entity;)V", "(Lnet/minecraft/world/World;)V", "animHandler", "Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/animation/AnimationHandler;", "blockDistanceRemaining", "", "spellCasterId", "Ljava/util/UUID;", "ticksInAir", "attackEntityFrom", "", "source", "Lnet/minecraft/util/DamageSource;", "amount", "", "canBeCollidedWith", "canBeRidden", "entityIn", "entityInit", "", "getAnimationHandler", "getBrightness", "getBrightnessForRender", "getCollisionBorderSize", "onEntityUpdate", "onImpact", "result", "Lnet/minecraft/util/math/RayTraceResult;", "onUpdate", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "writeEntityToNBT", "Companion", "afraidofthedark"})
public final class EntitySpellProjectile
extends Entity
implements IMCAnimatedModel {
    private int ticksInAir;
    private Spell spell;
    private int spellIndex;
    private Entity shooter;
    private UUID spellCasterId;
    private double blockDistanceRemaining;
    private final AnimationHandler animHandler;
    private static final String NBT_TICKS_IN_AIR = "ticks_in_air";
    private static final String NBT_MOTION_DIRECTION = "motion_direction";
    private static final String NBT_SPELL = "spell";
    private static final String NBT_SPELL_INDEX = "spell_index";
    private static final String NBT_BLOCK_DISTANCE_REMAINING = "block_distance_remaining";
    private static final String NBT_CASTER_ENTITY_ID = "caster_entity_id";
    public static final Companion Companion = new Companion(null);

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.animHandler.update();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
                int n = this.ticksInAir;
                this.ticksInAir = n + 1;
                RayTraceResult rayTraceResult = ProjectileHelper.func_188802_a((Entity)this, (boolean)true, (this.ticksInAir >= 25 ? 1 : 0) != 0, (Entity)this.shooter);
                if (rayTraceResult != null) {
                    this.onImpact(rayTraceResult);
                }
                this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                double distanceFlown = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72433_c();
                this.blockDistanceRemaining -= distanceFlown;
                if (this.blockDistanceRemaining <= 0.0) {
                    Entity entity;
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = new DeliveryTransitionStateBuilder();
                    Spell spell = this.spell;
                    if (spell == null) {
                        Intrinsics.throwUninitializedPropertyAccessException(NBT_SPELL);
                    }
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder2 = deliveryTransitionStateBuilder.withSpell(spell).withStageIndex(this.spellIndex);
                    World world = this.field_70170_p;
                    Intrinsics.checkExpressionValueIsNotNull(world, "world");
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder3 = deliveryTransitionStateBuilder2.withWorld(world);
                    Vec3d vec3d = this.func_174791_d();
                    Intrinsics.checkExpressionValueIsNotNull(vec3d, "this.positionVector");
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder4 = deliveryTransitionStateBuilder3.withPosition(vec3d);
                    BlockPos blockPos = this.func_180425_c();
                    Intrinsics.checkExpressionValueIsNotNull(blockPos, "this.position");
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder5 = deliveryTransitionStateBuilder4.withBlockPosition(blockPos).withDirection(new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y));
                    UUID uUID = this.spellCasterId;
                    if (uUID != null) {
                        UUID uUID2 = uUID;
                        DeliveryTransitionStateBuilder deliveryTransitionStateBuilder6 = deliveryTransitionStateBuilder5;
                        boolean bl = false;
                        boolean bl2 = false;
                        UUID it = uUID2;
                        boolean bl3 = false;
                        World world2 = this.field_70170_p;
                        if (!(world2 instanceof WorldServer)) {
                            world2 = null;
                        }
                        WorldServer worldServer = (WorldServer)world2;
                        Entity entity2 = worldServer != null ? worldServer.func_175733_a(it) : null;
                        deliveryTransitionStateBuilder5 = deliveryTransitionStateBuilder6;
                        entity = entity2;
                    } else {
                        entity = null;
                    }
                    DeliveryTransitionState state = deliveryTransitionStateBuilder5.withCasterEntity(entity).withDeliveryEntity(this).build();
                    Spell spell2 = this.spell;
                    if (spell2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException(NBT_SPELL);
                    }
                    SpellStage spellStage = spell2.getStage(this.spellIndex);
                    if (spellStage == null) {
                        Intrinsics.throwNpe();
                    }
                    SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = spellStage.getDeliveryInstance();
                    if (spellComponentInstance == null) {
                        Intrinsics.throwNpe();
                    }
                    SpellDeliveryMethod currentDeliveryMethod = spellComponentInstance.getComponent();
                    currentDeliveryMethod.procEffects(state);
                    currentDeliveryMethod.transitionFrom(state);
                    this.func_70106_y();
                }
            } else {
                this.func_70106_y();
            }
        }
    }

    private final void onImpact(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            Spell spell = this.spell;
            if (spell == null) {
                Intrinsics.throwUninitializedPropertyAccessException(NBT_SPELL);
            }
            SpellStage currentStage = spell.getStage(this.spellIndex);
            if (result.field_72313_a != RayTraceResult.Type.MISS) {
                SpellStage spellStage = currentStage;
                if (spellStage == null) {
                    Intrinsics.throwNpe();
                }
                SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = spellStage.getDeliveryInstance();
                if (spellComponentInstance == null) {
                    Intrinsics.throwNpe();
                }
                SpellDeliveryMethod currentDeliveryMethod = spellComponentInstance.getComponent();
                if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                    Entity entity;
                    BlockPos hitPos = new BlockPos(result.field_72307_f);
                    IBlockState iBlockState = this.field_70170_p.func_180495_p(hitPos);
                    Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(hitPos)");
                    if (Intrinsics.areEqual(iBlockState.func_177230_c(), Blocks.field_150350_a)) {
                        EnumFacing enumFacing = result.field_178784_b;
                        Intrinsics.checkExpressionValueIsNotNull(enumFacing, "result.sideHit");
                        BlockPos blockPos = hitPos.func_177972_a(enumFacing.func_176734_d());
                        Intrinsics.checkExpressionValueIsNotNull(blockPos, "hitPos.offset(result.sideHit.opposite)");
                        hitPos = blockPos;
                    }
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = new DeliveryTransitionStateBuilder();
                    Spell spell2 = this.spell;
                    if (spell2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException(NBT_SPELL);
                    }
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder2 = deliveryTransitionStateBuilder.withSpell(spell2).withStageIndex(this.spellIndex);
                    World world = this.field_70170_p;
                    Intrinsics.checkExpressionValueIsNotNull(world, "world");
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder3 = deliveryTransitionStateBuilder2.withWorld(world);
                    Vec3d vec3d = result.field_72307_f;
                    Intrinsics.checkExpressionValueIsNotNull(vec3d, "result.hitVec");
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder4 = deliveryTransitionStateBuilder3.withPosition(vec3d).withBlockPosition(hitPos).withDirection(new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y));
                    UUID uUID = this.spellCasterId;
                    if (uUID != null) {
                        UUID uUID2 = uUID;
                        DeliveryTransitionStateBuilder deliveryTransitionStateBuilder5 = deliveryTransitionStateBuilder4;
                        boolean bl = false;
                        boolean bl2 = false;
                        UUID it = uUID2;
                        boolean bl3 = false;
                        World world2 = this.field_70170_p;
                        if (!(world2 instanceof WorldServer)) {
                            world2 = null;
                        }
                        WorldServer worldServer = (WorldServer)world2;
                        Entity entity2 = worldServer != null ? worldServer.func_175733_a(it) : null;
                        deliveryTransitionStateBuilder4 = deliveryTransitionStateBuilder5;
                        entity = entity2;
                    } else {
                        entity = null;
                    }
                    DeliveryTransitionState state = deliveryTransitionStateBuilder4.withCasterEntity(entity).withDeliveryEntity(this).build();
                    currentDeliveryMethod.procEffects(state);
                    currentDeliveryMethod.transitionFrom(state);
                } else if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                    Entity entity;
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = new DeliveryTransitionStateBuilder();
                    Spell spell3 = this.spell;
                    if (spell3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException(NBT_SPELL);
                    }
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder6 = deliveryTransitionStateBuilder.withSpell(spell3).withStageIndex(this.spellIndex);
                    Entity entity3 = result.field_72308_g;
                    Intrinsics.checkExpressionValueIsNotNull(entity3, "result.entityHit");
                    DeliveryTransitionStateBuilder deliveryTransitionStateBuilder7 = deliveryTransitionStateBuilder6.withEntity(entity3);
                    UUID uUID = this.spellCasterId;
                    if (uUID != null) {
                        UUID uUID3 = uUID;
                        DeliveryTransitionStateBuilder deliveryTransitionStateBuilder8 = deliveryTransitionStateBuilder7;
                        boolean bl = false;
                        boolean bl4 = false;
                        UUID it = uUID3;
                        boolean bl5 = false;
                        World world = this.field_70170_p;
                        if (!(world instanceof WorldServer)) {
                            world = null;
                        }
                        WorldServer worldServer = (WorldServer)world;
                        Entity entity4 = worldServer != null ? worldServer.func_175733_a(it) : null;
                        deliveryTransitionStateBuilder7 = deliveryTransitionStateBuilder8;
                        entity = entity4;
                    } else {
                        entity = null;
                    }
                    DeliveryTransitionState state = deliveryTransitionStateBuilder7.withCasterEntity(entity).withDeliveryEntity(this).build();
                    currentDeliveryMethod.procEffects(state);
                    currentDeliveryMethod.transitionFrom(state);
                }
            }
            this.func_70106_y();
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K && !this.animHandler.isAnimationActive("Idle")) {
            AnimationHandler.playAnimation$default(this.animHandler, "Idle", 0.0f, 2, null);
        }
    }

    protected void func_70014_b(@NotNull NBTTagCompound compound) {
        block1: {
            Intrinsics.checkParameterIsNotNull(compound, "compound");
            compound.func_74768_a(NBT_TICKS_IN_AIR, this.ticksInAir);
            compound.func_74782_a(NBT_MOTION_DIRECTION, (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
            Spell spell = this.spell;
            if (spell == null) {
                Intrinsics.throwUninitializedPropertyAccessException(NBT_SPELL);
            }
            compound.func_74782_a(NBT_SPELL, (NBTBase)spell.serializeNBT());
            compound.func_74768_a(NBT_SPELL_INDEX, this.spellIndex);
            compound.func_74780_a(NBT_BLOCK_DISTANCE_REMAINING, this.blockDistanceRemaining);
            UUID uUID = this.spellCasterId;
            if (uUID == null) break block1;
            UUID uUID2 = uUID;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            compound.func_74782_a(NBT_CASTER_ENTITY_ID, (NBTBase)NBTUtil.func_186862_a((UUID)it));
        }
    }

    protected void func_70037_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull(compound, "compound");
        this.ticksInAir = compound.func_74762_e(NBT_TICKS_IN_AIR);
        NBTTagList motionTagList = compound.func_150295_c(NBT_MOTION_DIRECTION, 6);
        this.field_70159_w = motionTagList.func_150309_d(0);
        this.field_70181_x = motionTagList.func_150309_d(1);
        this.field_70179_y = motionTagList.func_150309_d(2);
        NBTTagCompound nBTTagCompound = compound.func_74775_l(NBT_SPELL);
        Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "compound.getCompoundTag(NBT_SPELL)");
        this.spell = new Spell(nBTTagCompound);
        this.spellIndex = compound.func_74762_e(NBT_SPELL_INDEX);
        this.blockDistanceRemaining = compound.func_74769_h(NBT_BLOCK_DISTANCE_REMAINING);
        this.spellCasterId = compound.func_74764_b(NBT_CASTER_ENTITY_ID) ? NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l(NBT_CASTER_ENTITY_ID)) : null;
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 0.4f;
    }

    public boolean func_70097_a(@NotNull DamageSource source, float amount) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        return false;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    protected boolean func_184228_n(@NotNull Entity entityIn) {
        Intrinsics.checkParameterIsNotNull(entityIn, "entityIn");
        return false;
    }

    @Override
    @NotNull
    public AnimationHandler getAnimationHandler() {
        return this.animHandler;
    }

    public EntitySpellProjectile(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        super(world);
        this.animHandler = new AnimationHandler(new ChannelSpellProjectileIdle("Idle", 100.0f, 60, ChannelMode.LOOP));
        this.func_70105_a(0.4f, 0.4f);
    }

    public EntitySpellProjectile(@NotNull World world, @NotNull Spell spell, int spellIndex, @Nullable Entity spellCaster, @NotNull Vec3d position, @NotNull Vec3d velocity, @Nullable Entity shooter) {
        block3: {
            Intrinsics.checkParameterIsNotNull(world, "world");
            Intrinsics.checkParameterIsNotNull(spell, NBT_SPELL);
            Intrinsics.checkParameterIsNotNull(position, "position");
            Intrinsics.checkParameterIsNotNull(velocity, "velocity");
            this(world);
            this.spell = spell;
            this.spellIndex = spellIndex;
            this.shooter = shooter;
            Entity entity = spellCaster;
            this.spellCasterId = entity != null ? entity.getPersistentID() : null;
            SpellStage spellStage = spell.getStage(spellIndex);
            if (spellStage == null) {
                Intrinsics.throwNpe();
            }
            SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = spellStage.getDeliveryInstance();
            if (spellComponentInstance == null) {
                Intrinsics.throwNpe();
            }
            SpellComponentInstance<SpellDeliveryMethod> deliveryInstance = spellComponentInstance;
            SpellDeliveryMethod spellDeliveryMethod = deliveryInstance.getComponent();
            if (spellDeliveryMethod == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.SpellDeliveryMethodProjectile");
            }
            SpellDeliveryMethodProjectile deliveryMethodProjectile = (SpellDeliveryMethodProjectile)spellDeliveryMethod;
            this.blockDistanceRemaining = deliveryMethodProjectile.getRange(deliveryInstance);
            double projectileSpeed = deliveryMethodProjectile.getSpeed(deliveryInstance);
            Vec3d motion = velocity.func_72432_b().func_186678_a(projectileSpeed);
            this.field_70159_w = motion.field_72450_a;
            this.field_70181_x = motion.field_72448_b;
            this.field_70179_y = motion.field_72449_c;
            this.func_70107_b(position.field_72450_a + this.field_70159_w, position.field_72448_b + this.field_70181_x, position.field_72449_c + this.field_70179_y);
            Entity entity2 = this.shooter;
            if (entity2 == null) break block3;
            Entity entity3 = entity2;
            boolean bl = false;
            boolean bl2 = false;
            Entity it = entity3;
            boolean bl3 = false;
            this.func_70101_b(it.field_70177_z, it.field_70125_A);
        }
    }

    public /* synthetic */ EntitySpellProjectile(World world, Spell spell, int n, Entity entity, Vec3d vec3d, Vec3d vec3d2, Entity entity2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            entity2 = null;
        }
        this(world, spell, n, entity, vec3d, vec3d2, entity2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/spell/projectile/EntitySpellProjectile$Companion;", "", "()V", "NBT_BLOCK_DISTANCE_REMAINING", "", "NBT_CASTER_ENTITY_ID", "NBT_MOTION_DIRECTION", "NBT_SPELL", "NBT_SPELL_INDEX", "NBT_TICKS_IN_AIR", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

