/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityProvider;
import com.davidm1a2.afraidofthedark.common.capabilities.player.basics.AOTDPlayerBasicsStorage;
import com.davidm1a2.afraidofthedark.common.capabilities.player.basics.IAOTDPlayerBasics;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.AOTDPlayerNightmareDataStorage;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.AOTDPlayerVoidChestDataStorage;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IAOTDPlayerNightmareData;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IAOTDPlayerVoidChestData;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.AOTDPlayerResearchStorage;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IAOTDPlayerResearch;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.AOTDPlayerSpellManagerStorage;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.IAOTDPlayerSpellManager;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.component.AOTDPlayerSpellCharmDataStorage;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.component.AOTDPlayerSpellFreezeDataStorage;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.component.IAOTDPlayerSpellCharmData;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.component.IAOTDPlayerSpellFreezeData;
import com.davidm1a2.afraidofthedark.common.constants.ModCapabilities;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/CapabilityHandler;", "", "()V", "onAttachCapabilitiesEntity", "", "event", "Lnet/minecraftforge/event/AttachCapabilitiesEvent;", "Lnet/minecraft/entity/Entity;", "onClonePlayer", "Lnet/minecraftforge/event/entity/player/PlayerEvent$Clone;", "onEntityJoinWorld", "Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;", "Companion", "afraidofthedark"})
public final class CapabilityHandler {
    private static boolean wasInitialized;
    public static final Companion Companion;

    @SubscribeEvent
    public final void onAttachCapabilitiesEntity(@NotNull AttachCapabilitiesEvent<Entity> event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("afraidofthedark", "player_basics"), (ICapabilityProvider)new CapabilityProvider<IAOTDPlayerBasics>(ModCapabilities.getPLAYER_BASICS()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_research"), (ICapabilityProvider)new CapabilityProvider<IAOTDPlayerResearch>(ModCapabilities.getPLAYER_RESEARCH()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_void_chest_data"), (ICapabilityProvider)new CapabilityProvider<IAOTDPlayerVoidChestData>(ModCapabilities.getPLAYER_VOID_CHEST_DATA()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_nightmare_data"), (ICapabilityProvider)new CapabilityProvider<IAOTDPlayerNightmareData>(ModCapabilities.getPLAYER_NIGHTMARE_DATA()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_spell_manager"), (ICapabilityProvider)new CapabilityProvider<IAOTDPlayerSpellManager>(ModCapabilities.getPLAYER_SPELL_MANAGER()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_spell_freeze_data"), (ICapabilityProvider)new CapabilityProvider<IAOTDPlayerSpellFreezeData>(ModCapabilities.getPLAYER_SPELL_FREEZE_DATA()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_spell_charm_data"), (ICapabilityProvider)new CapabilityProvider<IAOTDPlayerSpellCharmData>(ModCapabilities.getPLAYER_SPELL_CHARM_DATA()));
        }
    }

    @SubscribeEvent
    public final void onEntityJoinWorld(@NotNull EntityJoinWorldEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (event.getEntity() instanceof EntityPlayer) {
            Entity entity = event.getEntity();
            if (entity == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
            }
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            if (!event.getWorld().field_72995_K) {
                CapabilityExtensionsKt.getBasics(entityPlayer).syncAll(entityPlayer);
                CapabilityExtensionsKt.getResearch(entityPlayer).sync(entityPlayer, false);
                CapabilityExtensionsKt.getSpellManager(entityPlayer).syncAll(entityPlayer);
                CapabilityExtensionsKt.getSpellFreezeData(entityPlayer).sync(entityPlayer);
            }
        }
    }

    @SubscribeEvent
    public final void onClonePlayer(@NotNull PlayerEvent.Clone event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (event.isWasDeath()) {
            EntityPlayer entityPlayer = event.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "event.original");
            IAOTDPlayerBasics originalPlayerBasics = CapabilityExtensionsKt.getBasics(entityPlayer);
            EntityPlayer entityPlayer2 = event.getEntityPlayer();
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer2, "event.entityPlayer");
            IAOTDPlayerBasics newPlayerBasics = CapabilityExtensionsKt.getBasics(entityPlayer2);
            EntityPlayer entityPlayer3 = event.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer3, "event.original");
            IAOTDPlayerResearch originalPlayerResearch = CapabilityExtensionsKt.getResearch(entityPlayer3);
            EntityPlayer entityPlayer4 = event.getEntityPlayer();
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer4, "event.entityPlayer");
            IAOTDPlayerResearch newPlayerResearch = CapabilityExtensionsKt.getResearch(entityPlayer4);
            EntityPlayer entityPlayer5 = event.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer5, "event.original");
            IAOTDPlayerVoidChestData originalPlayerVoidChestData = CapabilityExtensionsKt.getVoidChestData(entityPlayer5);
            EntityPlayer entityPlayer6 = event.getEntityPlayer();
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer6, "event.entityPlayer");
            IAOTDPlayerVoidChestData newPlayerVoidChestData = CapabilityExtensionsKt.getVoidChestData(entityPlayer6);
            EntityPlayer entityPlayer7 = event.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer7, "event.original");
            IAOTDPlayerNightmareData originalPlayerNightmareData = CapabilityExtensionsKt.getNightmareData(entityPlayer7);
            EntityPlayer entityPlayer8 = event.getEntityPlayer();
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer8, "event.entityPlayer");
            IAOTDPlayerNightmareData newPlayerNightmareData = CapabilityExtensionsKt.getNightmareData(entityPlayer8);
            EntityPlayer entityPlayer9 = event.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer9, "event.original");
            IAOTDPlayerSpellManager originalPlayerSpellManager = CapabilityExtensionsKt.getSpellManager(entityPlayer9);
            EntityPlayer entityPlayer10 = event.getEntityPlayer();
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer10, "event.entityPlayer");
            IAOTDPlayerSpellManager newPlayerSpellManager = CapabilityExtensionsKt.getSpellManager(entityPlayer10);
            NBTBase nBTBase = ModCapabilities.getPLAYER_BASICS().getStorage().writeNBT(ModCapabilities.getPLAYER_BASICS(), (Object)originalPlayerBasics, null);
            if (nBTBase == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
            }
            NBTTagCompound originalPlayerBasicsNBT = (NBTTagCompound)nBTBase;
            NBTBase nBTBase2 = ModCapabilities.getPLAYER_RESEARCH().getStorage().writeNBT(ModCapabilities.getPLAYER_RESEARCH(), (Object)originalPlayerResearch, null);
            if (nBTBase2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
            }
            NBTTagCompound originalPlayerResearchNBT = (NBTTagCompound)nBTBase2;
            NBTBase nBTBase3 = ModCapabilities.getPLAYER_VOID_CHEST_DATA().getStorage().writeNBT(ModCapabilities.getPLAYER_VOID_CHEST_DATA(), (Object)originalPlayerVoidChestData, null);
            if (nBTBase3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
            }
            NBTTagCompound originalPlayerVoidChestDataNBT = (NBTTagCompound)nBTBase3;
            NBTBase nBTBase4 = ModCapabilities.getPLAYER_NIGHTMARE_DATA().getStorage().writeNBT(ModCapabilities.getPLAYER_NIGHTMARE_DATA(), (Object)originalPlayerNightmareData, null);
            if (nBTBase4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
            }
            NBTTagCompound originalPlayerNightmareDataNBT = (NBTTagCompound)nBTBase4;
            NBTBase nBTBase5 = ModCapabilities.getPLAYER_SPELL_MANAGER().getStorage().writeNBT(ModCapabilities.getPLAYER_SPELL_MANAGER(), (Object)originalPlayerSpellManager, null);
            if (nBTBase5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
            }
            NBTTagCompound originalPlayerSpellManagerNBT = (NBTTagCompound)nBTBase5;
            ModCapabilities.getPLAYER_BASICS().getStorage().readNBT(ModCapabilities.getPLAYER_BASICS(), (Object)newPlayerBasics, null, (NBTBase)originalPlayerBasicsNBT);
            ModCapabilities.getPLAYER_RESEARCH().getStorage().readNBT(ModCapabilities.getPLAYER_RESEARCH(), (Object)newPlayerResearch, null, (NBTBase)originalPlayerResearchNBT);
            ModCapabilities.getPLAYER_VOID_CHEST_DATA().getStorage().readNBT(ModCapabilities.getPLAYER_VOID_CHEST_DATA(), (Object)newPlayerVoidChestData, null, (NBTBase)originalPlayerVoidChestDataNBT);
            ModCapabilities.getPLAYER_NIGHTMARE_DATA().getStorage().readNBT(ModCapabilities.getPLAYER_NIGHTMARE_DATA(), (Object)newPlayerNightmareData, null, (NBTBase)originalPlayerNightmareDataNBT);
            ModCapabilities.getPLAYER_SPELL_MANAGER().getStorage().readNBT(ModCapabilities.getPLAYER_SPELL_MANAGER(), (Object)newPlayerSpellManager, null, (NBTBase)originalPlayerSpellManagerNBT);
        }
    }

    public CapabilityHandler() {
        if (!wasInitialized) {
            CapabilityManager.INSTANCE.register(IAOTDPlayerBasics.class, (Capability.IStorage)new AOTDPlayerBasicsStorage(), (Callable)1.INSTANCE);
            CapabilityManager.INSTANCE.register(IAOTDPlayerResearch.class, (Capability.IStorage)new AOTDPlayerResearchStorage(), (Callable)2.INSTANCE);
            CapabilityManager.INSTANCE.register(IAOTDPlayerVoidChestData.class, (Capability.IStorage)new AOTDPlayerVoidChestDataStorage(), (Callable)3.INSTANCE);
            CapabilityManager.INSTANCE.register(IAOTDPlayerNightmareData.class, (Capability.IStorage)new AOTDPlayerNightmareDataStorage(), (Callable)4.INSTANCE);
            CapabilityManager.INSTANCE.register(IAOTDPlayerSpellManager.class, (Capability.IStorage)new AOTDPlayerSpellManagerStorage(), (Callable)5.INSTANCE);
            CapabilityManager.INSTANCE.register(IAOTDPlayerSpellFreezeData.class, (Capability.IStorage)new AOTDPlayerSpellFreezeDataStorage(), (Callable)6.INSTANCE);
            CapabilityManager.INSTANCE.register(IAOTDPlayerSpellCharmData.class, (Capability.IStorage)new AOTDPlayerSpellCharmDataStorage(), (Callable)7.INSTANCE);
            wasInitialized = true;
        }
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/CapabilityHandler$Companion;", "", "()V", "wasInitialized", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

