/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 :2\u00020\u0001:\u0001:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00100\u001a\u000201J\f\u00102\u001a\b\u0012\u0004\u0012\u00020403J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0007J\b\u00109\u001a\u000206H\u0002R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u001e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u001e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\tR\u001e\u0010 \u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u001e\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\tR\u001e\u0010$\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0017R\u001e\u0010&\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\rR\u001e\u0010(\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\tR\u001e\u0010*\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0017R\u001e\u0010,\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0017R\u001e\u0010.\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\t\u00a8\u0006;"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/ConfigurationHandler;", "", "configurationFile", "Ljava/io/File;", "(Ljava/io/File;)V", "<set-?>", "", "blocksBetweenIslands", "getBlocksBetweenIslands", "()I", "", "cacheStructures", "getCacheStructures", "()Z", "", "cacheTimeout", "getCacheTimeout", "()J", "configuration", "Lnet/minecraftforge/common/config/Configuration;", "", "cryptMultiplier", "getCryptMultiplier", "()F", "darkForestMultiplier", "getDarkForestMultiplier", "debugMessages", "getDebugMessages", "desertOasisMultiplier", "getDesertOasisMultiplier", "eerieBiomeFrequency", "getEerieBiomeFrequency", "gnomishCityFrequency", "getGnomishCityFrequency", "nightmareDimensionId", "getNightmareDimensionId", "observatoryMultiplier", "getObservatoryMultiplier", "useCalibri", "getUseCalibri", "voidChestDimensionId", "getVoidChestDimensionId", "voidChestMultiplier", "getVoidChestMultiplier", "witchHutMultiplier", "getWitchHutMultiplier", "worldGenPriority", "getWorldGenPriority", "getDisplayTitle", "", "getInGameConfigurableOptions", "", "Lnet/minecraftforge/fml/client/config/IConfigElement;", "onConfigurationChangedEvent", "", "event", "Lnet/minecraftforge/fml/client/event/ConfigChangedEvent$OnConfigChangedEvent;", "refreshConfiguration", "Companion", "afraidofthedark"})
public final class ConfigurationHandler {
    private final Configuration configuration;
    private float cryptMultiplier;
    private float darkForestMultiplier;
    private float gnomishCityFrequency;
    private float voidChestMultiplier;
    private float witchHutMultiplier;
    private float desertOasisMultiplier;
    private float observatoryMultiplier;
    private int eerieBiomeFrequency;
    private boolean debugMessages;
    private int blocksBetweenIslands;
    private int worldGenPriority;
    private boolean cacheStructures;
    private long cacheTimeout;
    private int nightmareDimensionId;
    private int voidChestDimensionId;
    private boolean useCalibri;
    private static final String CATEGORY_DUNGEON_FREQUENCY = "dungeon_frequency";
    private static final String CATEGORY_WORLD_GENERATION = "world_generation";
    private static final String CATEGORY_DIMENSION = "dimension";
    public static final Companion Companion = new Companion(null);

    public final float getCryptMultiplier() {
        return this.cryptMultiplier;
    }

    public final float getDarkForestMultiplier() {
        return this.darkForestMultiplier;
    }

    public final float getGnomishCityFrequency() {
        return this.gnomishCityFrequency;
    }

    public final float getVoidChestMultiplier() {
        return this.voidChestMultiplier;
    }

    public final float getWitchHutMultiplier() {
        return this.witchHutMultiplier;
    }

    public final float getDesertOasisMultiplier() {
        return this.desertOasisMultiplier;
    }

    public final float getObservatoryMultiplier() {
        return this.observatoryMultiplier;
    }

    public final int getEerieBiomeFrequency() {
        return this.eerieBiomeFrequency;
    }

    public final boolean getDebugMessages() {
        return this.debugMessages;
    }

    public final int getBlocksBetweenIslands() {
        return this.blocksBetweenIslands;
    }

    public final int getWorldGenPriority() {
        return this.worldGenPriority;
    }

    public final boolean getCacheStructures() {
        return this.cacheStructures;
    }

    public final long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public final int getNightmareDimensionId() {
        return this.nightmareDimensionId;
    }

    public final int getVoidChestDimensionId() {
        return this.voidChestDimensionId;
    }

    public final boolean getUseCalibri() {
        return this.useCalibri;
    }

    @SubscribeEvent
    public final void onConfigurationChangedEvent(@NotNull ConfigChangedEvent.OnConfigChangedEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (Intrinsics.areEqual(event.getModID(), "afraidofthedark")) {
            this.refreshConfiguration();
        }
    }

    private final void refreshConfiguration() {
        this.configuration.addCustomCategoryComment(CATEGORY_DUNGEON_FREQUENCY, "Here you can set how frequently certain dungeons appear.");
        this.configuration.addCustomCategoryComment(CATEGORY_WORLD_GENERATION, "Here you can set world generation properties.");
        this.configuration.addCustomCategoryComment(CATEGORY_DIMENSION, "Here you can set dimension IDs");
        this.cryptMultiplier = this.configuration.getFloat("Crypt Multiplier", CATEGORY_DUNGEON_FREQUENCY, 1.0f, 0.0f, 100.0f, "Increases the number of Crypts in the world by the multiplier specified.");
        this.darkForestMultiplier = this.configuration.getFloat("Dark Forest Multiplier", CATEGORY_DUNGEON_FREQUENCY, 1.0f, 0.0f, 100.0f, "Increases the number of Dark Forests in the world by the multiplier specified.");
        this.gnomishCityFrequency = this.configuration.getFloat("Gnomish City Multiplier", CATEGORY_DUNGEON_FREQUENCY, 1.0f, 0.0f, 100.0f, "Increases the number of Gnomish Cities in the world by the multiplier specified.");
        this.voidChestMultiplier = this.configuration.getFloat("Void Chest Multiplier", CATEGORY_DUNGEON_FREQUENCY, 1.0f, 0.0f, 100.0f, "Increases the number of Void Chests in the world by the multiplier specified.");
        this.witchHutMultiplier = this.configuration.getFloat("Witch Hut Multiplier", CATEGORY_DUNGEON_FREQUENCY, 1.0f, 0.0f, 100.0f, "Increases the number of Witch Huts in the world by the multiplier specified.");
        this.desertOasisMultiplier = this.configuration.getFloat("Desert Oasis Multiplier", CATEGORY_DUNGEON_FREQUENCY, 1.0f, 0.0f, 100.0f, "Increases the number of Desert Oasis in the world by the multiplier specified.");
        this.observatoryMultiplier = this.configuration.getFloat("Observatory Multiplier", CATEGORY_DUNGEON_FREQUENCY, 1.0f, 0.0f, 100.0f, "Increases the number of Observatories in the world by the multiplier specified.");
        this.eerieBiomeFrequency = this.configuration.getInt("Eerie Biome Frequency", "general", 10, 0, 1000, "Increase this value to increase the number of Eerie Biomes. 10 is the default MC forest value.");
        this.debugMessages = this.configuration.getBoolean("Debug Messages", "general", false, "If you wish to receive all possible kinds of spammy debug messages in the console turn this on. Mostly used for developers only.");
        this.useCalibri = this.configuration.getBoolean("Use Calibri Font", "general", false, "True will force Afraid of the Dark to use the 'Calibri' font. Calibri supports a lot more languages at the cost of longer load times and more memory usage. If you are seeing a lot of question marks in text, turning this on may help.");
        this.blocksBetweenIslands = this.configuration.getInt("Blocks Between Islands", CATEGORY_WORLD_GENERATION, 1000, 100, 100000, "Sets the number of blocks that are between nightmare and void chest islands. All players are technically in the same world, so this ensure they never see each other.");
        this.worldGenPriority = this.configuration.getInt("World Generation Priority", CATEGORY_WORLD_GENERATION, 0, -1000, 1000, "Sets the priority for afraid of the dark world generation. Higher numbers result in world generation running after other mods.");
        this.cacheStructures = this.configuration.getBoolean("Cache Structures", CATEGORY_WORLD_GENERATION, true, "True means structures will be loaded into computer memory when Minecraft is started up. This will accelerate world generation at the cost of RAM usage. False means structures will be loaded when needed, which will require less RAM but can incur lag spikes when finding structures.");
        this.cacheTimeout = this.configuration.getInt("Cache Timeout", CATEGORY_WORLD_GENERATION, 60000, 10000, Integer.MAX_VALUE, "Required if 'Cache Structures' is set to false, otherwise ignored. If a structure isn't needed for 'Cache Timeout' milliseconds it will be forgotten and cleared from RAM.");
        this.nightmareDimensionId = this.configuration.getInt("Nightmare Dimension ID", CATEGORY_DIMENSION, 0, 0, 256, "Sets the dimension ID of the nightmare realm. 0 indicates that the value should be dynamically chosen by forge.");
        this.voidChestDimensionId = this.configuration.getInt("Void Chest Dimension ID", CATEGORY_DIMENSION, 0, 0, 256, "Sets the dimension ID of the void chest realm. 0 indicates that the value should be dynamically chosen by forge.");
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    @NotNull
    public final List<IConfigElement> getInGameConfigurableOptions() {
        List list = new ConfigElement(this.configuration.getCategory("general")).getChildElements();
        Intrinsics.checkExpressionValueIsNotNull(list, "ConfigElement(configurat\u2026Y_GENERAL)).childElements");
        Collection collection = list;
        List list2 = new ConfigElement(this.configuration.getCategory(CATEGORY_DUNGEON_FREQUENCY)).getChildElements();
        Intrinsics.checkExpressionValueIsNotNull(list2, "ConfigElement(configurat\u2026FREQUENCY)).childElements");
        Collection collection2 = CollectionsKt.plus(collection, (Iterable)list2);
        List list3 = new ConfigElement(this.configuration.getCategory(CATEGORY_WORLD_GENERATION)).getChildElements();
        Intrinsics.checkExpressionValueIsNotNull(list3, "ConfigElement(configurat\u2026ENERATION)).childElements");
        Collection collection3 = CollectionsKt.plus(collection2, (Iterable)list3);
        List list4 = new ConfigElement(this.configuration.getCategory(CATEGORY_DIMENSION)).getChildElements();
        Intrinsics.checkExpressionValueIsNotNull(list4, "ConfigElement(configurat\u2026DIMENSION)).childElements");
        return CollectionsKt.plus(collection3, (Iterable)list4);
    }

    @NotNull
    public final String getDisplayTitle() {
        String string = GuiConfig.getAbridgedConfigPath((String)this.configuration.toString());
        Intrinsics.checkExpressionValueIsNotNull(string, "GuiConfig.getAbridgedCon\u2026configuration.toString())");
        return string;
    }

    public ConfigurationHandler(@NotNull File configurationFile) {
        Intrinsics.checkParameterIsNotNull(configurationFile, "configurationFile");
        this.configuration = new Configuration(configurationFile);
        this.cryptMultiplier = 1.0f;
        this.darkForestMultiplier = 1.0f;
        this.gnomishCityFrequency = 1.0f;
        this.voidChestMultiplier = 1.0f;
        this.witchHutMultiplier = 1.0f;
        this.desertOasisMultiplier = 1.0f;
        this.observatoryMultiplier = 1.0f;
        this.eerieBiomeFrequency = 10;
        this.blocksBetweenIslands = 1000;
        this.refreshConfiguration();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/ConfigurationHandler$Companion;", "", "()V", "CATEGORY_DIMENSION", "", "CATEGORY_DUNGEON_FREQUENCY", "CATEGORY_WORLD_GENERATION", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

