/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IAOTDPlayerResearch;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.item.ItemFlaskOfSouls;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/FlaskOfSoulsHandler;", "", "()V", "onItemCraftedEvent", "", "event", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$ItemCraftedEvent;", "onLivingDeathEvent", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "afraidofthedark"})
public final class FlaskOfSoulsHandler {
    @SubscribeEvent
    public final void onItemCraftedEvent(@NotNull PlayerEvent.ItemCraftedEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!event.player.field_70170_p.field_72995_K) {
            ItemStack itemStack = event.crafting;
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "event.crafting");
            if (itemStack.func_77973_b() instanceof ItemFlaskOfSouls) {
                EntityPlayer entityPlayer = event.player;
                Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "event.player");
                IAOTDPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch(entityPlayer);
                if (playerResearch.canResearch(ModResearches.INSTANCE.getPHYLACTERY_OF_SOULS())) {
                    playerResearch.setResearch(ModResearches.INSTANCE.getPHYLACTERY_OF_SOULS(), true);
                    EntityPlayer entityPlayer2 = event.player;
                    Intrinsics.checkExpressionValueIsNotNull(entityPlayer2, "event.player");
                    playerResearch.sync(entityPlayer2, true);
                }
            }
        }
    }

    @SubscribeEvent
    public final void onLivingDeathEvent(@NotNull LivingDeathEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        DamageSource damageSource = event.getSource();
        Intrinsics.checkExpressionValueIsNotNull(damageSource, "event.source");
        if (damageSource.func_76346_g() instanceof EntityPlayer && event.getEntity() instanceof EntityLiving) {
            DamageSource damageSource2 = event.getSource();
            Intrinsics.checkExpressionValueIsNotNull(damageSource2, "event.source");
            Entity entity = damageSource2.func_76346_g();
            if (entity == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
            }
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            if (CapabilityExtensionsKt.getResearch(entityPlayer).isResearched(ModResearches.INSTANCE.getPHYLACTERY_OF_SOULS())) {
                ItemFlaskOfSouls flaskOfSouls;
                ItemStack itemStack;
                int i;
                NonNullList inventory = entityPlayer.field_71071_by.field_70462_a;
                ResourceLocation entityID = EntityList.func_191301_a((Entity)event.getEntity());
                int n = 0;
                NonNullList nonNullList = inventory;
                Intrinsics.checkExpressionValueIsNotNull(nonNullList, "inventory");
                int n2 = ((Collection)nonNullList).size();
                while (n < n2) {
                    Object object = inventory.get(i);
                    Intrinsics.checkExpressionValueIsNotNull(object, "inventory[i]");
                    itemStack = (ItemStack)object;
                    if (itemStack.func_77973_b() instanceof ItemFlaskOfSouls) {
                        Item item = itemStack.func_77973_b();
                        if (item == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.item.ItemFlaskOfSouls");
                        }
                        flaskOfSouls = (ItemFlaskOfSouls)item;
                        if (!flaskOfSouls.isComplete(itemStack) && Intrinsics.areEqual(entityID, flaskOfSouls.getSpawnedEntity(itemStack))) {
                            flaskOfSouls.addKills(itemStack, 1);
                            return;
                        }
                    }
                    ++i;
                }
                n2 = 8;
                for (i = 0; i <= n2; ++i) {
                    Object object = inventory.get(i);
                    Intrinsics.checkExpressionValueIsNotNull(object, "inventory[i]");
                    itemStack = (ItemStack)object;
                    if (!(itemStack.func_77973_b() instanceof ItemFlaskOfSouls)) continue;
                    Item item = itemStack.func_77973_b();
                    if (item == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.item.ItemFlaskOfSouls");
                    }
                    flaskOfSouls = (ItemFlaskOfSouls)item;
                    if (flaskOfSouls.isComplete(itemStack) || flaskOfSouls.getSpawnedEntity(itemStack) != null) continue;
                    flaskOfSouls.setSpawnedEntity(itemStack, EntityList.func_191301_a((Entity)event.getEntity()));
                    flaskOfSouls.addKills(itemStack, 1);
                    return;
                }
            }
        }
    }
}

