/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.client.sound.EerieEcho;
import com.davidm1a2.afraidofthedark.client.sound.NightmareChaseMusic;
import com.davidm1a2.afraidofthedark.client.sound.NightmareMusic;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IAOTDPlayerNightmareData;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IAOTDPlayerResearch;
import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.constants.ModItems;
import com.davidm1a2.afraidofthedark.common.constants.ModPotions;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.dimension.IslandUtility;
import com.davidm1a2.afraidofthedark.common.entity.enaria.EntityGhastlyEnaria;
import com.davidm1a2.afraidofthedark.common.item.ItemJournal;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.Schematic;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.SchematicGenerator;
import com.mojang.authlib.GameProfile;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0014H\u0007J \u0010\u0015\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u001d\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u00a8\u0006#"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/NightmareHandler;", "", "()V", "createNamedJournal", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "onChunkUnloadEvent", "", "event", "Lnet/minecraftforge/event/world/ChunkEvent$Unload;", "onEntityJoinWorldEvent", "Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;", "onPlayerRespawnEvent", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerRespawnEvent;", "onPlayerSleepInBedEvent", "Lnet/minecraftforge/event/entity/player/PlayerSleepInBedEvent;", "onPostEntityTravelToDimension", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerChangedDimensionEvent;", "onPreEntityTravelToDimension", "Lnet/minecraftforge/event/entity/EntityTravelToDimensionEvent;", "processPostTeleport", "Lnet/minecraft/entity/player/EntityPlayerMP;", "dimensionFrom", "", "dimensionTo", "processPreTeleport", "", "resetPlayerStats", "testForEnariasAltar", "nightmareWorld", "Lnet/minecraft/world/WorldServer;", "islandPos", "Lnet/minecraft/util/math/BlockPos;", "Companion", "afraidofthedark"})
public final class NightmareHandler {
    private static final int VALID_SPAWN_SEARCH_DISTANCE = 6;
    public static final Companion Companion = new Companion(null);

    @SubscribeEvent
    public final void onPlayerSleepInBedEvent(@NotNull PlayerSleepInBedEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        EntityPlayer entityPlayer = event.getEntityPlayer();
        if (!entityPlayer.field_70170_p.field_72995_K && entityPlayer.func_70660_b((Potion)ModPotions.INSTANCE.getSLEEPING_POTION()) != null) {
            EntityPlayer entityPlayer2 = entityPlayer;
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer2, "entityPlayer");
            IAOTDPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch(entityPlayer2);
            if (playerResearch.canResearch(ModResearches.INSTANCE.getNIGHTMARE())) {
                playerResearch.setResearch(ModResearches.INSTANCE.getNIGHTMARE(), true);
                playerResearch.sync(entityPlayer, true);
            }
            if (playerResearch.isResearched(ModResearches.INSTANCE.getNIGHTMARE())) {
                entityPlayer.changeDimension(ModDimensions.INSTANCE.getNIGHTMARE().func_186068_a(), (ITeleporter)ModDimensions.INSTANCE.getNOOP_TELEPORTER());
            }
        }
    }

    @SubscribeEvent
    public final void onChunkUnloadEvent(@NotNull ChunkEvent.Unload event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!event.getWorld().field_72995_K) {
            WorldProvider worldProvider = event.getWorld().field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull(worldProvider, "event.world.provider");
            if (worldProvider.getDimension() == ModDimensions.INSTANCE.getNIGHTMARE().func_186068_a()) {
                Chunk chunk = event.getChunk();
                Intrinsics.checkExpressionValueIsNotNull(chunk, "event.chunk");
                for (ClassInheritanceMultiMap entityMap : chunk.func_177429_s()) {
                    for (Entity entity : entityMap) {
                        if (!(entity instanceof EntityGhastlyEnaria) || entity.field_70128_L) continue;
                        entity.func_70106_y();
                        EntityPlayer entityPlayer = event.getWorld().func_72890_a(entity, (double)AfraidOfTheDark.Companion.getINSTANCE().getConfigurationHandler().getBlocksBetweenIslands() / (double)2);
                        if (entityPlayer == null || entityPlayer.field_70128_L) continue;
                        Random random = entityPlayer.func_70681_au();
                        int offsetX = random.nextBoolean() ? random.nextInt(26) - 50 : random.nextInt(26) + 25;
                        int offsetZ = random.nextBoolean() ? random.nextInt(26) - 50 : random.nextInt(26) + 25;
                        BlockPos blockPos = entityPlayer.func_180425_c();
                        Intrinsics.checkExpressionValueIsNotNull(blockPos, "entityPlayer.position");
                        int posX = blockPos.func_177958_n() + offsetX;
                        BlockPos blockPos2 = entityPlayer.func_180425_c();
                        Intrinsics.checkExpressionValueIsNotNull(blockPos2, "entityPlayer.position");
                        int posZ = blockPos2.func_177952_p() + offsetZ;
                        World world = event.getWorld();
                        Intrinsics.checkExpressionValueIsNotNull(world, "event.world");
                        EntityGhastlyEnaria newEnaria = new EntityGhastlyEnaria(world);
                        newEnaria.setBenign(!CapabilityExtensionsKt.getResearch(entityPlayer).isResearched(ModResearches.INSTANCE.getENARIA()));
                        newEnaria.func_70107_b(posX, entityPlayer.field_70163_u, posZ);
                        event.getWorld().func_72838_d((Entity)newEnaria);
                        return;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public final void onPlayerRespawnEvent(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!event.player.field_70170_p.field_72995_K && event.player.field_71093_bK == ModDimensions.INSTANCE.getNIGHTMARE().func_186068_a()) {
            EntityPlayer entityPlayer = event.player;
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "event.player");
            IAOTDPlayerNightmareData nightmareData = CapabilityExtensionsKt.getNightmareData(entityPlayer);
            event.player.changeDimension(nightmareData.getPreTeleportDimensionID(), (ITeleporter)ModDimensions.INSTANCE.getNOOP_TELEPORTER());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public final void onEntityJoinWorldEvent(@NotNull EntityJoinWorldEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (event.getWorld().field_72995_K) {
            Entity entity = event.getEntity();
            WorldProvider worldProvider = event.getWorld().field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull(worldProvider, "event.world.provider");
            if (worldProvider.getDimension() == ModDimensions.INSTANCE.getNIGHTMARE().func_186068_a() && entity instanceof EntityPlayer) {
                WorldProvider worldProvider2 = entity.field_70170_p.field_73011_w;
                Intrinsics.checkExpressionValueIsNotNull(worldProvider2, "entity.world.provider");
                if (worldProvider2.getDimension() == ModDimensions.INSTANCE.getNIGHTMARE().func_186068_a()) {
                    Minecraft minecraft = Minecraft.func_71410_x();
                    Intrinsics.checkExpressionValueIsNotNull(minecraft, "Minecraft.getMinecraft()");
                    SoundHandler soundHandler = minecraft.func_147118_V();
                    soundHandler.func_147681_a((ISound)new EerieEcho(), 60);
                    soundHandler.func_147681_a((ISound)new NightmareMusic(), 140);
                    soundHandler.func_147681_a((ISound)new NightmareChaseMusic(), 140);
                }
            }
        }
    }

    @SubscribeEvent
    public final void onPreEntityTravelToDimension(@NotNull EntityTravelToDimensionEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!event.getEntity().field_70170_p.field_72995_K) {
            int fromDimension = event.getEntity().field_71093_bK;
            int toDimension = event.getDimension();
            if (event.getEntity() instanceof EntityPlayerMP) {
                Entity entity = event.getEntity();
                if (entity == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
                }
                EntityPlayerMP entityPlayer = (EntityPlayerMP)entity;
                if (this.processPreTeleport(entityPlayer, fromDimension, toDimension)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private final boolean processPreTeleport(EntityPlayerMP entityPlayer, int dimensionFrom, int dimensionTo) {
        if (dimensionTo == ModDimensions.INSTANCE.getNIGHTMARE().func_186068_a()) {
            if (dimensionFrom == ModDimensions.INSTANCE.getNIGHTMARE().func_186068_a()) {
                return true;
            }
            IAOTDPlayerNightmareData playerNightmareData = CapabilityExtensionsKt.getNightmareData((EntityPlayer)entityPlayer);
            World world = entityPlayer.field_70170_p;
            Intrinsics.checkExpressionValueIsNotNull(world, "entityPlayer.world");
            BlockPos blockPos = entityPlayer.func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "entityPlayer.position");
            if (IslandUtility.INSTANCE.isValidSpawnLocation(world, blockPos)) {
                playerNightmareData.setPreTeleportPosition(entityPlayer.func_180425_c());
            } else {
                World world2 = entityPlayer.field_70170_p;
                Intrinsics.checkExpressionValueIsNotNull(world2, "entityPlayer.world");
                BlockPos blockPos2 = entityPlayer.func_180425_c();
                Intrinsics.checkExpressionValueIsNotNull(blockPos2, "entityPlayer.position");
                BlockPos preTeleportPosition = IslandUtility.INSTANCE.findValidSpawnLocation(world2, blockPos2, 6);
                if (preTeleportPosition == null) {
                    entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:dimension.nightmare.no_spawn", new Object[0]));
                    return true;
                }
                playerNightmareData.setPreTeleportPosition(preTeleportPosition);
            }
            playerNightmareData.setPreTeleportDimensionID(dimensionFrom);
            NBTTagList inventoryNBT = entityPlayer.field_71071_by.func_70442_a(new NBTTagList());
            playerNightmareData.setPreTeleportPlayerInventory(inventoryNBT);
            entityPlayer.field_71071_by.func_174888_l();
            entityPlayer.field_71069_bz.func_75142_b();
        }
        return false;
    }

    @SubscribeEvent
    public final void onPostEntityTravelToDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!event.player.field_70170_p.field_72995_K) {
            int fromDimension = event.fromDim;
            int toDimension = event.toDim;
            EntityPlayer entityPlayer = event.player;
            if (entityPlayer == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
            }
            EntityPlayerMP entityPlayer2 = (EntityPlayerMP)entityPlayer;
            this.processPostTeleport(entityPlayer2, fromDimension, toDimension);
        }
    }

    private final void processPostTeleport(EntityPlayerMP entityPlayer, int dimensionFrom, int dimensionTo) {
        IAOTDPlayerNightmareData playerNightmareData = CapabilityExtensionsKt.getNightmareData((EntityPlayer)entityPlayer);
        if (dimensionTo == ModDimensions.INSTANCE.getNIGHTMARE().func_186068_a()) {
            WorldServer nightmareWorld;
            MinecraftServer minecraftServer = entityPlayer.func_184102_h();
            if (minecraftServer == null) {
                Intrinsics.throwNpe();
            }
            WorldServer worldServer = nightmareWorld = minecraftServer.func_71218_a(ModDimensions.INSTANCE.getNIGHTMARE().func_186068_a());
            Intrinsics.checkExpressionValueIsNotNull(worldServer, "nightmareWorld");
            int indexToGoTo = IslandUtility.INSTANCE.getOrAssignPlayerPositionalIndex((World)worldServer, playerNightmareData);
            int playerXBase = indexToGoTo * AfraidOfTheDark.Companion.getINSTANCE().getConfigurationHandler().getBlocksBetweenIslands();
            entityPlayer.field_71135_a.func_147364_a((double)playerXBase + 21.5, 74.0, 44.5, 0.0f, 0.0f);
            this.resetPlayerStats((EntityPlayer)entityPlayer);
            entityPlayer.field_71071_by.func_70441_a(this.createNamedJournal((EntityPlayer)entityPlayer));
            entityPlayer.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.INSTANCE.getINSANITYS_HEIGHTS()));
            entityPlayer.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150478_aa, 64));
            this.testForEnariasAltar(entityPlayer, nightmareWorld, new BlockPos(playerXBase, 0, 0));
        }
        if (dimensionFrom == ModDimensions.INSTANCE.getNIGHTMARE().func_186068_a()) {
            BlockPos blockPos = playerNightmareData.getPreTeleportPosition();
            if (blockPos == null) {
                Intrinsics.throwNpe();
            }
            BlockPos preTeleportPosition = blockPos;
            entityPlayer.field_71135_a.func_147364_a((double)preTeleportPosition.func_177958_n() + 0.5, (double)preTeleportPosition.func_177956_o() + 1.5, (double)preTeleportPosition.func_177952_p() + 0.5, 0.0f, 0.0f);
            this.resetPlayerStats((EntityPlayer)entityPlayer);
            int numberNightmareStones = RangesKt.coerceAtMost(entityPlayer.field_71071_by.func_174925_a((Item)ModItems.INSTANCE.getNIGHTMARE_STONE(), -1, -1, null), 64);
            entityPlayer.field_71071_by.func_174888_l();
            InventoryPlayer inventoryPlayer = entityPlayer.field_71071_by;
            NBTTagList nBTTagList = playerNightmareData.getPreTeleportPlayerInventory();
            if (nBTTagList == null) {
                Intrinsics.throwNpe();
            }
            inventoryPlayer.func_70443_b(nBTTagList);
            if (numberNightmareStones > 0) {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.INSTANCE.getNIGHTMARE_STONE(), numberNightmareStones));
            }
            entityPlayer.field_71069_bz.func_75142_b();
        }
    }

    private final void resetPlayerStats(EntityPlayer entityPlayer) {
        entityPlayer.field_70159_w = 0.0;
        entityPlayer.field_70181_x = 0.0;
        entityPlayer.field_70179_y = 0.0;
        entityPlayer.func_70606_j(20.0f);
        FoodStats foodStats = entityPlayer.func_71024_bL();
        Intrinsics.checkExpressionValueIsNotNull(foodStats, "entityPlayer.foodStats");
        foodStats.func_75114_a(20);
        entityPlayer.func_70674_bp();
    }

    private final ItemStack createNamedJournal(EntityPlayer entityPlayer) {
        ItemStack toReturn = new ItemStack((Item)ModItems.INSTANCE.getJOURNAL(), 1, 0);
        ItemJournal itemJournal = ModItems.INSTANCE.getJOURNAL();
        GameProfile gameProfile = entityPlayer.func_146103_bH();
        Intrinsics.checkExpressionValueIsNotNull(gameProfile, "entityPlayer.gameProfile");
        itemJournal.setOwner(toReturn, gameProfile.getName());
        return toReturn;
    }

    private final void testForEnariasAltar(EntityPlayerMP entityPlayer, WorldServer nightmareWorld, BlockPos islandPos) {
        IAOTDPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch((EntityPlayer)entityPlayer);
        if (playerResearch.isResearched(ModResearches.INSTANCE.getENARIA())) {
            IBlockState iBlockState = nightmareWorld.func_180495_p(islandPos.func_177982_a(101, 74, 233));
            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "nightmareWorld.getBlockS\u2026andPos.add(101, 74, 233))");
            if (iBlockState.func_177230_c() != ModBlocks.INSTANCE.getENARIAS_ALTAR()) {
                Schematic schematic = ModSchematics.INSTANCE.getENARIAS_ALTAR();
                World world = (World)nightmareWorld;
                BlockPos blockPos = islandPos.func_177982_a(67, 40, 179);
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "islandPos.add(67, 40, 179)");
                SchematicGenerator.generateSchematic$default(SchematicGenerator.INSTANCE, schematic, world, blockPos, null, null, 24, null);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/NightmareHandler$Companion;", "", "()V", "VALID_SPAWN_SEARCH_DISTANCE", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

