/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IAOTDPlayerVoidChestData;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.dimension.IslandUtility;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/VoidChestHandler;", "", "()V", "onPlayerRespawnEvent", "", "event", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerRespawnEvent;", "onPostEntityTravelToDimension", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerChangedDimensionEvent;", "onPreEntityTravelToDimension", "Lnet/minecraftforge/event/entity/EntityTravelToDimensionEvent;", "processPostTeleport", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayerMP;", "dimensionFrom", "", "dimensionTo", "processPreTeleport", "", "Companion", "afraidofthedark"})
public final class VoidChestHandler {
    private static final int VALID_SPAWN_SEARCH_DISTANCE = 6;
    public static final Companion Companion = new Companion(null);

    @SubscribeEvent
    public final void onPlayerRespawnEvent(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!event.player.field_70170_p.field_72995_K && event.player.field_71093_bK == ModDimensions.INSTANCE.getVOID_CHEST().func_186068_a()) {
            int n;
            EntityPlayer entityPlayer = event.player;
            Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "event.player");
            IAOTDPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData(entityPlayer);
            if (playerVoidChestData.getFriendsIndex() == -1) {
                EntityPlayer entityPlayer2 = event.player;
                Intrinsics.checkExpressionValueIsNotNull(entityPlayer2, "event.player");
                MinecraftServer minecraftServer = entityPlayer2.func_184102_h();
                if (minecraftServer == null) {
                    Intrinsics.throwNpe();
                }
                WorldServer worldServer = minecraftServer.func_71218_a(ModDimensions.INSTANCE.getVOID_CHEST().func_186068_a());
                Intrinsics.checkExpressionValueIsNotNull(worldServer, "event.player.server!!.ge\u2026Dimensions.VOID_CHEST.id)");
                n = IslandUtility.INSTANCE.getOrAssignPlayerPositionalIndex((World)worldServer, playerVoidChestData);
            } else {
                n = playerVoidChestData.getFriendsIndex();
            }
            int indexToGoTo = n;
            int playerXBase = indexToGoTo * AfraidOfTheDark.Companion.getINSTANCE().getConfigurationHandler().getBlocksBetweenIslands();
            EntityPlayer entityPlayer3 = event.player;
            if (entityPlayer3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
            }
            ((EntityPlayerMP)entityPlayer3).field_71135_a.func_147364_a((double)playerXBase + 24.5, 104.0, 3.0, 0.0f, 0.0f);
        }
    }

    @SubscribeEvent
    public final void onPreEntityTravelToDimension(@NotNull EntityTravelToDimensionEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!event.getEntity().field_70170_p.field_72995_K) {
            int fromDimension = event.getEntity().field_71093_bK;
            int toDimension = event.getDimension();
            if (event.getEntity() instanceof EntityPlayerMP) {
                Entity entity = event.getEntity();
                if (entity == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
                }
                EntityPlayerMP entityPlayer = (EntityPlayerMP)entity;
                if (this.processPreTeleport(entityPlayer, fromDimension, toDimension)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private final boolean processPreTeleport(EntityPlayerMP entityPlayer, int dimensionFrom, int dimensionTo) {
        if (dimensionTo == ModDimensions.INSTANCE.getVOID_CHEST().func_186068_a()) {
            if (dimensionFrom == ModDimensions.INSTANCE.getVOID_CHEST().func_186068_a()) {
                return true;
            }
            IAOTDPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData((EntityPlayer)entityPlayer);
            World world = entityPlayer.field_70170_p;
            Intrinsics.checkExpressionValueIsNotNull(world, "entityPlayer.world");
            BlockPos blockPos = entityPlayer.func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "entityPlayer.position");
            if (IslandUtility.INSTANCE.isValidSpawnLocation(world, blockPos)) {
                playerVoidChestData.setPreTeleportPosition(entityPlayer.func_180425_c());
            } else {
                World world2 = entityPlayer.field_70170_p;
                Intrinsics.checkExpressionValueIsNotNull(world2, "entityPlayer.world");
                BlockPos blockPos2 = entityPlayer.func_180425_c();
                Intrinsics.checkExpressionValueIsNotNull(blockPos2, "entityPlayer.position");
                BlockPos preTeleportPosition = IslandUtility.INSTANCE.findValidSpawnLocation(world2, blockPos2, 6);
                if (preTeleportPosition == null) {
                    entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:dimension.void_chest.no_spawn", new Object[0]));
                    return true;
                }
                playerVoidChestData.setPreTeleportPosition(preTeleportPosition);
            }
            playerVoidChestData.setPreTeleportDimensionID(dimensionFrom);
        }
        return false;
    }

    @SubscribeEvent
    public final void onPostEntityTravelToDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!event.player.field_70170_p.field_72995_K) {
            int fromDimension = event.fromDim;
            int toDimension = event.toDim;
            EntityPlayer entityPlayer = event.player;
            if (entityPlayer == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
            }
            EntityPlayerMP entityPlayer2 = (EntityPlayerMP)entityPlayer;
            this.processPostTeleport(entityPlayer2, fromDimension, toDimension);
        }
    }

    private final void processPostTeleport(EntityPlayerMP entityPlayer, int dimensionFrom, int dimensionTo) {
        if (dimensionTo == ModDimensions.INSTANCE.getVOID_CHEST().func_186068_a()) {
            int n;
            IAOTDPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData((EntityPlayer)entityPlayer);
            if (playerVoidChestData.getFriendsIndex() == -1) {
                MinecraftServer minecraftServer = entityPlayer.func_184102_h();
                if (minecraftServer == null) {
                    Intrinsics.throwNpe();
                }
                WorldServer worldServer = minecraftServer.func_71218_a(ModDimensions.INSTANCE.getVOID_CHEST().func_186068_a());
                Intrinsics.checkExpressionValueIsNotNull(worldServer, "entityPlayer.server!!.ge\u2026Dimensions.VOID_CHEST.id)");
                n = IslandUtility.INSTANCE.getOrAssignPlayerPositionalIndex((World)worldServer, playerVoidChestData);
            } else {
                n = playerVoidChestData.getFriendsIndex();
            }
            int indexToGoTo = n;
            int playerXBase = indexToGoTo * AfraidOfTheDark.Companion.getINSTANCE().getConfigurationHandler().getBlocksBetweenIslands();
            entityPlayer.field_71135_a.func_147364_a((double)playerXBase + 24.5, 104.0, 3.0, 0.0f, 0.0f);
        }
        if (dimensionFrom == ModDimensions.INSTANCE.getVOID_CHEST().func_186068_a()) {
            BlockPos preTeleportPosition = CapabilityExtensionsKt.getVoidChestData((EntityPlayer)entityPlayer).getPreTeleportPosition();
            NetHandlerPlayServer netHandlerPlayServer = entityPlayer.field_71135_a;
            BlockPos blockPos = preTeleportPosition;
            if (blockPos == null) {
                Intrinsics.throwNpe();
            }
            netHandlerPlayServer.func_147364_a((double)blockPos.func_177958_n() + 0.5, (double)preTeleportPosition.func_177956_o() + 1.5, (double)preTeleportPosition.func_177952_p() + 0.5, 0.0f, 0.0f);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/VoidChestHandler$Companion;", "", "()V", "VALID_SPAWN_SEARCH_DISTANCE", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

