/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModEntities;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItemWithPerItemCooldown;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0006J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\u0017J8\u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u001dH\u0002\u00a8\u0006("}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemFlaskOfSouls;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItemWithPerItemCooldown;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "addKills", "itemStack", "kills", "", "getCooldownInMilliseconds", "getDurabilityForDisplay", "", "getKills", "getSpawnedEntity", "Lnet/minecraft/util/ResourceLocation;", "isComplete", "", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "setSpawnedEntity", "entity", "spawnEntity", "x", "y", "z", "entityPlayer", "Companion", "afraidofthedark"})
public final class ItemFlaskOfSouls
extends AOTDItemWithPerItemCooldown {
    private static final String NBT_FLASK_TYPE = "flask_type";
    private static final String NBT_FLASK_KILLS = "flask_kills";
    private static final String NBT_FLASK_COMPLETE = "flask_complete";
    private static final int DEFAULT_KILLS_REQUIRED = 32;
    private static final Map<ResourceLocation, Integer> ENTITY_TO_KILLS_REQUIRED;
    private static final int DEFAULT_COOLDOWN = 60000;
    private static final Map<Integer, Integer> KILL_COUNT_TO_COOLDOWN;
    public static final Companion Companion;

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (CapabilityExtensionsKt.getResearch(player).isResearched(ModResearches.INSTANCE.getPHYLACTERY_OF_SOULS())) {
                BlockPos hitPos;
                RayTraceResult rayTraceResult = this.func_77621_a(world, player, true);
                if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175660_a(player, hitPos = rayTraceResult.func_178782_a()) && player.func_175151_a(hitPos, rayTraceResult.field_178784_b, itemStack)) {
                    IBlockState iBlockState = world.func_180495_p(hitPos);
                    Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(hitPos)");
                    if (iBlockState.func_177230_c() instanceof BlockLiquid) {
                        BlockPos blockPos = hitPos;
                        Intrinsics.checkExpressionValueIsNotNull(blockPos, "hitPos");
                        double d = (double)blockPos.func_177958_n() + 0.5;
                        double d2 = (double)hitPos.func_177956_o() + 0.5;
                        double d3 = (double)hitPos.func_177952_p() + 0.5;
                        ItemStack itemStack2 = itemStack;
                        Intrinsics.checkExpressionValueIsNotNull(itemStack2, "itemStack");
                        this.spawnEntity(world, d, d2, d3, itemStack2, player);
                    } else {
                        BlockPos spawnPos;
                        BlockPos blockPos = spawnPos = hitPos.func_177972_a(rayTraceResult.field_178784_b);
                        Intrinsics.checkExpressionValueIsNotNull(blockPos, "spawnPos");
                        double d = (double)blockPos.func_177958_n() + 0.5;
                        double d4 = (double)spawnPos.func_177956_o() + 0.5;
                        double d5 = (double)spawnPos.func_177952_p() + 0.5;
                        ItemStack itemStack3 = itemStack;
                        Intrinsics.checkExpressionValueIsNotNull(itemStack3, "itemStack");
                        this.spawnEntity(world, d, d4, d5, itemStack3, player);
                    }
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:dont_understand", new Object[0]));
            }
        }
        ActionResult actionResult = ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
        Intrinsics.checkExpressionValueIsNotNull(actionResult, "ActionResult.newResult(E\u2026esult.SUCCESS, itemStack)");
        return actionResult;
    }

    private final void spawnEntity(World world, double x, double y, double z, ItemStack itemStack, EntityPlayer entityPlayer) {
        if (!world.field_72995_K) {
            if (this.isComplete(itemStack)) {
                if (!this.isOnCooldown(itemStack)) {
                    ResourceLocation entityToSpawnID = this.getSpawnedEntity(itemStack);
                    if (entityToSpawnID != null) {
                        Entity entity = EntityList.func_188429_b((ResourceLocation)entityToSpawnID, (World)world);
                        if (entity != null) {
                            entity.func_70012_b(x, y, z, (float)Random.Default.nextDouble(0.0, 360.0), 0.0f);
                            world.func_72838_d(entity);
                            this.setOnCooldown(itemStack, entityPlayer);
                        } else {
                            AfraidOfTheDark.Companion.getINSTANCE().getLogger().error("Unknown entity: " + entityToSpawnID);
                        }
                    }
                } else {
                    entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:flask_of_souls.on_cooldown", new Object[]{this.cooldownRemainingInSeconds(itemStack)}));
                }
            } else {
                entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:flask_of_souls.incomplete", new Object[0]));
            }
        }
    }

    @Override
    public double getDurabilityForDisplay(@NotNull ItemStack stack) {
        double d;
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        if (!this.isComplete(stack)) {
            if (this.getSpawnedEntity(stack) == null) {
                d = 1.0;
            } else {
                Integer n = ENTITY_TO_KILLS_REQUIRED.get(this.getSpawnedEntity(stack));
                d = 1.0 - (double)this.getKills(stack) / (double)(n != null ? n : 32);
            }
        } else {
            d = super.getDurabilityForDisplay(stack);
        }
        return d;
    }

    @Override
    public int getCooldownInMilliseconds(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Integer n = ENTITY_TO_KILLS_REQUIRED.get(this.getSpawnedEntity(itemStack));
        int killsRequired = n != null ? n : 32;
        Integer n2 = KILL_COUNT_TO_COOLDOWN.get(killsRequired);
        return n2 != null ? n2 : 60000;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(tooltip, "tooltip");
        Intrinsics.checkParameterIsNotNull(flag, "flag");
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && CapabilityExtensionsKt.getResearch((EntityPlayer)player).isResearched(ModResearches.INSTANCE.getPHYLACTERY_OF_SOULS())) {
            if (this.getSpawnedEntity(stack) == null) {
                String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:flask_of_souls.empty.line1", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026OULS_TOOLTIP_EMPTY_LINE1)");
                tooltip.add(string);
                String string2 = I18n.func_135052_a((String)"tooltip.afraidofthedark:flask_of_souls.empty.line2", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull(string2, "I18n.format(Localization\u2026OULS_TOOLTIP_EMPTY_LINE2)");
                tooltip.add(string2);
                String string3 = I18n.func_135052_a((String)"tooltip.afraidofthedark:flask_of_souls.empty.line3", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull(string3, "I18n.format(Localization\u2026OULS_TOOLTIP_EMPTY_LINE3)");
                tooltip.add(string3);
            } else if (this.isComplete(stack)) {
                String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:flask_of_souls.complete.line1", (Object[])new Object[]{EntityList.func_191302_a((ResourceLocation)this.getSpawnedEntity(stack))});
                Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026getSpawnedEntity(stack)))");
                tooltip.add(string);
                String string4 = I18n.func_135052_a((String)"tooltip.afraidofthedark:flask_of_souls.complete.line2", (Object[])new Object[]{this.getCooldownInMilliseconds(stack) / 1000 + 1});
                Intrinsics.checkExpressionValueIsNotNull(string4, "I18n.format(Localization\u2026econds(stack) / 1000 + 1)");
                tooltip.add(string4);
            } else {
                String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:flask_of_souls.incomplete.line1", (Object[])new Object[]{EntityList.func_191302_a((ResourceLocation)this.getSpawnedEntity(stack))});
                Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026getSpawnedEntity(stack)))");
                tooltip.add(string);
                Object[] objectArray = new Object[2];
                objectArray[0] = this.getKills(stack);
                Integer n = ENTITY_TO_KILLS_REQUIRED.get(this.getSpawnedEntity(stack));
                if (n == null) {
                    n = 32;
                }
                objectArray[1] = n;
                String string5 = I18n.func_135052_a((String)"tooltip.afraidofthedark:flask_of_souls.incomplete.line2", (Object[])objectArray);
                Intrinsics.checkExpressionValueIsNotNull(string5, "I18n.format(\n           \u2026                        )");
                tooltip.add(string5);
            }
        } else {
            String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:dont_know_how_to_use", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026TIP_DONT_KNOW_HOW_TO_USE)");
            tooltip.add(string);
        }
    }

    public final boolean isComplete(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Boolean bl = NBTHelper.INSTANCE.getBoolean(itemStack, NBT_FLASK_COMPLETE);
        return bl != null ? bl : false;
    }

    public final void addKills(@NotNull ItemStack itemStack, int kills) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        int currentKills = this.getKills(itemStack);
        ResourceLocation spawnedEntity = this.getSpawnedEntity(itemStack);
        if (spawnedEntity != null) {
            Integer n = ENTITY_TO_KILLS_REQUIRED.get(spawnedEntity);
            int killsRequired = n != null ? n : 32;
            currentKills = RangesKt.coerceIn(currentKills + kills, 0, killsRequired);
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_FLASK_KILLS, currentKills);
            if (currentKills == killsRequired) {
                NBTHelper.INSTANCE.setBoolean(itemStack, NBT_FLASK_COMPLETE, true);
            }
        }
    }

    private final int getKills(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_FLASK_KILLS)) {
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_FLASK_KILLS, 0);
        }
        Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_FLASK_KILLS);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        return n;
    }

    public final void setSpawnedEntity(@NotNull ItemStack itemStack, @Nullable ResourceLocation entity) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        if (entity != null) {
            String string = entity.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "entity.toString()");
            NBTHelper.INSTANCE.setString(itemStack, NBT_FLASK_TYPE, string);
        } else {
            NBTHelper.INSTANCE.removeTag(itemStack, NBT_FLASK_TYPE);
        }
    }

    @Nullable
    public final ResourceLocation getSpawnedEntity(@NotNull ItemStack itemStack) {
        ResourceLocation resourceLocation;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        if (NBTHelper.INSTANCE.hasTag(itemStack, NBT_FLASK_TYPE)) {
            String string = NBTHelper.INSTANCE.getString(itemStack, NBT_FLASK_TYPE);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            resourceLocation = new ResourceLocation(string);
        } else {
            resourceLocation = null;
        }
        return resourceLocation;
    }

    public ItemFlaskOfSouls() {
        super("flask_of_souls", false, 2, null);
        this.func_185043_a(new ResourceLocation("afraidofthedark", "complete"), new IItemPropertyGetter(){

            public final float func_185085_a(ItemStack stack, @Nullable World $noName_1, @Nullable EntityLivingBase $noName_2) {
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull(itemStack, "stack");
                return this.isComplete(itemStack) ? 1.0f : 0.0f;
            }
        });
    }

    static {
        Companion = new Companion(null);
        ENTITY_TO_KILLS_REQUIRED = MapsKt.mapOf(TuplesKt.to(new ResourceLocation("villager"), 8), TuplesKt.to(new ResourceLocation("ghast"), 8), TuplesKt.to(new ResourceLocation("villager_golem"), 8), TuplesKt.to(ModEntities.INSTANCE.getWEREWOLF().getRegistryName(), 8), TuplesKt.to(new ResourceLocation("enderman"), 16), TuplesKt.to(new ResourceLocation("zombie_pigman"), 16), TuplesKt.to(new ResourceLocation("blaze"), 16), TuplesKt.to(new ResourceLocation("magma_cube"), 16), TuplesKt.to(new ResourceLocation("slime"), 16), TuplesKt.to(new ResourceLocation("witch"), 16), TuplesKt.to(new ResourceLocation("horse"), 16), TuplesKt.to(new ResourceLocation("wolf"), 16));
        KILL_COUNT_TO_COOLDOWN = MapsKt.mapOf(TuplesKt.to(8, 20000), TuplesKt.to(16, 10000), TuplesKt.to(32, 5000));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemFlaskOfSouls$Companion;", "", "()V", "DEFAULT_COOLDOWN", "", "DEFAULT_KILLS_REQUIRED", "ENTITY_TO_KILLS_REQUIRED", "", "Lnet/minecraft/util/ResourceLocation;", "KILL_COUNT_TO_COOLDOWN", "NBT_FLASK_COMPLETE", "", "NBT_FLASK_KILLS", "NBT_FLASK_TYPE", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

