/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModDamageSources;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.constants.ModToolMaterials;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItemChargeableSword;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemStarMetalKhopesh;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItemChargeableSword;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "decrementSpinTicks", "itemStack", "onLeftClickEntity", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "entity", "Lnet/minecraft/entity/Entity;", "onUpdate", "itemSlot", "", "isSelected", "performChargeAttack", "entityPlayer", "resetSpin", "shouldSpin", "Companion", "afraidofthedark"})
public final class ItemStarMetalKhopesh
extends AOTDItemChargeableSword {
    private static final int HIT_RANGE = 5;
    private static final String NBT_SPIN_TICKS_LEFT = "spin_ticks_left";
    private static final int TICKS_TO_SPIN = 8;
    private static final float DEGREES_PER_TICK = 45.0f;
    public static final Companion Companion = new Companion(null);

    public boolean onLeftClickEntity(@NotNull ItemStack stack, @NotNull EntityPlayer player, @NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        if (!CapabilityExtensionsKt.getResearch(player).isResearched(ModResearches.INSTANCE.getSTAR_METAL())) {
            return true;
        }
        entity.func_70097_a(ModDamageSources.INSTANCE.getSilverDamage((Entity)player), this.func_150931_i());
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(tooltip, "tooltip");
        Intrinsics.checkParameterIsNotNull(flag, "flag");
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && CapabilityExtensionsKt.getResearch((EntityPlayer)player).isResearched(ModResearches.INSTANCE.getSTAR_METAL())) {
            String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:magic_items_never_break", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026P_MAGIC_ITEM_NEVER_BREAK)");
            tooltip.add(string);
            String string2 = I18n.func_135052_a((String)"tooltip.afraidofthedark:star_metal_khopesh.effect1", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string2, "I18n.format(Localization\u2026_KHOPESH_TOOLTIP_EFFECT1)");
            tooltip.add(string2);
            String string3 = I18n.func_135052_a((String)"tooltip.afraidofthedark:star_metal_khopesh.effect2", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string3, "I18n.format(Localization\u2026_KHOPESH_TOOLTIP_EFFECT2)");
            tooltip.add(string3);
        } else {
            String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:dont_know_how_to_use", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026TIP_DONT_KNOW_HOW_TO_USE)");
            tooltip.add(string);
        }
    }

    @Override
    public boolean performChargeAttack(@NotNull ItemStack itemStack, @NotNull World world, @NotNull EntityPlayer entityPlayer) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(entityPlayer, "entityPlayer");
        List nearbyEntities = world.func_72839_b((Entity)entityPlayer, entityPlayer.func_174813_aQ().func_186662_g((double)5));
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof EntityPlayer) && !(entity instanceof EntityLiving)) continue;
            BlockPos blockPos = entityPlayer.func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "entityPlayer.position");
            double d = blockPos.func_177958_n();
            BlockPos blockPos2 = entity.func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull(blockPos2, "entity.position");
            double motionX = d - (double)blockPos2.func_177958_n();
            BlockPos blockPos3 = entityPlayer.func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull(blockPos3, "entityPlayer.position");
            double d2 = blockPos3.func_177952_p();
            BlockPos blockPos4 = entity.func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull(blockPos4, "entity.position");
            double motionZ = d2 - (double)blockPos4.func_177952_p();
            double d3 = motionX * motionX + motionZ * motionZ;
            boolean bl = false;
            double hypotenuse = Math.sqrt(d3);
            double knockbackStrength = (double)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)itemStack) + (double)2;
            int sharpnessDamage = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)itemStack);
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)entityPlayer), this.func_150931_i() + 4.0f + (float)sharpnessDamage * 1.5f);
            entity.func_70024_g(-motionX * knockbackStrength * 0.6 / hypotenuse, 0.1, -motionZ * knockbackStrength * 0.6 / hypotenuse);
        }
        this.resetSpin(itemStack);
        return true;
    }

    public void func_77663_a(@NotNull ItemStack stack, @NotNull World world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        if (this.shouldSpin(stack)) {
            this.decrementSpinTicks(stack);
            entity.field_70177_z += 45.0f;
        }
    }

    private final void resetSpin(ItemStack itemStack) {
        NBTHelper.INSTANCE.setInteger(itemStack, NBT_SPIN_TICKS_LEFT, 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldSpin(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_SPIN_TICKS_LEFT)) return false;
        Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_SPIN_TICKS_LEFT);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        if (n <= 0) return false;
        return true;
    }

    private final void decrementSpinTicks(ItemStack itemStack) {
        if (NBTHelper.INSTANCE.hasTag(itemStack, NBT_SPIN_TICKS_LEFT)) {
            Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_SPIN_TICKS_LEFT);
            if (n == null) {
                Intrinsics.throwNpe();
            }
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_SPIN_TICKS_LEFT, n - 1);
        }
    }

    public ItemStarMetalKhopesh() {
        super("star_metal_khopesh", ModToolMaterials.INSTANCE.getSTAR_METAL(), false, 4, null);
        this.setPercentChargePerAttack(35.0);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemStarMetalKhopesh$Companion;", "", "()V", "DEGREES_PER_TICK", "", "HIT_RANGE", "", "NBT_SPIN_TICKS_LEFT", "", "TICKS_TO_SPIN", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

