/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.IAOTDPlayerSpellManager;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemWand;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "getSpellId", "Ljava/util/UUID;", "itemStack", "hasSpellId", "", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "setSpellId", "spellId", "setSpellToFirstAvailable", "entityPlayer", "Companion", "afraidofthedark"})
public final class ItemWand
extends AOTDItem {
    private static final String NBT_SPELL_ID = "spell_id";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        ItemStack heldItem = player.func_184586_b(hand);
        IAOTDPlayerSpellManager spellManager = CapabilityExtensionsKt.getSpellManager(player);
        if (player.func_70093_af()) {
            ItemStack itemStack = heldItem;
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "heldItem");
            if (!this.hasSpellId(itemStack)) {
                this.setSpellToFirstAvailable(player, heldItem);
            } else {
                Spell currentSpell;
                UUID spellId;
                UUID uUID = spellId = this.getSpellId(heldItem);
                if (uUID == null) {
                    Intrinsics.throwNpe();
                }
                if ((currentSpell = spellManager.getSpellById(uUID)) == null) {
                    this.setSpellToFirstAvailable(player, heldItem);
                } else {
                    int currentSpellIndex;
                    List<Spell> spells;
                    block17: {
                        int n;
                        List<Spell> $this$indexOfFirst$iv = spells = spellManager.getSpells();
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        Iterator<Spell> iterator2 = $this$indexOfFirst$iv.iterator();
                        while (iterator2.hasNext()) {
                            Spell item$iv;
                            Spell it = item$iv = iterator2.next();
                            boolean bl = false;
                            if (Intrinsics.areEqual(it.getId(), spellId)) {
                                n = index$iv;
                                break block17;
                            }
                            ++index$iv;
                        }
                        n = currentSpellIndex = -1;
                    }
                    if (currentSpellIndex + 1 < spells.size()) {
                        Spell next = spells.get(currentSpellIndex + 1);
                        this.setSpellId(heldItem, next.getId());
                        if (!world.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:wand.spell_set", new Object[]{next.getName()}));
                        }
                    } else {
                        this.setSpellToFirstAvailable(player, heldItem);
                    }
                }
            }
        } else if (!world.field_72995_K) {
            ItemStack itemStack = heldItem;
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "heldItem");
            UUID spellId = this.getSpellId(itemStack);
            if (spellId != null) {
                Spell toCast = spellManager.getSpellById(spellId);
                if (toCast != null) {
                    Spell.attemptToCast$default(toCast, (Entity)player, null, 2, null);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:wand.invalid_spell", new Object[0]));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:wand.no_bound_spell", new Object[0]));
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
    }

    private final void setSpellToFirstAvailable(EntityPlayer entityPlayer, ItemStack itemStack) {
        IAOTDPlayerSpellManager spellManager = CapabilityExtensionsKt.getSpellManager(entityPlayer);
        Collection collection = spellManager.getSpells();
        boolean bl = false;
        if (!collection.isEmpty()) {
            Spell first = spellManager.getSpells().get(0);
            if (!entityPlayer.field_70170_p.field_72995_K) {
                entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:wand.spell_set", new Object[]{first.getName()}));
            }
            this.setSpellId(itemStack, first.getId());
        } else if (!entityPlayer.field_70170_p.field_72995_K) {
            entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:wand.no_spells", new Object[0]));
        }
    }

    private final boolean hasSpellId(ItemStack itemStack) {
        return NBTHelper.INSTANCE.hasTag(itemStack, NBT_SPELL_ID);
    }

    private final void setSpellId(ItemStack itemStack, UUID spellId) {
        NBTTagCompound nBTTagCompound = NBTUtil.func_186862_a((UUID)spellId);
        Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "NBTUtil.createUUIDTag(spellId)");
        NBTHelper.INSTANCE.setCompound(itemStack, NBT_SPELL_ID, nBTTagCompound);
    }

    private final UUID getSpellId(ItemStack itemStack) {
        UUID uUID;
        NBTTagCompound uuidNBT;
        NBTTagCompound nBTTagCompound = uuidNBT = NBTHelper.INSTANCE.getCompound(itemStack, NBT_SPELL_ID);
        if (nBTTagCompound != null) {
            NBTTagCompound nBTTagCompound2 = nBTTagCompound;
            boolean bl = false;
            boolean bl2 = false;
            NBTTagCompound it = nBTTagCompound2;
            boolean bl3 = false;
            uUID = NBTUtil.func_186860_b((NBTTagCompound)it);
        } else {
            uUID = null;
        }
        return uUID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(tooltip, "tooltip");
        Intrinsics.checkParameterIsNotNull(flag, "flag");
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && CapabilityExtensionsKt.getResearch((EntityPlayer)player).isResearched(ModResearches.INSTANCE.getENARIAS_SECRET())) {
            if (this.hasSpellId(stack)) {
                Spell spell;
                IAOTDPlayerSpellManager iAOTDPlayerSpellManager = CapabilityExtensionsKt.getSpellManager((EntityPlayer)player);
                UUID uUID = this.getSpellId(stack);
                if (uUID == null) {
                    Intrinsics.throwNpe();
                }
                if ((spell = iAOTDPlayerSpellManager.getSpellById(uUID)) != null) {
                    String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:wand.spell_name", (Object[])new Object[]{spell.getName()});
                    Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026P_SPELL_NAME, spell.name)");
                    tooltip.add(string);
                    String string2 = I18n.func_135052_a((String)"tooltip.afraidofthedark:wand.spell_cost", (Object[])new Object[]{spell.getCost()});
                    Intrinsics.checkExpressionValueIsNotNull(string2, "I18n.format(Localization\u2026LL_COST, spell.getCost())");
                    tooltip.add(string2);
                } else {
                    String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:wand.spell_invalid", (Object[])new Object[0]);
                    Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026ND_TOOLTIP_SPELL_INVALID)");
                    tooltip.add(string);
                }
            } else {
                String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:wand.no_spell", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026D_TOOLTIP_SPELL_NO_SPELL)");
                tooltip.add(string);
                String string3 = I18n.func_135052_a((String)"tooltip.afraidofthedark:wand.set_spell", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull(string3, "I18n.format(Localization\u2026_TOOLTIP_SPELL_SET_SPELL)");
                tooltip.add(string3);
            }
        } else {
            String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:dont_know_how_to_use", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026TIP_DONT_KNOW_HOW_TO_USE)");
            tooltip.add(string);
        }
    }

    public ItemWand() {
        super("wand", false, 2, null);
        this.func_77625_d(1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemWand$Companion;", "", "()V", "NBT_SPELL_ID", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

