/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item.core;

import com.davidm1a2.afraidofthedark.common.item.core.AOTDItemSword;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 *2\u00020\u0001:\u0001*B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\u000e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020#H&J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0012H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006+"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItemChargeableSword;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItemSword;", "baseName", "", "toolMaterial", "Lnet/minecraft/item/Item$ToolMaterial;", "displayInCreative", "", "(Ljava/lang/String;Lnet/minecraft/item/Item$ToolMaterial;Z)V", "percentChargePerAttack", "", "getPercentChargePerAttack", "()D", "setPercentChargePerAttack", "(D)V", "addCharge", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "charge", "ensureChargeInit", "getCharge", "getDurabilityForDisplay", "stack", "hitEntity", "target", "Lnet/minecraft/entity/EntityLivingBase;", "attacker", "isDamageable", "isFullyCharged", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "worldIn", "Lnet/minecraft/world/World;", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "handIn", "Lnet/minecraft/util/EnumHand;", "performChargeAttack", "world", "entityPlayer", "showDurabilityBar", "Companion", "afraidofthedark"})
public abstract class AOTDItemChargeableSword
extends AOTDItemSword {
    private double percentChargePerAttack;
    private static final String NBT_CHARGE = "charge";
    public static final Companion Companion = new Companion(null);

    protected final double getPercentChargePerAttack() {
        return this.percentChargePerAttack;
    }

    protected final void setPercentChargePerAttack(double d) {
        this.percentChargePerAttack = d;
    }

    public boolean func_77644_a(@NotNull ItemStack stack, @NotNull EntityLivingBase target, @NotNull EntityLivingBase attacker) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(attacker, "attacker");
        if (target instanceof EntityPlayer || target instanceof EntityLiving) {
            this.addCharge(stack, this.percentChargePerAttack);
        }
        return true;
    }

    public double getDurabilityForDisplay(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return 1.0 - this.getCharge(stack) / 100.0;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean showDurabilityBar(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return true;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, @NotNull EntityPlayer playerIn, @NotNull EnumHand handIn) {
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Intrinsics.checkParameterIsNotNull(playerIn, "playerIn");
        Intrinsics.checkParameterIsNotNull(handIn, "handIn");
        ItemStack swordStack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            ItemStack itemStack = swordStack;
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "swordStack");
            if (this.isFullyCharged(itemStack)) {
                if (this.performChargeAttack(swordStack, worldIn, playerIn)) {
                    this.addCharge(swordStack, -100.0);
                }
            } else {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:chargable_sword.not_enough_energy", new Object[0]));
            }
        }
        ActionResult actionResult = ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)swordStack);
        Intrinsics.checkExpressionValueIsNotNull(actionResult, "ActionResult.newResult(E\u2026nResult.FAIL, swordStack)");
        return actionResult;
    }

    public abstract boolean performChargeAttack(@NotNull ItemStack var1, @NotNull World var2, @NotNull EntityPlayer var3);

    public final double getCharge(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        this.ensureChargeInit(itemStack);
        Double d = NBTHelper.INSTANCE.getDouble(itemStack, NBT_CHARGE);
        if (d == null) {
            Intrinsics.throwNpe();
        }
        return d;
    }

    public final void addCharge(@NotNull ItemStack itemStack, double charge) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        this.ensureChargeInit(itemStack);
        Double d = NBTHelper.INSTANCE.getDouble(itemStack, NBT_CHARGE);
        if (d == null) {
            Intrinsics.throwNpe();
        }
        double newCharge = RangesKt.coerceIn(d + charge, 0.0, 100.0);
        NBTHelper.INSTANCE.setDouble(itemStack, NBT_CHARGE, newCharge);
    }

    public final boolean isFullyCharged(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        this.ensureChargeInit(itemStack);
        return Intrinsics.areEqual(NBTHelper.INSTANCE.getDouble(itemStack, NBT_CHARGE), 100.0);
    }

    private final void ensureChargeInit(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_CHARGE)) {
            NBTHelper.INSTANCE.setDouble(itemStack, NBT_CHARGE, 0.0);
        }
    }

    public AOTDItemChargeableSword(@NotNull String baseName, @NotNull Item.ToolMaterial toolMaterial, boolean displayInCreative) {
        Intrinsics.checkParameterIsNotNull(baseName, "baseName");
        Intrinsics.checkParameterIsNotNull(toolMaterial, "toolMaterial");
        super(baseName, toolMaterial, displayInCreative);
        this.percentChargePerAttack = 5.0;
        this.func_77656_e(0);
        this.func_185043_a(new ResourceLocation("afraidofthedark", "charged"), new IItemPropertyGetter(){

            public final float func_185085_a(@NotNull ItemStack stack, @Nullable World $noName_1, @Nullable EntityLivingBase $noName_2) {
                Intrinsics.checkParameterIsNotNull(stack, "stack");
                return this.isFullyCharged(stack) ? 1.0f : 0.0f;
            }
        });
    }

    public /* synthetic */ AOTDItemChargeableSword(String string, Item.ToolMaterial toolMaterial, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, toolMaterial, bl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItemChargeableSword$Companion;", "", "()V", "NBT_CHARGE", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

