/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item.core;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.packets.otherPackets.SyncItemWithCooldown;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItemWithPerItemCooldown;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "baseName", "", "displayInCreative", "", "(Ljava/lang/String;Z)V", "serverClientTimeDifference", "", "cooldownRemainingInSeconds", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "getCooldownInMilliseconds", "getDurabilityForDisplay", "", "stack", "getLastUseTime", "isOnCooldown", "setOnCooldown", "", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "showDurabilityBar", "updateServerClientDifference", "difference", "Companion", "afraidofthedark"})
public abstract class AOTDItemWithPerItemCooldown
extends AOTDItem {
    private long serverClientTimeDifference;
    private static final String NBT_LAST_USE_TIME = "last_use_time";
    public static final Companion Companion = new Companion(null);

    public final void updateServerClientDifference(long difference) {
        this.serverClientTimeDifference = difference;
    }

    public void setOnCooldown(@NotNull ItemStack itemStack, @NotNull EntityPlayer entityPlayer) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(entityPlayer, "entityPlayer");
        NBTHelper.INSTANCE.setLong(itemStack, NBT_LAST_USE_TIME, System.currentTimeMillis());
        if (!entityPlayer.field_70170_p.field_72995_K) {
            AfraidOfTheDark.Companion.getINSTANCE().getPacketHandler().sendTo(new SyncItemWithCooldown(System.currentTimeMillis(), this), (EntityPlayerMP)entityPlayer);
        }
    }

    public final boolean isOnCooldown(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        long millisecondsElapsed = System.currentTimeMillis() - this.getLastUseTime(itemStack);
        return millisecondsElapsed < (long)this.getCooldownInMilliseconds(itemStack);
    }

    public final int cooldownRemainingInSeconds(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        long millisecondsElapsed = System.currentTimeMillis() - this.getLastUseTime(itemStack);
        double d = (double)((long)this.getCooldownInMilliseconds(itemStack) - millisecondsElapsed) / 1000.0;
        boolean bl = false;
        return (int)Math.ceil(d);
    }

    public double getDurabilityForDisplay(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        long millisecondsElapsed = System.currentTimeMillis() - this.serverClientTimeDifference - this.getLastUseTime(stack);
        double d = 0.0;
        double d2 = 1.0 - (double)millisecondsElapsed / (double)this.getCooldownInMilliseconds(stack);
        boolean bl = false;
        return Math.max(d, d2);
    }

    private final long getLastUseTime(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_LAST_USE_TIME)) {
            NBTHelper.INSTANCE.setLong(itemStack, NBT_LAST_USE_TIME, 0L);
        }
        Long l = NBTHelper.INSTANCE.getLong(itemStack, NBT_LAST_USE_TIME);
        if (l == null) {
            Intrinsics.throwNpe();
        }
        return l;
    }

    public boolean showDurabilityBar(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        return true;
    }

    public abstract int getCooldownInMilliseconds(@NotNull ItemStack var1);

    public AOTDItemWithPerItemCooldown(@NotNull String baseName, boolean displayInCreative) {
        Intrinsics.checkParameterIsNotNull(baseName, "baseName");
        super(baseName, displayInCreative);
        this.func_77625_d(1);
    }

    public /* synthetic */ AOTDItemWithPerItemCooldown(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItemWithPerItemCooldown$Companion;", "", "()V", "NBT_LAST_USE_TIME", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

