/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item.telescope;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IAOTDPlayerResearch;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.item.telescope.ItemTelescopeBase;
import com.davidm1a2.afraidofthedark.common.registry.research.Research;
import com.davidm1a2.afraidofthedark.common.utility.PlayerExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/telescope/ItemTelescope;", "Lcom/davidm1a2/afraidofthedark/common/item/telescope/ItemTelescopeBase;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "getRequiredResearch", "Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "afraidofthedark"})
public final class ItemTelescope
extends ItemTelescopeBase {
    @Override
    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        BlockPos blockPos = player.func_180425_c();
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "player.position");
        boolean highEnough = blockPos.func_177956_o() > 128;
        IAOTDPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch(player);
        if (!world.field_72995_K && playerResearch.canResearch(ModResearches.INSTANCE.getASTRONOMY_1()) && highEnough) {
            playerResearch.setResearch(ModResearches.INSTANCE.getASTRONOMY_1(), true);
            playerResearch.sync(player, true);
        }
        if (world.field_72995_K && highEnough && playerResearch.canResearch(this.getRequiredResearch())) {
            PlayerExtensionsKt.openGui(player, 5);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    @NotNull
    public Research getRequiredResearch() {
        return ModResearches.INSTANCE.getASTRONOMY_1();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(tooltip, "tooltip");
        Intrinsics.checkParameterIsNotNull(flag, "flag");
        Object object = Minecraft.func_71410_x().field_71439_g;
        if (object != null && (object = CapabilityExtensionsKt.getResearch((EntityPlayer)object)) != null) {
            Research research = this.getRequiredResearch().getPreRequisite();
            if (research == null) {
                Intrinsics.throwNpe();
            }
            if (object.isResearched(research)) {
                String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:telescope.directions", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026SCOPE_TOOLTIP_DIRECTIONS)");
                tooltip.add(string);
                String string2 = I18n.func_135052_a((String)"tooltip.afraidofthedark:telescope.accuracy", (Object[])new Object[]{this.getAccuracy()});
                Intrinsics.checkExpressionValueIsNotNull(string2, "I18n.format(Localization\u2026OLTIP_ACCURACY, accuracy)");
                tooltip.add(string2);
                return;
            }
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ItemTelescope() {
        super(130, "telescope");
    }
}

