/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item.telescope;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IAOTDPlayerResearch;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.registry.research.Research;
import com.davidm1a2.afraidofthedark.common.utility.PlayerExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u0014H&J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/telescope/ItemTelescopeBase;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "accuracy", "", "name", "", "(ILjava/lang/String;)V", "getAccuracy", "()I", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "getRequiredResearch", "Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "afraidofthedark"})
public abstract class ItemTelescopeBase
extends AOTDItem {
    private final int accuracy;

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        ItemStack itemStack = player.func_184586_b(hand);
        IAOTDPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch(player);
        BlockPos blockPos = player.func_180425_c();
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "player.position");
        boolean highEnough = blockPos.func_177956_o() > 128;
        Research research = this.getRequiredResearch();
        if (!world.field_72995_K) {
            if (playerResearch.isResearched(research)) {
                if (!highEnough) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:telescope.not_high_enough", new Object[0]));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:dont_understand", new Object[0]));
            }
        }
        if (world.field_72995_K && highEnough && playerResearch.isResearched(research)) {
            PlayerExtensionsKt.openGui(player, 5);
        }
        ActionResult actionResult = ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
        Intrinsics.checkExpressionValueIsNotNull(actionResult, "ActionResult.newResult(E\u2026esult.SUCCESS, itemStack)");
        return actionResult;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(tooltip, "tooltip");
        Intrinsics.checkParameterIsNotNull(flag, "flag");
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && CapabilityExtensionsKt.getResearch((EntityPlayer)player).isResearched(this.getRequiredResearch())) {
            String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:telescope.directions", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026SCOPE_TOOLTIP_DIRECTIONS)");
            tooltip.add(string);
            String string2 = I18n.func_135052_a((String)"tooltip.afraidofthedark:telescope.accuracy", (Object[])new Object[]{this.accuracy});
            Intrinsics.checkExpressionValueIsNotNull(string2, "I18n.format(Localization\u2026OLTIP_ACCURACY, accuracy)");
            tooltip.add(string2);
        } else {
            String string = I18n.func_135052_a((String)"message.afraidofthedark:dont_understand", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026.Generic.DONT_UNDERSTAND)");
            tooltip.add(string);
        }
    }

    @NotNull
    public abstract Research getRequiredResearch();

    public final int getAccuracy() {
        return this.accuracy;
    }

    public ItemTelescopeBase(int accuracy, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        super(name, false, 2, null);
        this.accuracy = accuracy;
        boolean bl = this.accuracy >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Accuracy for telescopes must be positive!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.field_77777_bU = 1;
    }
}

