/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.packets;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/davidm1a2/afraidofthedark/common/packets/EntitySyncBase;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "entity", "Lnet/minecraft/entity/Entity;", "(Lnet/minecraft/entity/Entity;)V", "entityID", "", "getEntityID", "()I", "setEntityID", "(I)V", "entityUUID", "Ljava/util/UUID;", "getEntityUUID", "()Ljava/util/UUID;", "setEntityUUID", "(Ljava/util/UUID;)V", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "afraidofthedark"})
public abstract class EntitySyncBase
implements IMessage {
    @NotNull
    protected UUID entityUUID;
    private int entityID;

    @NotNull
    protected final UUID getEntityUUID() {
        UUID uUID = this.entityUUID;
        if (uUID == null) {
            Intrinsics.throwUninitializedPropertyAccessException("entityUUID");
        }
        return uUID;
    }

    protected final void setEntityUUID(@NotNull UUID uUID) {
        Intrinsics.checkParameterIsNotNull(uUID, "<set-?>");
        this.entityUUID = uUID;
    }

    protected final int getEntityID() {
        return this.entityID;
    }

    protected final void setEntityID(int n) {
        this.entityID = n;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull(buf, "buf");
        this.entityUUID = new UUID(buf.readLong(), buf.readLong());
        this.entityID = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull(buf, "buf");
        UUID uUID = this.entityUUID;
        if (uUID == null) {
            Intrinsics.throwUninitializedPropertyAccessException("entityUUID");
        }
        buf.writeLong(uUID.getMostSignificantBits());
        UUID uUID2 = this.entityUUID;
        if (uUID2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("entityUUID");
        }
        buf.writeLong(uUID2.getLeastSignificantBits());
        buf.writeInt(this.entityID);
    }

    public EntitySyncBase() {
        this.entityID = 0;
    }

    public EntitySyncBase(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        UUID uUID = entity.getPersistentID();
        Intrinsics.checkExpressionValueIsNotNull(uUID, "entity.persistentID");
        this.entityUUID = uUID;
        this.entityID = entity.func_145782_y();
    }
}

