/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.client.particle.AOTDParticleRegistry;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.constants.ModSounds;
import com.davidm1a2.afraidofthedark.common.packets.otherPackets.SyncParticle;
import com.davidm1a2.afraidofthedark.common.packets.packetHandler.PacketHandler;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionStateBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.powerSource.base.SpellPowerSource;
import com.davidm1a2.afraidofthedark.common.spell.component.powerSource.base.SpellPowerSourceInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001.B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u0004\u0018\u00010\u001a2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(J\b\u0010+\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020\u0002H\u0016J\b\u0010-\u001a\u00020\fH\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006/"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/NBTTagCompound;", "()V", "nbt", "(Lnet/minecraft/nbt/NBTTagCompound;)V", "<set-?>", "Ljava/util/UUID;", "id", "getId", "()Ljava/util/UUID;", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "powerSource", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/powerSource/base/SpellPowerSource;", "getPowerSource", "()Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "setPowerSource", "(Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;)V", "spellStages", "", "Lcom/davidm1a2/afraidofthedark/common/spell/SpellStage;", "getSpellStages", "()Ljava/util/List;", "attemptToCast", "", "entity", "Lnet/minecraft/entity/Entity;", "direction", "Lnet/minecraft/util/math/Vec3d;", "deserializeNBT", "getCost", "", "getStage", "index", "", "hasStage", "", "isValid", "serializeNBT", "toString", "Companion", "afraidofthedark"})
public final class Spell
implements INBTSerializable<NBTTagCompound> {
    @NotNull
    public String name;
    @NotNull
    private UUID id;
    @Nullable
    private SpellComponentInstance<SpellPowerSource> powerSource;
    @NotNull
    private final List<SpellStage> spellStages;
    private static final String NBT_NAME = "name";
    private static final String NBT_ID = "id";
    private static final String NBT_POWER_SOURCE = "power_source";
    private static final String NBT_SPELL_STAGES = "spell_stages";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getName() {
        String string = this.name;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException(NBT_NAME);
        }
        return string;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "<set-?>");
        this.name = string;
    }

    @NotNull
    public final UUID getId() {
        UUID uUID = this.id;
        if (uUID == null) {
            Intrinsics.throwUninitializedPropertyAccessException(NBT_ID);
        }
        return uUID;
    }

    @Nullable
    public final SpellComponentInstance<SpellPowerSource> getPowerSource() {
        return this.powerSource;
    }

    public final void setPowerSource(@Nullable SpellComponentInstance<SpellPowerSource> spellComponentInstance) {
        this.powerSource = spellComponentInstance;
    }

    @NotNull
    public final List<SpellStage> getSpellStages() {
        return this.spellStages;
    }

    /*
     * WARNING - void declaration
     */
    public final void attemptToCast(@NotNull Entity entity, @NotNull Vec3d direction) {
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        Intrinsics.checkParameterIsNotNull(direction, "direction");
        if (!entity.field_70170_p.field_72995_K) {
            if (entity.field_71093_bK != ModDimensions.INSTANCE.getNIGHTMARE().func_186068_a()) {
                if (this.isValid()) {
                    SpellComponentInstance<SpellPowerSource> spellComponentInstance = this.powerSource;
                    if (spellComponentInstance == null) {
                        Intrinsics.throwNpe();
                    }
                    if (spellComponentInstance.getComponent().canCast(entity, this)) {
                        ArrayList<Vec3d> arrayList;
                        SpellComponentInstance<SpellPowerSource> spellComponentInstance2 = this.powerSource;
                        if (spellComponentInstance2 == null) {
                            Intrinsics.throwNpe();
                        }
                        spellComponentInstance2.getComponent().consumePowerToCast(entity, this);
                        entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), ModSounds.INSTANCE.getSPELL_CAST(), SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.4));
                        List positions = new ArrayList();
                        int n = 0;
                        int n2 = Random.Default.nextInt(2, 6);
                        while (n < n2) {
                            void i;
                            positions.add(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
                            ++i;
                        }
                        n = positions.size();
                        List list = positions;
                        AOTDParticleRegistry.ParticleTypes particleTypes = AOTDParticleRegistry.ParticleTypes.SPELL_CAST_ID;
                        PacketHandler packetHandler = AfraidOfTheDark.Companion.getINSTANCE().getPacketHandler();
                        n2 = 0;
                        boolean bl = false;
                        ArrayList<Vec3d> arrayList2 = new ArrayList<Vec3d>(n);
                        boolean bl2 = false;
                        int n3 = 0;
                        n3 = 0;
                        int n4 = n;
                        while (n3 < n4) {
                            Vec3d vec3d;
                            int n5 = n3++;
                            boolean bl3 = false;
                            int n6 = n5;
                            arrayList = arrayList2;
                            boolean bl4 = false;
                            Intrinsics.checkExpressionValueIsNotNull(Vec3d.field_186680_a, "Vec3d.ZERO");
                            arrayList.add(vec3d);
                        }
                        ArrayList<Vec3d> arrayList3 = arrayList = (ArrayList<Vec3d>)arrayList2;
                        List list2 = list;
                        AOTDParticleRegistry.ParticleTypes particleTypes2 = particleTypes;
                        packetHandler.sendToAllAround(new SyncParticle(particleTypes2, list2, arrayList3), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 100.0));
                        SpellStage spellStage = this.getStage(0);
                        if (spellStage == null) {
                            Intrinsics.throwNpe();
                        }
                        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance3 = spellStage.getDeliveryInstance();
                        if (spellComponentInstance3 == null) {
                            Intrinsics.throwNpe();
                        }
                        spellComponentInstance3.getComponent().executeDelivery(new DeliveryTransitionStateBuilder().withSpell(this).withStageIndex(0).withCasterEntity(entity).withEntity(entity).withDirection(direction).build());
                    } else {
                        SpellComponentInstance<SpellPowerSource> spellComponentInstance4 = this.powerSource;
                        if (spellComponentInstance4 == null) {
                            Intrinsics.throwNpe();
                        }
                        entity.func_145747_a((ITextComponent)new TextComponentTranslation(spellComponentInstance4.getComponent().getUnlocalizedOutOfPowerMsg(), new Object[0]));
                        if (!(entity instanceof EntityPlayer)) {
                            AfraidOfTheDark.Companion.getINSTANCE().getLogger().info("Entity '" + entity.func_70005_c_() + "' attempted to cast a spell without enough power?");
                        }
                    }
                } else {
                    entity.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:spell.invalid", new Object[0]));
                    if (!(entity instanceof EntityPlayer)) {
                        AfraidOfTheDark.Companion.getINSTANCE().getLogger().info("Entity '" + entity.func_70005_c_() + "' attempted to cast an invalid spell?");
                    }
                }
            } else {
                entity.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:spell.wrong_dimension", new Object[0]));
                if (!(entity instanceof EntityPlayer)) {
                    AfraidOfTheDark.Companion.getINSTANCE().getLogger().info("Entity '" + entity.func_70005_c_() + "' attempted to cast a spell in the nightmare?");
                }
            }
        }
    }

    public static /* synthetic */ void attemptToCast$default(Spell spell, Entity entity, Vec3d vec3d, int n, Object object) {
        if ((n & 2) != 0) {
            Vec3d vec3d2 = entity.func_70040_Z();
            Intrinsics.checkExpressionValueIsNotNull(vec3d2, "entity.lookVec");
            vec3d = vec3d2;
        }
        spell.attemptToCast(entity, vec3d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValid() {
        SpellStage it;
        if (this.powerSource == null) return false;
        Collection collection = this.spellStages;
        boolean bl = false;
        if (collection.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = this.spellStages;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (SpellStage)element$iv;
            boolean bl3 = false;
        } while (it.isValid());
        return false;
    }

    public final double getCost() {
        double cost = 0.0;
        double costMultiplier = 1.0;
        for (SpellStage spellStage : this.spellStages) {
            cost += spellStage.getCost() * costMultiplier;
            costMultiplier += 0.05;
        }
        if (cost < 0.0) {
            cost = DoubleCompanionObject.INSTANCE.getMAX_VALUE();
        }
        return cost;
    }

    public final boolean hasStage(int index) {
        return index >= 0 && index < this.spellStages.size();
    }

    @Nullable
    public final SpellStage getStage(int index) {
        return this.hasStage(index) ? this.spellStages.get(index) : null;
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        String string = this.name;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException(NBT_NAME);
        }
        nbt.func_74778_a(NBT_NAME, string);
        UUID uUID = this.id;
        if (uUID == null) {
            Intrinsics.throwUninitializedPropertyAccessException(NBT_ID);
        }
        nbt.func_74782_a(NBT_ID, (NBTBase)NBTUtil.func_186862_a((UUID)uUID));
        SpellComponentInstance<SpellPowerSource> spellComponentInstance = this.powerSource;
        if (spellComponentInstance != null) {
            SpellComponentInstance<SpellPowerSource> spellComponentInstance2 = spellComponentInstance;
            boolean bl = false;
            boolean bl2 = false;
            SpellComponentInstance<SpellPowerSource> it = spellComponentInstance2;
            boolean bl3 = false;
            nbt.func_74782_a(NBT_POWER_SOURCE, (NBTBase)it.serializeNBT());
        }
        NBTTagList spellStagesNBT = new NBTTagList();
        Iterable $this$forEach$iv = this.spellStages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpellStage it = (SpellStage)element$iv;
            boolean bl = false;
            spellStagesNBT.func_74742_a((NBTBase)it.serializeNBT());
        }
        nbt.func_74782_a(NBT_SPELL_STAGES, (NBTBase)spellStagesNBT);
        return nbt;
    }

    /*
     * WARNING - void declaration
     */
    public void deserializeNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        String string = nbt.func_74779_i(NBT_NAME);
        Intrinsics.checkExpressionValueIsNotNull(string, "nbt.getString(NBT_NAME)");
        this.name = string;
        UUID uUID = NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l(NBT_ID));
        Intrinsics.checkExpressionValueIsNotNull(uUID, "NBTUtil.getUUIDFromTag(nbt.getCompoundTag(NBT_ID))");
        this.id = uUID;
        if (nbt.func_74764_b(NBT_POWER_SOURCE)) {
            NBTTagCompound nBTTagCompound = nbt.func_74775_l(NBT_POWER_SOURCE);
            Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "nbt.getCompoundTag(NBT_POWER_SOURCE)");
            this.powerSource = SpellPowerSourceInstance.Companion.createFromNBT(nBTTagCompound);
        }
        NBTTagList spellStagesNBT = nbt.func_150295_c(NBT_SPELL_STAGES, 10);
        this.spellStages.clear();
        int n = 0;
        int n2 = spellStagesNBT.func_74745_c();
        while (n < n2) {
            void i;
            NBTTagCompound spellStageNBT;
            NBTTagCompound nBTTagCompound = spellStageNBT = spellStagesNBT.func_150305_b((int)i);
            Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "spellStageNBT");
            SpellStage spellStage = new SpellStage(nBTTagCompound);
            this.spellStages.add(spellStage);
            ++i;
        }
    }

    @NotNull
    public String toString() {
        ResourceLocation resourceLocation;
        StringBuilder stringBuilder = new StringBuilder().append("Spell ");
        String string = this.name;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException(NBT_NAME);
        }
        return stringBuilder.append(string).append('\n').append("Power Source: ").append((resourceLocation = this.powerSource) != null && (resourceLocation = resourceLocation.getComponent()) != null && (resourceLocation = resourceLocation.getRegistryName()) != null ? resourceLocation.func_110623_a() : null).append('\n').append("Spell Stages:\n").append(CollectionsKt.joinToString$default(this.spellStages, "\n", null, null, 0, null, toString.1.INSTANCE, 30, null)).toString();
    }

    public Spell() {
        List list;
        Spell spell = this;
        boolean bl = false;
        spell.spellStages = list = (List)new ArrayList();
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkExpressionValueIsNotNull(uUID, "UUID.randomUUID()");
        this.id = uUID;
        this.name = "";
    }

    public Spell(@NotNull NBTTagCompound nbt) {
        List list;
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        Spell spell = this;
        boolean bl = false;
        spell.spellStages = list = (List)new ArrayList();
        this.deserializeNBT(nbt);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/Spell$Companion;", "", "()V", "NBT_ID", "", "NBT_NAME", "NBT_POWER_SOURCE", "NBT_SPELL_STAGES", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

