/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell;

import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethodInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffectInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0002H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR!\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00070\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/SpellStage;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/NBTTagCompound;", "()V", "spellStageNBT", "(Lnet/minecraft/nbt/NBTTagCompound;)V", "deliveryInstance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/SpellDeliveryMethod;", "getDeliveryInstance", "()Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "setDeliveryInstance", "(Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;)V", "effects", "", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "getEffects", "()[Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "[Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "deserializeNBT", "", "nbt", "getCost", "", "isValid", "", "serializeNBT", "toString", "", "Companion", "afraidofthedark"})
public final class SpellStage
implements INBTSerializable<NBTTagCompound> {
    @Nullable
    private SpellComponentInstance<SpellDeliveryMethod> deliveryInstance;
    @NotNull
    private final SpellComponentInstance<SpellEffect>[] effects;
    private static final String NBT_DELIVERY_METHOD = "delivery_method";
    private static final String NBT_EFFECT_BASE = "effect_";
    private static final int MAX_EFFECTS_PER_STAGE = 4;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final SpellComponentInstance<SpellDeliveryMethod> getDeliveryInstance() {
        return this.deliveryInstance;
    }

    public final void setDeliveryInstance(@Nullable SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance) {
        this.deliveryInstance = spellComponentInstance;
    }

    @NotNull
    public final SpellComponentInstance<SpellEffect>[] getEffects() {
        return this.effects;
    }

    public final double getCost() {
        if (this.isValid()) {
            SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = this.deliveryInstance;
            if (spellComponentInstance == null) {
                Intrinsics.throwNpe();
            }
            SpellDeliveryMethod deliveryType = spellComponentInstance.getComponent();
            SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance2 = this.deliveryInstance;
            if (spellComponentInstance2 == null) {
                Intrinsics.throwNpe();
            }
            double cost = deliveryType.getCost(spellComponentInstance2);
            for (SpellComponentInstance<SpellEffect> effect : this.effects) {
                if (effect == null) continue;
                SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance3 = this.deliveryInstance;
                if (spellComponentInstance3 == null) {
                    Intrinsics.throwNpe();
                }
                cost += deliveryType.getCost(spellComponentInstance3) * effect.getComponent().getCost(effect);
            }
            return cost;
        }
        return 0.0;
    }

    public final boolean isValid() {
        return this.deliveryInstance != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = this.deliveryInstance;
        if (spellComponentInstance != null) {
            SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance2 = spellComponentInstance;
            boolean bl = false;
            boolean bl2 = false;
            SpellComponentInstance<SpellDeliveryMethod> it = spellComponentInstance2;
            boolean bl3 = false;
            nbt.func_74782_a(NBT_DELIVERY_METHOD, (NBTBase)it.serializeNBT());
        }
        SpellComponentInstance<SpellEffect>[] $this$forEachIndexed$iv = this.effects;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (SpellComponentInstance<SpellEffect> item$iv : $this$forEachIndexed$iv) {
            void var12_12;
            void effect;
            int n = index$iv++;
            SpellComponentInstance<SpellEffect> spellComponentInstance3 = item$iv;
            int i = n;
            boolean bl = false;
            if (effect == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            void it = var12_12;
            boolean bl6 = false;
            nbt.func_74782_a(NBT_EFFECT_BASE + i, (NBTBase)it.serializeNBT());
        }
        return nbt;
    }

    /*
     * WARNING - void declaration
     */
    public void deserializeNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        if (nbt.func_74764_b(NBT_DELIVERY_METHOD)) {
            NBTTagCompound nBTTagCompound = nbt.func_74775_l(NBT_DELIVERY_METHOD);
            Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "nbt.getCompoundTag(NBT_DELIVERY_METHOD)");
            this.deliveryInstance = SpellDeliveryMethodInstance.Companion.createFromNBT(nBTTagCompound);
        }
        int n = 0;
        int n2 = this.effects.length;
        while (n < n2) {
            void i;
            if (nbt.func_74764_b(NBT_EFFECT_BASE + (int)i)) {
                NBTTagCompound nBTTagCompound = nbt.func_74775_l(NBT_EFFECT_BASE + (int)i);
                Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "nbt.getCompoundTag(NBT_EFFECT_BASE + i)");
                this.effects[i] = SpellEffectInstance.Companion.createFromNBT(nBTTagCompound);
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = ArraysKt.filterNotNull(this.effects);
        ResourceLocation resourceLocation = this.deliveryInstance;
        StringBuilder stringBuilder = new StringBuilder().append(resourceLocation != null && (resourceLocation = resourceLocation.getComponent()) != null && (resourceLocation = resourceLocation.getRegistryName()) != null ? resourceLocation.func_110623_a() : null).append(": ");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SpellComponentInstance spellComponentInstance = (SpellComponentInstance)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ResourceLocation resourceLocation2 = ((SpellEffect)((Object)it.getComponent())).getRegistryName();
            String string = resourceLocation2 != null ? resourceLocation2.func_110623_a() : null;
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder.append(CollectionsKt.joinToString$default(collection, ", ", "[", "]", 0, null, null, 56, null)).toString();
    }

    public SpellStage() {
        this.effects = new SpellComponentInstance[4];
        this.deliveryInstance = null;
    }

    public SpellStage(@NotNull NBTTagCompound spellStageNBT) {
        Intrinsics.checkParameterIsNotNull(spellStageNBT, "spellStageNBT");
        this.effects = new SpellComponentInstance[4];
        this.deserializeNBT(spellStageNBT);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/SpellStage$Companion;", "", "()V", "MAX_EFFECTS_PER_STAGE", "", "NBT_DELIVERY_METHOD", "", "NBT_EFFECT_BASE", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

