/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component;

import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0001,BU\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010&\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u0004\u0018\u00010\u000eJ\b\u0010*\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010+\u001a\u00020\u0013R\u0011\u0010\u0015\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0006\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006-"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "", "spell", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "stageIndex", "", "world", "Lnet/minecraft/world/World;", "position", "Lnet/minecraft/util/math/Vec3d;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "direction", "casterEntity", "Lnet/minecraft/entity/Entity;", "entity", "deliveryEntity", "(Lcom/davidm1a2/afraidofthedark/common/spell/Spell;ILnet/minecraft/world/World;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/Entity;)V", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "(Lnet/minecraft/nbt/NBTTagCompound;)V", "blockPosition", "getBlockPosition", "()Lnet/minecraft/util/math/BlockPos;", "casterEntityId", "Ljava/util/UUID;", "deliveryEntityId", "getDirection", "()Lnet/minecraft/util/math/Vec3d;", "entityId", "getPosition", "getSpell", "()Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "getStageIndex", "()I", "Lnet/minecraft/world/WorldServer;", "getWorld", "()Lnet/minecraft/world/WorldServer;", "getCasterEntity", "getCurrentStage", "Lcom/davidm1a2/afraidofthedark/common/spell/SpellStage;", "getDeliveryEntity", "getEntity", "writeToNbt", "Companion", "afraidofthedark"})
public final class DeliveryTransitionState {
    @NotNull
    private final Spell spell;
    private final int stageIndex;
    @NotNull
    private final WorldServer world;
    @NotNull
    private final Vec3d position;
    @NotNull
    private final BlockPos blockPosition;
    @NotNull
    private final Vec3d direction;
    private final UUID casterEntityId;
    private final UUID entityId;
    private final UUID deliveryEntityId;
    private static final String NBT_SPELL = "spell";
    private static final String NBT_STAGE_INDEX = "stage_index";
    private static final String NBT_WORLD_ID = "world_id";
    private static final String NBT_POSITION = "position";
    private static final String NBT_BLOCK_POSITION = "block_position";
    private static final String NBT_DIRECTION = "direction";
    private static final String NBT_CASTER_ENTITY_ID = "caster_entity_id";
    private static final String NBT_ENTITY_ID = "entity_id";
    private static final String NBT_DELIVERY_ENTITY_ID = "delivery_entity_id";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Spell getSpell() {
        return this.spell;
    }

    public final int getStageIndex() {
        return this.stageIndex;
    }

    @NotNull
    public final WorldServer getWorld() {
        return this.world;
    }

    @NotNull
    public final Vec3d getPosition() {
        return this.position;
    }

    @NotNull
    public final BlockPos getBlockPosition() {
        return this.blockPosition;
    }

    @NotNull
    public final Vec3d getDirection() {
        return this.direction;
    }

    @NotNull
    public final NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a(NBT_SPELL, (NBTBase)this.spell.serializeNBT());
        nbt.func_74768_a(NBT_STAGE_INDEX, this.stageIndex);
        WorldProvider worldProvider = this.world.field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull(worldProvider, "world.provider");
        nbt.func_74768_a(NBT_WORLD_ID, worldProvider.getDimension());
        nbt.func_74780_a("position_x", this.position.field_72450_a);
        nbt.func_74780_a("position_y", this.position.field_72448_b);
        nbt.func_74780_a("position_z", this.position.field_72449_c);
        nbt.func_74782_a(NBT_BLOCK_POSITION, (NBTBase)NBTUtil.func_186859_a((BlockPos)this.blockPosition));
        nbt.func_74780_a("direction_x", this.direction.field_72450_a);
        nbt.func_74780_a("direction_y", this.direction.field_72448_b);
        nbt.func_74780_a("direction_z", this.direction.field_72449_c);
        if (this.casterEntityId != null) {
            nbt.func_74782_a(NBT_CASTER_ENTITY_ID, (NBTBase)NBTUtil.func_186862_a((UUID)this.casterEntityId));
        }
        if (this.entityId != null) {
            nbt.func_74782_a(NBT_ENTITY_ID, (NBTBase)NBTUtil.func_186862_a((UUID)this.entityId));
        }
        if (this.deliveryEntityId != null) {
            nbt.func_74782_a(NBT_DELIVERY_ENTITY_ID, (NBTBase)NBTUtil.func_186862_a((UUID)this.deliveryEntityId));
        }
        return nbt;
    }

    @NotNull
    public final SpellStage getCurrentStage() {
        SpellStage spellStage = this.spell.getStage(this.stageIndex);
        if (spellStage == null) {
            throw (Throwable)new IllegalArgumentException("Current spell state is null, that shouldn't be possible. Spell: \n" + this.spell.getName());
        }
        return spellStage;
    }

    @Nullable
    public final Entity getCasterEntity() {
        Entity entity;
        UUID uUID = this.casterEntityId;
        if (uUID != null) {
            UUID uUID2 = uUID;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            entity = this.world.func_175733_a(this.casterEntityId);
        } else {
            entity = null;
        }
        return entity;
    }

    @Nullable
    public final Entity getEntity() {
        Entity entity;
        UUID uUID = this.entityId;
        if (uUID != null) {
            UUID uUID2 = uUID;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            entity = this.world.func_175733_a(it);
        } else {
            entity = null;
        }
        return entity;
    }

    @Nullable
    public final Entity getDeliveryEntity() {
        Entity entity;
        UUID uUID = this.deliveryEntityId;
        if (uUID != null) {
            UUID uUID2 = uUID;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            entity = this.world.func_175733_a(it);
        } else {
            entity = null;
        }
        return entity;
    }

    public DeliveryTransitionState(@NotNull Spell spell, int stageIndex, @NotNull World world, @NotNull Vec3d position, @NotNull BlockPos blockPos, @NotNull Vec3d direction, @Nullable Entity casterEntity, @Nullable Entity entity, @Nullable Entity deliveryEntity) {
        Intrinsics.checkParameterIsNotNull(spell, NBT_SPELL);
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(position, NBT_POSITION);
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        Intrinsics.checkParameterIsNotNull(direction, NBT_DIRECTION);
        this.spell = spell;
        this.stageIndex = stageIndex;
        this.world = (WorldServer)world;
        this.position = position;
        this.blockPosition = blockPos;
        this.direction = direction;
        Entity entity2 = casterEntity;
        this.casterEntityId = entity2 != null ? entity2.getPersistentID() : null;
        Entity entity3 = entity;
        this.entityId = entity3 != null ? entity3.getPersistentID() : null;
        Entity entity4 = deliveryEntity;
        this.deliveryEntityId = entity4 != null ? entity4.getPersistentID() : null;
    }

    public DeliveryTransitionState(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        NBTTagCompound nBTTagCompound = nbt.func_74775_l(NBT_SPELL);
        Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "nbt.getCompoundTag(NBT_SPELL)");
        this.spell = new Spell(nBTTagCompound);
        this.stageIndex = nbt.func_74762_e(NBT_STAGE_INDEX);
        WorldServer worldServer = DimensionManager.getWorld((int)nbt.func_74762_e(NBT_WORLD_ID));
        Intrinsics.checkExpressionValueIsNotNull(worldServer, "DimensionManager.getWorl\u2026getInteger(NBT_WORLD_ID))");
        this.world = worldServer;
        this.position = new Vec3d(nbt.func_74769_h("position_x"), nbt.func_74769_h("position_y"), nbt.func_74769_h("position_z"));
        BlockPos blockPos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l(NBT_BLOCK_POSITION));
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "NBTUtil.getPosFromTag(nb\u2026dTag(NBT_BLOCK_POSITION))");
        this.blockPosition = blockPos;
        this.direction = new Vec3d(nbt.func_74769_h("direction_x"), nbt.func_74769_h("direction_y"), nbt.func_74769_h("direction_z"));
        this.casterEntityId = nbt.func_74764_b(NBT_CASTER_ENTITY_ID) ? NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l(NBT_CASTER_ENTITY_ID)) : null;
        this.entityId = nbt.func_74764_b(NBT_ENTITY_ID) ? NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l(NBT_ENTITY_ID)) : null;
        this.deliveryEntityId = nbt.func_74764_b(NBT_DELIVERY_ENTITY_ID) ? NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l(NBT_DELIVERY_ENTITY_ID)) : null;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState$Companion;", "", "()V", "NBT_BLOCK_POSITION", "", "NBT_CASTER_ENTITY_ID", "NBT_DELIVERY_ENTITY_ID", "NBT_DIRECTION", "NBT_ENTITY_ID", "NBT_POSITION", "NBT_SPELL", "NBT_STAGE_INDEX", "NBT_WORLD_ID", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

