/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod;

import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionStateBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.AOTDSpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.helper.TargetType;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.DoubleSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentProperty;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0016J\u0014\u0010\u000f\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bJ\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0016J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bJ\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/SpellDeliveryMethodAOE;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/AOTDSpellDeliveryMethod;", "()V", "defaultEffectProc", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "effect", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "executeDelivery", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/SpellDeliveryMethod;", "getRadius", "getStageCostMultiplier", "getTargetType", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/helper/TargetType;", "performDefaultTransition", "Companion", "afraidofthedark"})
public final class SpellDeliveryMethodAOE
extends AOTDSpellDeliveryMethod {
    private static final String NBT_RADIUS = "radius";
    private static final String NBT_TARGET_TYPE = "target_type";
    public static final Companion Companion = new Companion(null);

    @Override
    public void executeDelivery(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        this.procEffects(state);
        this.transitionFrom(state);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void defaultEffectProc(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> effect) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(effect, "effect");
        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
        if (spellComponentInstance == null) {
            Intrinsics.throwNpe();
        }
        double radius = this.getRadius(spellComponentInstance);
        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance2 = state.getCurrentStage().getDeliveryInstance();
        if (spellComponentInstance2 == null) {
            Intrinsics.throwNpe();
        }
        if (this.getTargetType(spellComponentInstance2) == TargetType.ENTITY) {
            List entitiesWithinAABB;
            List list = entitiesWithinAABB = state.getWorld().func_72872_a(Entity.class, new AxisAlignedBB(new BlockPos(state.getPosition())).func_186662_g(radius));
            Intrinsics.checkExpressionValueIsNotNull(list, "entitiesWithinAABB");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity it = (Entity)element$iv;
                boolean bl = false;
                DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = new DeliveryTransitionStateBuilder().withSpell(state.getSpell()).withStageIndex(state.getStageIndex()).withCasterEntity(state.getCasterEntity());
                Entity entity = it;
                if (entity == null) {
                    Intrinsics.throwNpe();
                }
                effect.getComponent().procEffect(deliveryTransitionStateBuilder.withEntity(entity).build(), effect);
            }
        } else {
            BlockPos basePos = new BlockPos(state.getPosition());
            boolean $i$f$forEach = false;
            int blockRadius = (int)Math.floor(radius);
            DeliveryTransitionStateBuilder transitionBuilder = new DeliveryTransitionStateBuilder().withSpell(state.getSpell()).withStageIndex(state.getStageIndex()).withWorld((World)state.getWorld()).withCasterEntity(state.getCasterEntity());
            int n = -blockRadius;
            int n2 = blockRadius;
            if (n <= n2) {
                while (true) {
                    void x;
                    int n3;
                    int it;
                    if ((it = -blockRadius) <= (n3 = blockRadius)) {
                        while (true) {
                            void y;
                            int n4;
                            int n5;
                            if ((n5 = -blockRadius) <= (n4 = blockRadius)) {
                                while (true) {
                                    void z;
                                    BlockPos aoePos;
                                    if ((aoePos = basePos.func_177982_a((int)x, (int)y, (int)z)).func_177951_i((Vec3i)basePos) < radius * radius) {
                                        BlockPos blockPos = aoePos;
                                        Intrinsics.checkExpressionValueIsNotNull(blockPos, "aoePos");
                                        DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = transitionBuilder.withPosition(new Vec3d((double)blockPos.func_177958_n(), (double)aoePos.func_177956_o(), (double)aoePos.func_177952_p())).withBlockPosition(aoePos);
                                        Vec3d vec3d = new Vec3d(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).func_72432_b();
                                        Intrinsics.checkExpressionValueIsNotNull(vec3d, "Vec3d(\n                 \u2026            ).normalize()");
                                        effect.getComponent().procEffect(deliveryTransitionStateBuilder.withDirection(vec3d).build(), effect);
                                    }
                                    if (z == n4) break;
                                    ++z;
                                }
                            }
                            if (y == n3) break;
                            ++y;
                        }
                    }
                    if (x == n2) break;
                    ++x;
                }
            }
        }
    }

    @Override
    public void performDefaultTransition(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Spell spell = state.getSpell();
        int spellIndex = state.getStageIndex();
        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
        if (spellComponentInstance == null) {
            Intrinsics.throwNpe();
        }
        if (this.getTargetType(spellComponentInstance) == TargetType.ENTITY) {
            List entitiesWithinAABB;
            WorldServer worldServer = state.getWorld();
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB(new BlockPos(state.getPosition()));
            SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance2 = state.getCurrentStage().getDeliveryInstance();
            if (spellComponentInstance2 == null) {
                Intrinsics.throwNpe();
            }
            List list = entitiesWithinAABB = worldServer.func_72872_a(Entity.class, axisAlignedBB.func_186662_g(this.getRadius(spellComponentInstance2)));
            Intrinsics.checkExpressionValueIsNotNull(list, "entitiesWithinAABB");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity it = (Entity)element$iv;
                boolean bl = false;
                SpellStage spellStage = spell.getStage(spellIndex + 1);
                if (spellStage == null) {
                    Intrinsics.throwNpe();
                }
                SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance3 = spellStage.getDeliveryInstance();
                if (spellComponentInstance3 == null) {
                    Intrinsics.throwNpe();
                }
                DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = new DeliveryTransitionStateBuilder().withSpell(state.getSpell()).withStageIndex(spellIndex + 1).withCasterEntity(state.getCasterEntity());
                Entity entity = it;
                if (entity == null) {
                    Intrinsics.throwNpe();
                }
                spellComponentInstance3.getComponent().executeDelivery(deliveryTransitionStateBuilder.withEntity(entity).build());
            }
        } else {
            DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = new DeliveryTransitionStateBuilder().withSpell(state.getSpell()).withStageIndex(spellIndex + 1).withWorld((World)state.getWorld()).withBlockPosition(state.getBlockPosition()).withCasterEntity(state.getCasterEntity());
            List<Vec3d> $i$f$forEach = CollectionsKt.mutableListOf(new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(-1.0, 0.0, 0.0), new Vec3d(0.0, -1.0, 0.0), new Vec3d(0.0, 0.0, -1.0));
            boolean bl = false;
            boolean bl2 = false;
            List<Vec3d> $this$apply = $i$f$forEach;
            boolean bl3 = false;
            List<Vec3d> list = $this$apply;
            boolean bl4 = false;
            Collections.shuffle(list);
            List cardinalDirections = CollectionsKt.toList((Iterable)$i$f$forEach);
            Iterable $this$forEach$iv = cardinalDirections;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Vec3d it = (Vec3d)element$iv;
                boolean bl5 = false;
                SpellStage spellStage = spell.getStage(spellIndex + 1);
                if (spellStage == null) {
                    Intrinsics.throwNpe();
                }
                SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance4 = spellStage.getDeliveryInstance();
                if (spellComponentInstance4 == null) {
                    Intrinsics.throwNpe();
                }
                Vec3d vec3d = state.getPosition().func_178787_e(it.func_186678_a(0.2));
                Intrinsics.checkExpressionValueIsNotNull(vec3d, "state.position.add(it.scale(0.2))");
                spellComponentInstance4.getComponent().executeDelivery(deliveryTransitionStateBuilder.withPosition(vec3d).withDirection(it).build());
            }
        }
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return (double)10 + this.getRadius(instance) * this.getRadius(instance);
    }

    @Override
    public double getStageCostMultiplier(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return 3.0;
    }

    public final double getRadius(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return instance.getData().func_74769_h(NBT_RADIUS);
    }

    @NotNull
    public final TargetType getTargetType(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return TargetType.values()[instance.getData().func_74762_e(NBT_TARGET_TYPE)];
    }

    public SpellDeliveryMethodAOE() {
        super(new ResourceLocation("afraidofthedark", "aoe"));
        this.addEditableProperty(((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.doubleProperty().withName("Radius")).withDescription("The area of effect radius in blocks.")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(3.0)).withMinValue(1.0)).withMaxValue(150.0)).build());
        this.addEditableProperty(new SpellComponentProperty("Target Type", "Should be either 'entity' or 'block'. If the target type is 'block' all nearby blocks will be affected, if it is 'entity' all nearby entities will be affected.", 3.INSTANCE, new Function1<SpellComponentInstance<?>, String>(){

            @Override
            @NotNull
            public final String invoke(@NotNull SpellComponentInstance<?> it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return this.getTargetType(it) == TargetType.ENTITY ? "entity" : "block";
            }
        }, 5.INSTANCE));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/SpellDeliveryMethodAOE$Companion;", "", "()V", "NBT_RADIUS", "", "NBT_TARGET_TYPE", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

