/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.effect;

import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.IntSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockFire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0016\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/SpellEffectBurn;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/AOTDSpellEffect;", "()V", "getBurnDuration", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "getCost", "", "procEffect", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "Companion", "afraidofthedark"})
public final class SpellEffectBurn
extends AOTDSpellEffect {
    private static final String NBT_BURN_DURATION = "burn_duration";
    public static final Companion Companion = new Companion(null);

    @Override
    public void procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        if (state.getEntity() != null) {
            Entity entity;
            Entity entity2 = entity = state.getEntity();
            if (entity2 == null) {
                Intrinsics.throwNpe();
            }
            AOTDSpellEffect.Companion.createParticlesAt(3, 5, new Vec3d(entity2.field_70165_t, entity.field_70163_u, entity.field_70161_v), entity.field_71093_bK);
            entity.func_70015_d(this.getBurnDuration(instance));
        } else {
            World world = (World)state.getWorld();
            BlockPos position = state.getBlockPosition();
            IBlockState iBlockState = world.func_180495_p(position.func_177984_a());
            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(position.up())");
            if (iBlockState.func_177230_c() instanceof BlockAir) {
                IBlockState iBlockState2 = world.func_180495_p(position);
                Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "world.getBlockState(position)");
                if (!(iBlockState2.func_177230_c() instanceof BlockAir)) {
                    Vec3d vec3d = state.getPosition();
                    WorldProvider worldProvider = world.field_73011_w;
                    Intrinsics.checkExpressionValueIsNotNull(worldProvider, "world.provider");
                    AOTDSpellEffect.Companion.createParticlesAt(1, 3, vec3d, worldProvider.getDimension());
                    BlockPos blockPos = position.func_177984_a();
                    BlockFire blockFire = Blocks.field_150480_ab;
                    Intrinsics.checkExpressionValueIsNotNull(blockFire, "Blocks.FIRE");
                    world.func_175656_a(blockPos, blockFire.func_176223_P());
                }
            }
        }
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return 10.0 + (double)this.getBurnDuration(instance) * 5.0;
    }

    public final int getBurnDuration(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return instance.getData().func_74762_e(NBT_BURN_DURATION);
    }

    public SpellEffectBurn() {
        super(new ResourceLocation("afraidofthedark", "burn"));
        this.addEditableProperty(((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.intProperty().withName("Burn")).withDescription("The number of seconds to set fire to when hitting entities.")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(2)).withMinValue(1)).withMaxValue(60)).build());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/SpellEffectBurn$Companion;", "", "()V", "NBT_BURN_DURATION", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

