/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.effect;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.component.IAOTDPlayerSpellFreezeData;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.IntSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0014\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/SpellEffectFreeze;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/AOTDSpellEffect;", "()V", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "getFreezeDuration", "", "procEffect", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "Companion", "afraidofthedark"})
public final class SpellEffectFreeze
extends AOTDSpellEffect {
    private static final String NBT_FREEZE_DURATION = "freeze_duration";
    public static final Companion Companion = new Companion(null);

    @Override
    public void procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        World world = (World)state.getWorld();
        BlockPos blockPos = state.getBlockPosition();
        Entity entity = state.getEntity();
        if (entity != null) {
            if (entity instanceof EntityLivingBase) {
                if (entity instanceof EntityPlayer) {
                    IAOTDPlayerSpellFreezeData freezeData = CapabilityExtensionsKt.getSpellFreezeData((EntityPlayer)entity);
                    freezeData.setFreezeTicks(this.getFreezeDuration(instance));
                    freezeData.setFreezePosition(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
                    freezeData.setFreezeDirection(entity.field_70177_z, entity.field_70125_A);
                } else {
                    EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                    Potion potion = Potion.func_188412_a((int)2);
                    if (potion == null) {
                        Intrinsics.throwNpe();
                    }
                    entityLivingBase.func_70690_d(new PotionEffect(potion, this.getFreezeDuration(instance), 99));
                }
            }
        } else {
            IBlockState hitBlock;
            IBlockState iBlockState = hitBlock = world.func_180495_p(blockPos);
            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "hitBlock");
            if (Intrinsics.areEqual(iBlockState.func_177230_c(), Blocks.field_150355_j) || Intrinsics.areEqual(hitBlock.func_177230_c(), Blocks.field_150358_i)) {
                Block block = Blocks.field_150432_aD;
                Intrinsics.checkExpressionValueIsNotNull(block, "Blocks.ICE");
                world.func_175656_a(blockPos, block.func_176223_P());
            }
        }
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        int freezeDuration = this.getFreezeDuration(instance);
        return (double)26 + (double)(freezeDuration * freezeDuration) / 100.0;
    }

    public final int getFreezeDuration(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return instance.getData().func_74762_e(NBT_FREEZE_DURATION);
    }

    public SpellEffectFreeze() {
        super(new ResourceLocation("afraidofthedark", "freeze"));
        this.addEditableProperty(((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.intProperty().withName("Duration")).withDescription("The number of ticks the freeze will last against entities.")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(20)).withMinValue(1)).withMaxValue(1200)).build());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/SpellEffectFreeze$Companion;", "", "()V", "NBT_FREEZE_DURATION", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

