/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.effect;

import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.FloatSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.IntSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentProperty;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0014\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\f\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/SpellEffectPotionEffect;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/AOTDSpellEffect;", "()V", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "getPotionDuration", "", "getPotionRadius", "", "getPotionStrength", "getPotionType", "Lnet/minecraft/potion/Potion;", "procEffect", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "Companion", "afraidofthedark"})
public final class SpellEffectPotionEffect
extends AOTDSpellEffect {
    private static final String NBT_POTION_TYPE = "potion_type";
    private static final String NBT_POTION_STRENGTH = "potion_strength";
    private static final String NBT_POTION_DURATION = "potion_duration";
    private static final String NBT_POTION_RADIUS = "potion_radius";
    public static final Companion Companion = new Companion(null);

    @Override
    public void procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        Vec3d exactPosition = state.getPosition();
        Potion potionType = this.getPotionType(instance);
        int potionStrength = this.getPotionStrength(instance);
        int potionDuration = this.getPotionDuration(instance);
        Entity entityHit = state.getEntity();
        if (entityHit != null) {
            if (entityHit instanceof EntityLivingBase) {
                AOTDSpellEffect.Companion.createParticlesAt(1, 3, exactPosition, entityHit.field_71093_bK);
                ((EntityLivingBase)entityHit).func_70690_d(new PotionEffect(potionType, potionDuration, potionStrength));
            }
        } else {
            World world = (World)state.getWorld();
            EntityAreaEffectCloud aoePotion = new EntityAreaEffectCloud(world, exactPosition.field_72450_a, exactPosition.field_72448_b, exactPosition.field_72449_c);
            aoePotion.func_184496_a(new PotionEffect(potionType, potionDuration, potionStrength));
            Entity entity = state.getCasterEntity();
            if (!(entity instanceof EntityLivingBase)) {
                entity = null;
            }
            aoePotion.func_184481_a((EntityLivingBase)entity);
            aoePotion.func_184483_a(this.getPotionRadius(instance));
            aoePotion.func_184487_c(0.0f);
            aoePotion.func_184486_b(potionDuration);
            world.func_72838_d((Entity)aoePotion);
            WorldProvider worldProvider = world.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull(worldProvider, "world.provider");
            AOTDSpellEffect.Companion.createParticlesAt(4, 8, exactPosition, worldProvider.getDimension());
        }
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellEffect> instance) {
        float f;
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        float f2 = this.getPotionRadius(instance);
        double d = (double)this.getPotionDuration(instance) / 5.0 * (double)this.getPotionStrength(instance);
        double d2 = 15;
        boolean bl = false;
        f2 = f = (float)Math.sqrt(f2);
        float f3 = 1.0f;
        boolean bl2 = false;
        f = Math.max(f2, f3);
        return d2 + d * (double)f;
    }

    @NotNull
    public final Potion getPotionType(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        Potion potion = Potion.func_180142_b((String)instance.getData().func_74779_i(NBT_POTION_TYPE));
        if (potion == null) {
            Intrinsics.throwNpe();
        }
        return potion;
    }

    public final int getPotionStrength(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return instance.getData().func_74762_e(NBT_POTION_STRENGTH);
    }

    public final int getPotionDuration(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return instance.getData().func_74762_e(NBT_POTION_DURATION);
    }

    public final float getPotionRadius(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return instance.getData().func_74760_g(NBT_POTION_RADIUS);
    }

    public SpellEffectPotionEffect() {
        super(new ResourceLocation("afraidofthedark", "potion_effect"));
        this.addEditableProperty(new SpellComponentProperty("Potion Type", "The type of potion effect to apply. Must be using the minecraft naming convention, like 'minecraft:speed'.", 1.INSTANCE, 2.INSTANCE, 3.INSTANCE));
        this.addEditableProperty(((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.intProperty().withName("Potion Strength")).withDescription("The level of the potion to apply, ex. 4 means apply 'Potion Type' at level 4.")).withSetter(4.INSTANCE)).withGetter(5.INSTANCE)).withDefaultValue(1)).withMinValue(1)).build());
        this.addEditableProperty(((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.intProperty().withName("Potion Duration")).withDescription("The number of ticks the potion effect should run for.")).withSetter(6.INSTANCE)).withGetter(7.INSTANCE)).withDefaultValue(20)).withMinValue(1)).build());
        this.addEditableProperty(((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)((FloatSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.floatProperty().withName("Potion Cloud Radius")).withDescription("The size of the potion cloud if the potion is delivered to a block and not an entity.")).withSetter(8.INSTANCE)).withGetter(9.INSTANCE)).withDefaultValue(Float.valueOf(2.0f))).withMinValue(Float.valueOf(0.0f))).build());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/SpellEffectPotionEffect$Companion;", "", "()V", "NBT_POTION_DURATION", "", "NBT_POTION_RADIUS", "NBT_POTION_STRENGTH", "NBT_POTION_TYPE", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

