/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.utility;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001d\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010$\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010%\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010'\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010(\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\tJ\u001e\u0010*\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0011J\u001e\u0010+\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0005J\u001e\u0010,\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0015J\u001e\u0010-\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0018J\u001e\u0010.\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u001bJ\u001e\u0010/\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u001eJ\u001e\u00100\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020!J\u001e\u00101\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000e\u00a8\u00062"}, d2={"Lcom/davidm1a2/afraidofthedark/common/utility/NBTHelper;", "", "()V", "getAllSavedPlayerNBTs", "", "Lnet/minecraft/nbt/NBTTagCompound;", "minecraftServer", "Lnet/minecraft/server/MinecraftServer;", "saveFirst", "", "getBoolean", "itemStack", "Lnet/minecraft/item/ItemStack;", "keyName", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Boolean;", "getByte", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Byte;", "getCompound", "getDouble", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Double;", "getFloat", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Float;", "getInteger", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Integer;", "getLong", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Long;", "getShort", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Short;", "getString", "hasTag", "initNBTTagCompound", "", "removeTag", "setBoolean", "keyValue", "setByte", "setCompound", "setDouble", "setFloat", "setInteger", "setLong", "setShort", "setString", "afraidofthedark"})
public final class NBTHelper {
    public static final NBTHelper INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<NBTTagCompound> getAllSavedPlayerNBTs(@NotNull MinecraftServer minecraftServer, boolean saveFirst) {
        ISaveHandler saveHandler;
        Intrinsics.checkParameterIsNotNull(minecraftServer, "minecraftServer");
        if (saveFirst) {
            minecraftServer.func_184103_al().func_72389_g();
        }
        boolean bl = false;
        List toReturn = new ArrayList();
        WorldServer worldServer = minecraftServer.field_71305_c[0];
        Intrinsics.checkExpressionValueIsNotNull(worldServer, "minecraftServer.worlds[0]");
        ISaveHandler iSaveHandler = saveHandler = worldServer.func_72860_G();
        Intrinsics.checkExpressionValueIsNotNull(iSaveHandler, "saveHandler");
        File playerDataDirectory = new File(iSaveHandler.func_75765_b(), "playerdata");
        IPlayerFileData iPlayerFileData = saveHandler.func_75756_e();
        Intrinsics.checkExpressionValueIsNotNull(iPlayerFileData, "saveHandler.playerNBTManager");
        for (String playerUUID : iPlayerFileData.func_75754_f()) {
            File playerData = new File(playerDataDirectory, playerUUID + ".dat");
            if (!playerData.exists() || !playerData.isFile() || !playerData.canRead()) continue;
            try {
                Closeable closeable = new FileInputStream(playerData);
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    NBTTagCompound playerDataCompound;
                    FileInputStream it = (FileInputStream)closeable;
                    boolean bl3 = false;
                    NBTTagCompound nBTTagCompound = playerDataCompound = CompressedStreamTools.func_74796_a((InputStream)it);
                    Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "playerDataCompound");
                    boolean bl4 = toReturn.add(nBTTagCompound);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException e) {
                AfraidOfTheDark.Companion.getINSTANCE().getLogger().error("Could not read player data for file " + playerData.getAbsolutePath() + ", exception was:\n" + ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return toReturn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasTag(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        if (itemStack.func_77978_p() == null) return false;
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        if (!nBTTagCompound.func_74764_b(keyName)) return false;
        return true;
    }

    public final void removeTag(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound.func_82580_o(keyName);
        }
    }

    private final void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    public final void setLong(@NotNull ItemStack itemStack, @NotNull String keyName, long keyValue) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        nBTTagCompound.func_74772_a(keyName, keyValue);
    }

    @Nullable
    public final Long getLong(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Long l;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            l = nBTTagCompound.func_74763_f(keyName);
        } else {
            l = null;
        }
        return l;
    }

    public final void setString(@NotNull ItemStack itemStack, @NotNull String keyName, @NotNull String keyValue) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        Intrinsics.checkParameterIsNotNull(keyValue, "keyValue");
        this.initNBTTagCompound(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        nBTTagCompound.func_74778_a(keyName, keyValue);
    }

    @Nullable
    public final String getString(@NotNull ItemStack itemStack, @NotNull String keyName) {
        String string;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            string = nBTTagCompound.func_74779_i(keyName);
        } else {
            string = null;
        }
        return string;
    }

    public final void setBoolean(@NotNull ItemStack itemStack, @NotNull String keyName, boolean keyValue) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        nBTTagCompound.func_74757_a(keyName, keyValue);
    }

    @Nullable
    public final Boolean getBoolean(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            bl = nBTTagCompound.func_74767_n(keyName);
        } else {
            bl = null;
        }
        return bl;
    }

    public final void setByte(@NotNull ItemStack itemStack, @NotNull String keyName, byte keyValue) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        nBTTagCompound.func_74774_a(keyName, keyValue);
    }

    @Nullable
    public final Byte getByte(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Byte by;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            by = nBTTagCompound.func_74771_c(keyName);
        } else {
            by = null;
        }
        return by;
    }

    public final void setShort(@NotNull ItemStack itemStack, @NotNull String keyName, short keyValue) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        nBTTagCompound.func_74777_a(keyName, keyValue);
    }

    @Nullable
    public final Short getShort(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Short s;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            s = nBTTagCompound.func_74765_d(keyName);
        } else {
            s = null;
        }
        return s;
    }

    public final void setInteger(@NotNull ItemStack itemStack, @NotNull String keyName, int keyValue) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        nBTTagCompound.func_74768_a(keyName, keyValue);
    }

    @Nullable
    public final Integer getInteger(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Integer n;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            n = nBTTagCompound.func_74762_e(keyName);
        } else {
            n = null;
        }
        return n;
    }

    public final void setFloat(@NotNull ItemStack itemStack, @NotNull String keyName, float keyValue) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        nBTTagCompound.func_74776_a(keyName, keyValue);
    }

    @Nullable
    public final Float getFloat(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Float f;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            f = Float.valueOf(nBTTagCompound.func_74760_g(keyName));
        } else {
            f = null;
        }
        return f;
    }

    public final void setDouble(@NotNull ItemStack itemStack, @NotNull String keyName, double keyValue) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        nBTTagCompound.func_74780_a(keyName, keyValue);
    }

    @Nullable
    public final Double getDouble(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Double d;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            d = nBTTagCompound.func_74769_h(keyName);
        } else {
            d = null;
        }
        return d;
    }

    public final void setCompound(@NotNull ItemStack itemStack, @NotNull String keyName, @NotNull NBTTagCompound keyValue) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        Intrinsics.checkParameterIsNotNull(keyValue, "keyValue");
        this.initNBTTagCompound(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        nBTTagCompound.func_74782_a(keyName, (NBTBase)keyValue);
    }

    @Nullable
    public final NBTTagCompound getCompound(@NotNull ItemStack itemStack, @NotNull String keyName) {
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            NBTTagCompound nBTTagCompound2 = itemStack.func_77978_p();
            if (nBTTagCompound2 == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound = nBTTagCompound2.func_74775_l(keyName);
        } else {
            nBTTagCompound = null;
        }
        return nBTTagCompound;
    }

    private NBTHelper() {
    }

    static {
        NBTHelper nBTHelper;
        INSTANCE = nBTHelper = new NBTHelper();
    }
}

