/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration;

import com.davidm1a2.afraidofthedark.common.capabilities.world.IStructurePlan;
import com.davidm1a2.afraidofthedark.common.capabilities.world.PlacedStructure;
import com.davidm1a2.afraidofthedark.common.capabilities.world.StructurePlan;
import com.davidm1a2.afraidofthedark.common.worldGeneration.WorldExtensionsKt;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.Structure;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J8\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0019H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/AOTDWorldGenerator;", "Lnet/minecraftforge/fml/common/IWorldGenerator;", "()V", "chunksThatNeedGeneration", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lnet/minecraft/util/math/ChunkPos;", "addChunkToRegenerate", "", "chunkPos", "generate", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "onServerTick", "event", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ServerTickEvent;", "onWorldSave", "Lnet/minecraftforge/event/world/WorldEvent$Save;", "afraidofthedark"})
public final class AOTDWorldGenerator
implements IWorldGenerator {
    private final ConcurrentLinkedQueue<ChunkPos> chunksThatNeedGeneration = new ConcurrentLinkedQueue();

    public final void addChunkToRegenerate(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        this.chunksThatNeedGeneration.add(chunkPos);
    }

    public void generate(@NotNull Random random, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkParameterIsNotNull(random, "random");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(chunkGenerator, "chunkGenerator");
        Intrinsics.checkParameterIsNotNull(chunkProvider, "chunkProvider");
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        this.generate(world, chunkPos);
    }

    @SubscribeEvent
    public final void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (event.phase == TickEvent.Phase.START) {
            Collection collection = this.chunksThatNeedGeneration;
            boolean bl = false;
            if (!collection.isEmpty()) {
                ChunkPos chunkToGenerate = (ChunkPos)this.chunksThatNeedGeneration.remove();
                WorldServer worldServer = DimensionManager.getWorld((int)0);
                if (worldServer == null) {
                    Intrinsics.throwNpe();
                }
                WorldServer world = worldServer;
                World world2 = (World)world;
                ChunkPos chunkPos = chunkToGenerate;
                Intrinsics.checkExpressionValueIsNotNull(chunkPos, "chunkToGenerate");
                this.generate(world2, chunkPos);
            }
        }
    }

    @SubscribeEvent
    public final void onWorldSave(@NotNull WorldEvent.Save event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!event.getWorld().field_72995_K) {
            WorldProvider worldProvider = event.getWorld().field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull(worldProvider, "event.world.provider");
            if (worldProvider.getDimension() == 0 && !this.chunksThatNeedGeneration.isEmpty()) {
                World world = event.getWorld();
                Intrinsics.checkExpressionValueIsNotNull(world, "event.world");
                MinecraftServer minecraftServer = world.func_73046_m();
                if (minecraftServer == null) {
                    Intrinsics.throwNpe();
                }
                minecraftServer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:world_gen.saving", new Object[]{this.chunksThatNeedGeneration.size()}));
                while (!this.chunksThatNeedGeneration.isEmpty()) {
                    ChunkPos chunkToGenerate = (ChunkPos)this.chunksThatNeedGeneration.remove();
                    World world2 = event.getWorld();
                    Intrinsics.checkExpressionValueIsNotNull(world2, "event.world");
                    ChunkPos chunkPos = chunkToGenerate;
                    Intrinsics.checkExpressionValueIsNotNull(chunkPos, "chunkToGenerate");
                    this.generate(world2, chunkPos);
                }
            }
        }
    }

    private final void generate(World world, ChunkPos chunkPos) {
        IStructurePlan structurePlan = StructurePlan.Companion.get(world);
        if (structurePlan != null && structurePlan.structureExistsAt(chunkPos)) {
            PlacedStructure placedStructure = structurePlan.getPlacedStructureAt(chunkPos);
            if (placedStructure == null) {
                Intrinsics.throwNpe();
            }
            PlacedStructure placedStructure2 = placedStructure;
            Structure structure = placedStructure2.getStructure();
            NBTTagCompound data = placedStructure2.getData();
            structure.generate(world, chunkPos, data);
            WorldExtensionsKt.relightChunk(world, chunkPos);
        }
    }
}

