/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.world.IHeightmap;
import com.davidm1a2.afraidofthedark.common.capabilities.world.IStructurePlan;
import com.davidm1a2.afraidofthedark.common.capabilities.world.OverworldHeightmap;
import com.davidm1a2.afraidofthedark.common.capabilities.world.StructurePlan;
import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.worldGeneration.AOTDWorldGenerator;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.Structure;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J \u0010\u0012\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/WorldStructurePlanner;", "", "()V", "random", "Ljava/util/Random;", "registeredStructures", "", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/Structure;", "generateExistingChunks", "", "structure", "world", "Lnet/minecraft/world/World;", "posToGenerate", "Lnet/minecraft/util/math/BlockPos;", "onChunkPopulated", "event", "Lnet/minecraftforge/event/terraingen/PopulateChunkEvent$Pre;", "planStructuresInChunk", "chunkX", "", "chunkZ", "afraidofthedark"})
public final class WorldStructurePlanner {
    private List<Structure> registeredStructures;
    private Random random;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onChunkPopulated(@NotNull PopulateChunkEvent.Pre event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        World world = event.getWorld();
        int chunkX = event.getChunkX();
        int chunkZ = event.getChunkZ();
        if (this.registeredStructures == null) {
            Collection collection = ModRegistries.INSTANCE.getSTRUCTURE().getValuesCollection();
            Intrinsics.checkExpressionValueIsNotNull(collection, "ModRegistries.STRUCTURE.valuesCollection");
            this.registeredStructures = CollectionsKt.toMutableList(collection);
        }
        if (this.random == null) {
            World world2 = world;
            Intrinsics.checkExpressionValueIsNotNull(world2, "world");
            this.random = new Random(world2.func_72905_C());
        }
        World world3 = world;
        Intrinsics.checkExpressionValueIsNotNull(world3, "world");
        this.planStructuresInChunk(world3, chunkX, chunkZ);
    }

    private final void planStructuresInChunk(World world, int chunkX, int chunkZ) {
        if (!world.field_72995_K) {
            WorldProvider worldProvider = world.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull(worldProvider, "world.provider");
            if (worldProvider.getDimension() == 0) {
                IStructurePlan structurePlan = StructurePlan.Companion.get(world);
                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                IStructurePlan iStructurePlan = structurePlan;
                if (iStructurePlan == null) {
                    Intrinsics.throwNpe();
                }
                if (!iStructurePlan.structureExistsAt(chunkPos)) {
                    List<Structure> list = this.registeredStructures;
                    if (list == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("registeredStructures");
                    }
                    List<Structure> list2 = list;
                    Random random = this.random;
                    if (random == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("random");
                    }
                    Random random2 = random;
                    boolean bl = false;
                    Collections.shuffle(list2, random2);
                    IHeightmap heightmap = OverworldHeightmap.Companion.get(world);
                    BiomeProvider biomeProvider = world.func_72959_q();
                    BlockPos chunk0Corner = chunkPos.func_180331_a(0, 63, 0);
                    BlockPos[] positions = new BlockPos[8];
                    List<Structure> list3 = this.registeredStructures;
                    if (list3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("registeredStructures");
                    }
                    for (Structure structure : list3) {
                        BlockPos bottomRight;
                        BlockPos bottomLeft;
                        BlockPos topLeft;
                        BlockPos topRight;
                        positions[0] = topRight = chunk0Corner.func_177982_a(15, 0, 15);
                        Random random3 = this.random;
                        if (random3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("random");
                        }
                        int n = -random3.nextInt(16);
                        Random random4 = this.random;
                        if (random4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("random");
                        }
                        positions[1] = topRight.func_177982_a(n, 0, -random4.nextInt(16));
                        positions[2] = topLeft = chunk0Corner.func_177982_a(0 - structure.getXWidth() + 1, 0, 15);
                        Random random5 = this.random;
                        if (random5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("random");
                        }
                        int n2 = random5.nextInt(16);
                        Random random6 = this.random;
                        if (random6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("random");
                        }
                        positions[3] = topLeft.func_177982_a(n2, 0, -random6.nextInt(16));
                        positions[4] = bottomLeft = chunk0Corner.func_177982_a(0 - structure.getXWidth() + 1, 0, 0 - structure.getZLength() + 1);
                        Random random7 = this.random;
                        if (random7 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("random");
                        }
                        int n3 = random7.nextInt(16);
                        Random random8 = this.random;
                        if (random8 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("random");
                        }
                        positions[5] = bottomLeft.func_177982_a(n3, 0, random8.nextInt(16));
                        positions[6] = bottomRight = chunk0Corner.func_177982_a(15, 0, 0 - structure.getZLength() + 1);
                        Random random9 = this.random;
                        if (random9 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("random");
                        }
                        int n4 = -random9.nextInt(16);
                        Random random10 = this.random;
                        if (random10 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("random");
                        }
                        positions[7] = bottomRight.func_177982_a(n4, 0, random10.nextInt(16));
                        for (int i = 0; i < positions.length; i += 2) {
                            BlockPos posToGenerate;
                            BlockPos possiblePos;
                            BlockPos blockPos = possiblePos = positions[i];
                            if (blockPos == null) {
                                Intrinsics.throwNpe();
                            }
                            if (!structurePlan.structureFitsAt(structure, blockPos)) continue;
                            BiomeProvider biomeProvider2 = biomeProvider;
                            Intrinsics.checkExpressionValueIsNotNull(biomeProvider2, "biomeProvider");
                            double percentChance = structure.computeChanceToGenerateAt(possiblePos, heightmap, biomeProvider2);
                            Random random11 = this.random;
                            if (random11 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("random");
                            }
                            if (!(random11.nextDouble() < percentChance)) continue;
                            BlockPos blockPos2 = posToGenerate = positions[i + 1];
                            if (blockPos2 == null) {
                                Intrinsics.throwNpe();
                            }
                            structurePlan.placeStructure(structure, structure.generateStructureData(world, blockPos2, biomeProvider));
                            this.generateExistingChunks(structure, world, posToGenerate);
                            return;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateExistingChunks(Structure structure, World world, BlockPos posToGenerate) {
        AOTDWorldGenerator worldGenerator = AfraidOfTheDark.Companion.getINSTANCE().getWorldGenerator();
        ChunkPos bottomLeftCorner = new ChunkPos(posToGenerate);
        ChunkPos topRightCorner = new ChunkPos(posToGenerate.func_177982_a(structure.getXWidth(), 0, structure.getZLength()));
        int n = bottomLeftCorner.field_77276_a;
        int n2 = topRightCorner.field_77276_a;
        if (n <= n2) {
            while (true) {
                void chunkX;
                int n3;
                int n4;
                if ((n4 = bottomLeftCorner.field_77275_b) <= (n3 = topRightCorner.field_77275_b)) {
                    while (true) {
                        void chunkZ;
                        if (world.func_190526_b((int)chunkX, (int)chunkZ)) {
                            worldGenerator.addChunkToRegenerate(new ChunkPos((int)chunkX, (int)chunkZ));
                        }
                        if (chunkZ == n3) break;
                        ++chunkZ;
                    }
                }
                if (chunkX == n2) break;
                ++chunkX;
            }
        }
    }

    public static final /* synthetic */ List access$getRegisteredStructures$p(WorldStructurePlanner $this) {
        List<Structure> list = $this.registeredStructures;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("registeredStructures");
        }
        return list;
    }

    public static final /* synthetic */ void access$setRegisteredStructures$p(WorldStructurePlanner $this, List list) {
        $this.registeredStructures = list;
    }

    public static final /* synthetic */ Random access$getRandom$p(WorldStructurePlanner $this) {
        Random random = $this.random;
        if (random == null) {
            Intrinsics.throwUninitializedPropertyAccessException("random");
        }
        return random;
    }

    public static final /* synthetic */ void access$setRandom$p(WorldStructurePlanner $this, Random random) {
        $this.random = random;
    }
}

