/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration.structure;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.world.IHeightmap;
import com.davidm1a2.afraidofthedark.common.capabilities.world.OverworldHeightmap;
import com.davidm1a2.afraidofthedark.common.constants.ModBiomes;
import com.davidm1a2.afraidofthedark.common.constants.ModLootTables;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.SchematicGenerator;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.StructureCrypt;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.AOTDStructure;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.iterator.InteriorChunkIterator;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.processor.IChunkProcessor;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/StructureCrypt;", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/AOTDStructure;", "()V", "computeChanceToGenerateAt", "", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "heightmap", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IHeightmap;", "biomeProvider", "Lnet/minecraft/world/biome/BiomeProvider;", "generate", "", "world", "Lnet/minecraft/world/World;", "chunkPos", "Lnet/minecraft/util/math/ChunkPos;", "data", "Lnet/minecraft/nbt/NBTTagCompound;", "generateStructureData", "getXWidth", "", "getZLength", "Companion", "afraidofthedark"})
public final class StructureCrypt
extends AOTDStructure {
    private static final Set<Biome> INCOMPATIBLE_BIOMES;
    public static final Companion Companion;

    @Override
    public double computeChanceToGenerateAt(@NotNull BlockPos blockPos, @NotNull IHeightmap heightmap, @NotNull BiomeProvider biomeProvider) {
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        Intrinsics.checkParameterIsNotNull(heightmap, "heightmap");
        Intrinsics.checkParameterIsNotNull(biomeProvider, "biomeProvider");
        return ((Number)this.processChunks(new IChunkProcessor<Double>(this, biomeProvider, heightmap){
            private int minHeight;
            private int maxHeight;
            private int numEerieForestChunks;
            private int numOtherChunks;
            final /* synthetic */ StructureCrypt this$0;
            final /* synthetic */ BiomeProvider $biomeProvider;
            final /* synthetic */ IHeightmap $heightmap;

            public final int getMinHeight() {
                return this.minHeight;
            }

            public final void setMinHeight(int n) {
                this.minHeight = n;
            }

            public final int getMaxHeight() {
                return this.maxHeight;
            }

            public final void setMaxHeight(int n) {
                this.maxHeight = n;
            }

            public final int getNumEerieForestChunks() {
                return this.numEerieForestChunks;
            }

            public final void setNumEerieForestChunks(int n) {
                this.numEerieForestChunks = n;
            }

            public final int getNumOtherChunks() {
                return this.numOtherChunks;
            }

            public final void setNumOtherChunks(int n) {
                this.numOtherChunks = n;
            }

            public boolean processChunk(@NotNull ChunkPos chunkPos) {
                int n;
                int n2;
                boolean bl;
                Set biomes;
                block6: {
                    Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
                    biomes = StructureCrypt.access$getBiomesInChunk(this.this$0, this.$biomeProvider, chunkPos.field_77276_a, chunkPos.field_77275_b);
                    Iterable $this$any$iv = biomes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Biome it = (Biome)element$iv;
                            boolean bl2 = false;
                            if (!StructureCrypt.access$getINCOMPATIBLE_BIOMES$cp().contains(it)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return false;
                }
                if (biomes.contains((Object)((Object)ModBiomes.INSTANCE.getEERIE_FOREST()))) {
                    n2 = this.numEerieForestChunks;
                    this.numEerieForestChunks = n2 + 1;
                } else {
                    n2 = this.numOtherChunks;
                    this.numOtherChunks = n2 + 1;
                }
                n2 = this.minHeight;
                int n3 = this.$heightmap.getLowestHeight(chunkPos);
                computeChanceToGenerateAt.1 var9_11 = this;
                boolean bl3 = false;
                var9_11.minHeight = n = Math.min(n2, n3);
                n2 = this.maxHeight;
                n3 = this.$heightmap.getHighestHeight(chunkPos);
                var9_11 = this;
                bl3 = false;
                var9_11.maxHeight = n = Math.max(n2, n3);
                return true;
            }

            @NotNull
            public Double getResult() {
                if (this.maxHeight - this.minHeight > 5) {
                    return this.getDefaultResult();
                }
                double percentEerie = (double)this.numEerieForestChunks / (double)(this.numEerieForestChunks + this.numOtherChunks);
                double percentOther = 1.0 - percentEerie;
                return (percentEerie * 0.02 + percentOther * 0.002) * (double)AfraidOfTheDark.Companion.getINSTANCE().getConfigurationHandler().getCryptMultiplier();
            }

            @NotNull
            public Double getDefaultResult() {
                return 0.0;
            }
            {
                this.this$0 = $outer;
                this.$biomeProvider = $captured_local_variable$1;
                this.$heightmap = $captured_local_variable$2;
                this.minHeight = Integer.MAX_VALUE;
                this.maxHeight = Integer.MIN_VALUE;
            }
        }, new InteriorChunkIterator(this, blockPos))).doubleValue();
    }

    @Override
    public void generate(@NotNull World world, @NotNull ChunkPos chunkPos, @NotNull NBTTagCompound data) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        Intrinsics.checkParameterIsNotNull(data, "data");
        BlockPos blockPos = this.getPosition(data);
        SchematicGenerator.INSTANCE.generateSchematic(ModSchematics.INSTANCE.getCRYPT(), world, blockPos, chunkPos, ModLootTables.INSTANCE.getCRYPT());
    }

    @Override
    @NotNull
    public NBTTagCompound generateStructureData(@NotNull World world, @NotNull BlockPos blockPos, @NotNull BiomeProvider biomeProvider) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        Intrinsics.checkParameterIsNotNull(biomeProvider, "biomeProvider");
        BlockPos blockPos2 = blockPos;
        NBTTagCompound compound = new NBTTagCompound();
        BlockPos centerBlock = blockPos2.func_177982_a(this.getXWidth() / 2, 0, this.getZLength() / 2);
        ChunkPos centerChunk = new ChunkPos(centerBlock);
        int groundHeight = OverworldHeightmap.Companion.get(world).getLowestHeight(centerChunk);
        int y = RangesKt.coerceIn(groundHeight - ModSchematics.INSTANCE.getCRYPT().getHeight() + 3, 5, Integer.MAX_VALUE);
        blockPos2 = new BlockPos(blockPos2.func_177958_n(), y, blockPos2.func_177952_p());
        compound.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)blockPos2));
        return compound;
    }

    @Override
    public int getXWidth() {
        return ModSchematics.INSTANCE.getCRYPT().getWidth();
    }

    @Override
    public int getZLength() {
        return ModSchematics.INSTANCE.getCRYPT().getLength();
    }

    public StructureCrypt() {
        super("crypt");
    }

    static {
        Companion = new Companion(null);
        INCOMPATIBLE_BIOMES = SetsKt.setOf(Biomes.field_76771_b, Biomes.field_150575_M, Biomes.field_76776_l, Biomes.field_76787_r, Biomes.field_76777_m, Biomes.field_76781_i, Biomes.field_76779_k, Biomes.field_185440_P, Biomes.field_150576_N);
    }

    public static final /* synthetic */ Set access$getBiomesInChunk(StructureCrypt $this, BiomeProvider biomeProvider, int chunkX, int chunkZ) {
        return $this.getBiomesInChunk(biomeProvider, chunkX, chunkZ);
    }

    public static final /* synthetic */ Set access$getINCOMPATIBLE_BIOMES$cp() {
        return INCOMPATIBLE_BIOMES;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/StructureCrypt$Companion;", "", "()V", "INCOMPATIBLE_BIOMES", "", "Lnet/minecraft/world/biome/Biome;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

