/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration.structure;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.world.IHeightmap;
import com.davidm1a2.afraidofthedark.common.capabilities.world.OverworldHeightmap;
import com.davidm1a2.afraidofthedark.common.constants.ModBiomes;
import com.davidm1a2.afraidofthedark.common.constants.ModLootTables;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.Schematic;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.SchematicGenerator;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.StructureDarkForest;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.StructureDarkForest$WhenMappings;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.AOTDStructure;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.iterator.IChunkIterator;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.processor.IChunkProcessor;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.processor.LowestHeightChunkProcessor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J<\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0014H\u0002J(\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0017H\u0002J\b\u0010'\u001a\u00020\u0004H\u0016J\b\u0010(\u001a\u00020\u0004H\u0016J \u0010)\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/StructureDarkForest;", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/AOTDStructure;", "()V", "bedHouseLength", "", "bedHouseWidth", "height", "width", "addRandomProps", "", "data", "Lnet/minecraft/nbt/NBTTagCompound;", "heightmap", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IHeightmap;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "biomeProvider", "Lnet/minecraft/world/biome/BiomeProvider;", "gutters", "", "Ljava/awt/Rectangle;", "addRandomTrees", "bedHouseSides", "Lnet/minecraft/util/EnumFacing;", "computeChanceToGenerateAt", "", "generate", "world", "Lnet/minecraft/world/World;", "chunkPos", "Lnet/minecraft/util/math/ChunkPos;", "generateStructureData", "getRandomPropPosition", "prop", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/schematic/Schematic;", "gutter", "getRandomTreePosition", "tree", "bedHouseSide", "getXWidth", "getZLength", "setBedHousePosition", "Companion", "afraidofthedark"})
public final class StructureDarkForest
extends AOTDStructure {
    private final int width;
    private final int bedHouseWidth;
    private final int height;
    private final int bedHouseLength;
    private static final Set<Biome> INCOMPATIBLE_BIOMES;
    private static final Set<Biome> COMPATIBLE_HOUSE_BIOMES;
    private static final String NBT_TREES = "trees";
    private static final String NBT_PROPS = "props";
    private static final String NBT_HOUSE_POSITION = "house";
    private static final String NBT_SCHEMATIC_ID = "schematic_id";
    public static final Companion Companion;

    @Override
    public double computeChanceToGenerateAt(@NotNull BlockPos blockPos, @NotNull IHeightmap heightmap, @NotNull BiomeProvider biomeProvider) {
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        Intrinsics.checkParameterIsNotNull(heightmap, "heightmap");
        Intrinsics.checkParameterIsNotNull(biomeProvider, "biomeProvider");
        BlockPos houseCorner1BlockPos = blockPos.func_177982_a(this.getXWidth() / 2 - this.bedHouseWidth / 2, 0, this.getZLength() / 2 - this.bedHouseLength / 2);
        BlockPos houseCorner2BlockPos = houseCorner1BlockPos.func_177982_a(this.bedHouseWidth, 0, this.bedHouseLength);
        ChunkPos houseCorner1ChunkPos = new ChunkPos(houseCorner1BlockPos);
        ChunkPos houseCorner2ChunkPos = new ChunkPos(houseCorner2BlockPos);
        boolean houseValid2 = (Boolean)this.processChunks(new IChunkProcessor<Boolean>(this, biomeProvider, heightmap){
            private int minHeight;
            private int maxHeight;
            final /* synthetic */ StructureDarkForest this$0;
            final /* synthetic */ BiomeProvider $biomeProvider;
            final /* synthetic */ IHeightmap $heightmap;

            public final int getMinHeight() {
                return this.minHeight;
            }

            public final void setMinHeight(int n) {
                this.minHeight = n;
            }

            public final int getMaxHeight() {
                return this.maxHeight;
            }

            public final void setMaxHeight(int n) {
                this.maxHeight = n;
            }

            public boolean processChunk(@NotNull ChunkPos chunkPos) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
                Set biomes = StructureDarkForest.access$getBiomesInChunk(this.this$0, this.$biomeProvider, chunkPos.field_77276_a, chunkPos.field_77275_b);
                if (StructureDarkForest.access$getCOMPATIBLE_HOUSE_BIOMES$cp().containsAll(biomes)) {
                    int n;
                    int n2 = this.minHeight;
                    int n3 = this.$heightmap.getLowestHeight(chunkPos);
                    computeChanceToGenerateAt.houseValid.1 var6_5 = this;
                    boolean bl2 = false;
                    var6_5.minHeight = n = Math.min(n2, n3);
                    n2 = this.maxHeight;
                    n3 = this.$heightmap.getHighestHeight(chunkPos);
                    var6_5 = this;
                    bl2 = false;
                    var6_5.maxHeight = n = Math.max(n2, n3);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            @NotNull
            public Boolean getResult() {
                return this.maxHeight - this.minHeight < 8;
            }

            @NotNull
            public Boolean getDefaultResult() {
                return false;
            }
            {
                this.this$0 = $outer;
                this.$biomeProvider = $captured_local_variable$1;
                this.$heightmap = $captured_local_variable$2;
                this.minHeight = Integer.MAX_VALUE;
                this.maxHeight = Integer.MIN_VALUE;
            }
        }, new IChunkIterator(houseCorner1ChunkPos, houseCorner2ChunkPos){
            final /* synthetic */ ChunkPos $houseCorner1ChunkPos;
            final /* synthetic */ ChunkPos $houseCorner2ChunkPos;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<ChunkPos> getChunks() {
                int n = 0;
                List houseChunks = new ArrayList<E>();
                n = this.$houseCorner1ChunkPos.field_77276_a;
                int n2 = this.$houseCorner2ChunkPos.field_77276_a;
                if (n <= n2) {
                    while (true) {
                        void chunkX;
                        int n3;
                        int n4;
                        if ((n4 = this.$houseCorner1ChunkPos.field_77275_b) <= (n3 = this.$houseCorner2ChunkPos.field_77275_b)) {
                            while (true) {
                                void chunkZ;
                                houseChunks.add(new ChunkPos((int)chunkX, (int)chunkZ));
                                if (chunkZ == n3) break;
                                ++chunkZ;
                            }
                        }
                        if (chunkX == n2) break;
                        ++chunkX;
                    }
                }
                return houseChunks;
            }
            {
                this.$houseCorner1ChunkPos = $captured_local_variable$0;
                this.$houseCorner2ChunkPos = $captured_local_variable$1;
            }
        });
        return !houseValid2 ? 0.0 : 0.002 * (double)AfraidOfTheDark.Companion.getINSTANCE().getConfigurationHandler().getDarkForestMultiplier();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(@NotNull World world, @NotNull ChunkPos chunkPos, @NotNull NBTTagCompound data) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        Intrinsics.checkParameterIsNotNull(data, "data");
        NBTTagList props = data.func_150295_c(NBT_PROPS, 10);
        int n = 0;
        int n2 = props.func_74745_c();
        while (n < n2) {
            BlockPos schematicPos;
            void i;
            NBTTagCompound schematicNBT = props.func_150305_b((int)i);
            int schematicId = schematicNBT.func_74762_e(NBT_SCHEMATIC_ID);
            Schematic schematic = ModSchematics.INSTANCE.getDARK_FOREST_PROPS()[schematicId];
            BlockPos blockPos = schematicPos = NBTUtil.func_186861_c((NBTTagCompound)schematicNBT.func_74775_l("position"));
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "schematicPos");
            SchematicGenerator.generateSchematic$default(SchematicGenerator.INSTANCE, schematic, world, blockPos, chunkPos, null, 16, null);
            ++i;
        }
        NBTTagList trees = data.func_150295_c(NBT_TREES, 10);
        n2 = 0;
        int n3 = trees.func_74745_c();
        while (n2 < n3) {
            BlockPos schematicPos;
            void i;
            NBTTagCompound schematicNBT = trees.func_150305_b((int)i);
            int schematicId = schematicNBT.func_74762_e(NBT_SCHEMATIC_ID);
            Schematic schematic = ModSchematics.INSTANCE.getDARK_FOREST_TREES()[schematicId];
            BlockPos blockPos = schematicPos = NBTUtil.func_186861_c((NBTTagCompound)schematicNBT.func_74775_l("position"));
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "schematicPos");
            SchematicGenerator.generateSchematic$default(SchematicGenerator.INSTANCE, schematic, world, blockPos, chunkPos, null, 16, null);
            ++i;
        }
        BlockPos housePos = NBTUtil.func_186861_c((NBTTagCompound)data.func_74775_l(NBT_HOUSE_POSITION));
        Schematic schematic = ModSchematics.INSTANCE.getBED_HOUSE();
        BlockPos blockPos = housePos;
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "housePos");
        SchematicGenerator.INSTANCE.generateSchematic(schematic, world, blockPos, chunkPos, ModLootTables.INSTANCE.getDARK_FOREST());
    }

    @Override
    @NotNull
    public NBTTagCompound generateStructureData(@NotNull World world, @NotNull BlockPos blockPos, @NotNull BiomeProvider biomeProvider) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        Intrinsics.checkParameterIsNotNull(biomeProvider, "biomeProvider");
        Rectangle leftGutter = new Rectangle(0, 0, (this.getXWidth() - this.bedHouseWidth) / 2, this.getZLength());
        Rectangle rightGutter = new Rectangle(this.bedHouseWidth + leftGutter.width, 0, leftGutter.width, this.getZLength());
        Rectangle bottomGutter = new Rectangle(0, 0, this.getXWidth(), (this.getZLength() - this.bedHouseLength) / 2);
        Rectangle topGutter = new Rectangle(0, this.bedHouseLength + bottomGutter.height, this.getXWidth(), (this.getZLength() - this.bedHouseLength) / 2);
        List<Rectangle> gutters = CollectionsKt.listOf(leftGutter, rightGutter, bottomGutter, topGutter);
        List<EnumFacing> bedHouseSides = CollectionsKt.listOf(EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH);
        IHeightmap heightmap = OverworldHeightmap.Companion.get(world);
        NBTTagCompound data = new NBTTagCompound();
        this.addRandomProps(data, heightmap, blockPos, biomeProvider, gutters);
        this.addRandomTrees(data, heightmap, blockPos, gutters, bedHouseSides);
        this.setBedHousePosition(data, heightmap, blockPos);
        BlockPos blockPos2 = NBTUtil.func_186861_c((NBTTagCompound)data.func_74775_l(NBT_HOUSE_POSITION));
        Intrinsics.checkExpressionValueIsNotNull(blockPos2, "NBTUtil.getPosFromTag(da\u2026dTag(NBT_HOUSE_POSITION))");
        int houseY = blockPos2.func_177956_o();
        data.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)new BlockPos(blockPos.func_177958_n(), houseY, blockPos.func_177952_p())));
        return data;
    }

    private final void setBedHousePosition(NBTTagCompound data, IHeightmap heightmap, BlockPos blockPos) {
        BlockPos houseCorner1BlockPos = blockPos.func_177982_a(this.getXWidth() / 2 - this.bedHouseWidth / 2, 0, this.getZLength() / 2 - this.bedHouseLength / 2);
        BlockPos houseCorner2BlockPos = houseCorner1BlockPos.func_177982_a(this.bedHouseWidth, 0, this.bedHouseLength);
        ChunkPos houseCorner1ChunkPos = new ChunkPos(houseCorner1BlockPos);
        ChunkPos houseCorner2ChunkPos = new ChunkPos(houseCorner2BlockPos);
        int minGroundHeight2 = ((Number)this.processChunks(new LowestHeightChunkProcessor(heightmap), new IChunkIterator(houseCorner1ChunkPos, houseCorner2ChunkPos){
            final /* synthetic */ ChunkPos $houseCorner1ChunkPos;
            final /* synthetic */ ChunkPos $houseCorner2ChunkPos;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<ChunkPos> getChunks() {
                int n = 0;
                List houseChunks = new ArrayList<E>();
                n = this.$houseCorner1ChunkPos.field_77276_a;
                int n2 = this.$houseCorner2ChunkPos.field_77276_a;
                if (n <= n2) {
                    while (true) {
                        void chunkX;
                        int n3;
                        int n4;
                        if ((n4 = this.$houseCorner1ChunkPos.field_77275_b) <= (n3 = this.$houseCorner2ChunkPos.field_77275_b)) {
                            while (true) {
                                void chunkZ;
                                houseChunks.add(new ChunkPos((int)chunkX, (int)chunkZ));
                                if (chunkZ == n3) break;
                                ++chunkZ;
                            }
                        }
                        if (chunkX == n2) break;
                        ++chunkX;
                    }
                }
                return houseChunks;
            }
            {
                this.$houseCorner1ChunkPos = $captured_local_variable$0;
                this.$houseCorner2ChunkPos = $captured_local_variable$1;
            }
        })).intValue();
        BlockPos blockPos2 = houseCorner1BlockPos;
        Intrinsics.checkExpressionValueIsNotNull(blockPos2, "houseCorner1BlockPos");
        BlockPos housePos = new BlockPos(blockPos2.func_177958_n(), minGroundHeight2, houseCorner1BlockPos.func_177952_p());
        data.func_74782_a(NBT_HOUSE_POSITION, (NBTBase)NBTUtil.func_186859_a((BlockPos)housePos));
    }

    /*
     * WARNING - void declaration
     */
    private final void addRandomProps(NBTTagCompound data, IHeightmap heightmap, BlockPos blockPos, BiomeProvider biomeProvider, List<? extends Rectangle> gutters) {
        NBTTagList props = new NBTTagList();
        int numberOfProps = Random.Default.nextInt(25, 100);
        int n = 0;
        int n2 = numberOfProps;
        while (n < n2) {
            void i;
            boolean bl;
            BlockPos schematicPosNoY;
            Schematic schematic;
            int schematicId;
            block5: {
                schematicId = Random.Default.nextInt(0, ModSchematics.INSTANCE.getDARK_FOREST_PROPS().length);
                schematic = ModSchematics.INSTANCE.getDARK_FOREST_PROPS()[schematicId];
                Collection collection = gutters;
                boolean bl2 = false;
                Rectangle gutter = (Rectangle)CollectionsKt.random(collection, Random.Default);
                schematicPosNoY = this.getRandomPropPosition(schematic, blockPos, gutter);
                ChunkPos chunkPos = new ChunkPos(schematicPosNoY);
                Set<Biome> biomes = this.getBiomesInChunk(biomeProvider, chunkPos.field_77276_a, chunkPos.field_77275_b);
                Iterable $this$any$iv = INCOMPATIBLE_BIOMES;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Biome it = (Biome)element$iv;
                        boolean bl3 = false;
                        if (!biomes.contains(it)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                int yPos = heightmap.getLowestHeight(new ChunkPos(schematicPosNoY.func_177982_a(schematic.getWidth() / 2, 0, schematic.getLength() / 2)));
                BlockPos schematicPos = new BlockPos(schematicPosNoY.func_177958_n(), yPos, schematicPosNoY.func_177952_p());
                NBTTagCompound prop = new NBTTagCompound();
                prop.func_74768_a(NBT_SCHEMATIC_ID, schematicId);
                prop.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)schematicPos));
                props.func_74742_a((NBTBase)prop);
            }
            ++i;
        }
        data.func_74782_a(NBT_PROPS, (NBTBase)props);
    }

    private final BlockPos getRandomPropPosition(Schematic prop, BlockPos blockPos, Rectangle gutter) {
        int xMin = gutter.x;
        int xMax = gutter.x + gutter.width - prop.getWidth();
        int zMin = gutter.y;
        int zMax = gutter.y + gutter.height - prop.getLength();
        return new BlockPos(blockPos.func_177958_n() + Random.Default.nextInt(xMin, xMax), 0, blockPos.func_177952_p() + Random.Default.nextInt(zMin, zMax));
    }

    /*
     * WARNING - void declaration
     */
    private final void addRandomTrees(NBTTagCompound data, IHeightmap heightmap, BlockPos blockPos, List<? extends Rectangle> gutters, List<? extends EnumFacing> bedHouseSides) {
        NBTTagList trees = new NBTTagList();
        int numberOfTrees = Random.Default.nextInt(10, 20);
        int n = 0;
        int n2 = numberOfTrees;
        while (n < n2) {
            void i;
            int schematicId = Random.Default.nextInt(0, ModSchematics.INSTANCE.getDARK_FOREST_TREES().length);
            Schematic schematic = ModSchematics.INSTANCE.getDARK_FOREST_TREES()[schematicId];
            int gutterIndex = Random.Default.nextInt(0, gutters.size());
            Rectangle gutter = gutters.get(gutterIndex);
            EnumFacing bedHouseSide = bedHouseSides.get(gutterIndex);
            BlockPos schematicPosNoY = this.getRandomTreePosition(schematic, blockPos, gutter, bedHouseSide);
            int yPos = heightmap.getLowestHeight(new ChunkPos(schematicPosNoY.func_177982_a(schematic.getWidth() / 2, 0, schematic.getLength() / 2)));
            yPos = RangesKt.coerceIn(yPos - 5, 0, Integer.MAX_VALUE);
            BlockPos schematicPos = new BlockPos(schematicPosNoY.func_177958_n(), yPos, schematicPosNoY.func_177952_p());
            NBTTagCompound tree = new NBTTagCompound();
            tree.func_74768_a(NBT_SCHEMATIC_ID, schematicId);
            tree.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)schematicPos));
            trees.func_74742_a((NBTBase)tree);
            ++i;
        }
        data.func_74782_a(NBT_TREES, (NBTBase)trees);
    }

    private final BlockPos getRandomTreePosition(Schematic tree, BlockPos blockPos, Rectangle gutter, EnumFacing bedHouseSide) {
        int xMin = 0;
        int xMax = 0;
        int zMin = 0;
        int zMax = 0;
        int trunkSize = 5;
        xMax = gutter.x + gutter.width - tree.getWidth() / 2;
        xMin = gutter.x + tree.getWidth() / 2;
        zMax = gutter.y + gutter.height - tree.getLength() / 2;
        zMin = gutter.y + tree.getLength() / 2;
        switch (StructureDarkForest$WhenMappings.$EnumSwitchMapping$0[bedHouseSide.ordinal()]) {
            case 1: {
                xMax = gutter.x + gutter.width - trunkSize;
                break;
            }
            case 2: {
                xMin = gutter.x + trunkSize;
                break;
            }
            case 3: {
                zMax = gutter.y + gutter.height - trunkSize;
                break;
            }
            case 4: {
                zMin = gutter.y + trunkSize;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Expected a side NORTH/SOUTH/EAST/WEST but got '" + bedHouseSide + '\'');
            }
        }
        return new BlockPos(blockPos.func_177958_n() + Random.Default.nextInt(xMin -= tree.getWidth() / 2, xMax -= tree.getWidth() / 2), 0, blockPos.func_177952_p() + Random.Default.nextInt(zMin -= tree.getLength() / 2, zMax -= tree.getLength() / 2));
    }

    @Override
    public int getXWidth() {
        return this.width;
    }

    @Override
    public int getZLength() {
        return this.height;
    }

    /*
     * WARNING - void declaration
     */
    public StructureDarkForest() {
        super("dark_forest");
        void $this$mapTo$iv$iv;
        Short s;
        Object object;
        int n;
        void $this$mapTo$iv$iv2;
        Schematic[] $this$map$iv = ModSchematics.INSTANCE.getDARK_FOREST_TREES();
        boolean $i$f$map = false;
        Schematic[] schematicArray = $this$map$iv;
        Schematic[] destination$iv$iv = (Schematic[])new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_10 = $this$mapTo$iv$iv2;
        int n2 = ((void)var7_10).length;
        for (n = 0; n < n2; ++n) {
            void it;
            void item$iv$iv;
            void var11_17 = item$iv$iv = var7_10[n];
            object = destination$iv$iv;
            boolean bl = false;
            s = it.getWidth();
            object.add(s);
        }
        Object t = CollectionsKt.maxWith((List)destination$iv$iv, widestTree.2.INSTANCE);
        if (t == null) {
            Intrinsics.throwNpe();
        }
        short widestTree2 = ((Number)t).shortValue();
        Schematic[] $this$map$iv2 = ModSchematics.INSTANCE.getDARK_FOREST_TREES();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
        boolean $i$f$mapTo2 = false;
        void var8_13 = $this$mapTo$iv$iv;
        n = ((void)var8_13).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void bl = item$iv$iv = var8_13[i];
            object = destination$iv$iv2;
            boolean bl2 = false;
            s = it.getLength();
            object.add(s);
        }
        Object t2 = CollectionsKt.maxWith((List)destination$iv$iv2, longestTree.2.INSTANCE);
        if (t2 == null) {
            Intrinsics.throwNpe();
        }
        short longestTree2 = ((Number)t2).shortValue();
        this.bedHouseWidth = ModSchematics.INSTANCE.getBED_HOUSE().getWidth();
        this.bedHouseLength = ModSchematics.INSTANCE.getBED_HOUSE().getLength();
        this.width = this.bedHouseWidth + 2 * widestTree2;
        this.height = this.bedHouseLength + 2 * longestTree2;
    }

    static {
        Companion = new Companion(null);
        INCOMPATIBLE_BIOMES = SetsKt.setOf(Biomes.field_76771_b, Biomes.field_150575_M, Biomes.field_76776_l, Biomes.field_76777_m, Biomes.field_76781_i, Biomes.field_76779_k, Biomes.field_185440_P);
        COMPATIBLE_HOUSE_BIOMES = SetsKt.setOf(new Biome[]{Biomes.field_150588_X, Biomes.field_185435_ag, Biomes.field_76772_c, Biomes.field_185441_Q, ModBiomes.INSTANCE.getEERIE_FOREST()});
    }

    public static final /* synthetic */ Set access$getBiomesInChunk(StructureDarkForest $this, BiomeProvider biomeProvider, int chunkX, int chunkZ) {
        return $this.getBiomesInChunk(biomeProvider, chunkX, chunkZ);
    }

    public static final /* synthetic */ Set access$getCOMPATIBLE_HOUSE_BIOMES$cp() {
        return COMPATIBLE_HOUSE_BIOMES;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/StructureDarkForest$Companion;", "", "()V", "COMPATIBLE_HOUSE_BIOMES", "", "Lnet/minecraft/world/biome/Biome;", "kotlin.jvm.PlatformType", "INCOMPATIBLE_BIOMES", "NBT_HOUSE_POSITION", "", "NBT_PROPS", "NBT_SCHEMATIC_ID", "NBT_TREES", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

