/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration.structure;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.world.IHeightmap;
import com.davidm1a2.afraidofthedark.common.constants.ModLootTables;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.Schematic;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.SchematicGenerator;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.StructureGnomishCity;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.AOTDStructure;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.iterator.InteriorChunkIterator;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.processor.IChunkProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/StructureGnomishCity;", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/AOTDStructure;", "()V", "computeChanceToGenerateAt", "", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "heightmap", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IHeightmap;", "biomeProvider", "Lnet/minecraft/world/biome/BiomeProvider;", "generate", "", "world", "Lnet/minecraft/world/World;", "chunkPos", "Lnet/minecraft/util/math/ChunkPos;", "data", "Lnet/minecraft/nbt/NBTTagCompound;", "generateStructureData", "getXWidth", "", "getZLength", "Companion", "afraidofthedark"})
public final class StructureGnomishCity
extends AOTDStructure {
    private static final String NBT_ROOM_INDEX = "room_index";
    private static final String NBT_ENARIAS_LAIR = "enarias_lair";
    private static final String NBT_ROOMS = "rooms";
    private static final String NBT_SURFACE_STAIRS = "surface_stairs";
    private static final String NBT_TUNNELS_NS = "tunnels_ns";
    private static final String NBT_TUNNELS_EW = "tunnels_ew";
    private static final int STAIR_DOWNWARD_INDEX = -1;
    private static final int STAIR_UPWARD_INDEX = -2;
    public static final Companion Companion = new Companion(null);

    @Override
    public double computeChanceToGenerateAt(@NotNull BlockPos blockPos, @NotNull IHeightmap heightmap, @NotNull BiomeProvider biomeProvider) {
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        Intrinsics.checkParameterIsNotNull(heightmap, "heightmap");
        Intrinsics.checkParameterIsNotNull(biomeProvider, "biomeProvider");
        return ((Number)this.processChunks(new IChunkProcessor<Double>(heightmap){
            private int minHeight;
            private int maxHeight;
            final /* synthetic */ IHeightmap $heightmap;

            public final int getMinHeight() {
                return this.minHeight;
            }

            public final void setMinHeight(int n) {
                this.minHeight = n;
            }

            public final int getMaxHeight() {
                return this.maxHeight;
            }

            public final void setMaxHeight(int n) {
                this.maxHeight = n;
            }

            public boolean processChunk(@NotNull ChunkPos chunkPos) {
                int n;
                Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
                int n2 = this.minHeight;
                int n3 = this.$heightmap.getLowestHeight(chunkPos);
                computeChanceToGenerateAt.1 var5_4 = this;
                boolean bl = false;
                var5_4.minHeight = n = Math.min(n2, n3);
                n2 = this.maxHeight;
                n3 = this.$heightmap.getHighestHeight(chunkPos);
                var5_4 = this;
                bl = false;
                var5_4.maxHeight = n = Math.max(n2, n3);
                return this.maxHeight - this.minHeight <= 20;
            }

            @NotNull
            public Double getResult() {
                return 3.0E-4 * (double)AfraidOfTheDark.Companion.getINSTANCE().getConfigurationHandler().getGnomishCityFrequency();
            }

            @NotNull
            public Double getDefaultResult() {
                return 0.0;
            }
            {
                this.$heightmap = $captured_local_variable$0;
                this.minHeight = Integer.MAX_VALUE;
                this.maxHeight = Integer.MIN_VALUE;
            }
        }, new InteriorChunkIterator(this, blockPos))).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(@NotNull World world, @NotNull ChunkPos chunkPos, @NotNull NBTTagCompound data) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        Intrinsics.checkParameterIsNotNull(data, "data");
        NBTTagList rooms = data.func_150295_c(NBT_ROOMS, 10);
        int n = 0;
        int n2 = rooms.func_74745_c();
        while (n < n2) {
            void i;
            NBTTagCompound room = rooms.func_150305_b((int)i);
            int roomIndex = room.func_74762_e(NBT_ROOM_INDEX);
            BlockPos roomPos = NBTUtil.func_186861_c((NBTTagCompound)room.func_74775_l("position"));
            if (roomIndex >= 0) {
                Schematic schematic = ModSchematics.INSTANCE.getGNOMISH_CITY_ROOMS()[roomIndex];
                BlockPos blockPos = roomPos;
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "roomPos");
                SchematicGenerator.INSTANCE.generateSchematic(schematic, world, blockPos, chunkPos, ModLootTables.INSTANCE.getGNOMISH_CITY());
            } else if (roomIndex == -1) {
                Schematic schematic = ModSchematics.INSTANCE.getROOM_STAIR_DOWN();
                BlockPos blockPos = roomPos;
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "roomPos");
                SchematicGenerator.INSTANCE.generateSchematic(schematic, world, blockPos, chunkPos, ModLootTables.INSTANCE.getGNOMISH_CITY());
            } else if (roomIndex == -2) {
                Schematic schematic = ModSchematics.INSTANCE.getROOM_STAIR_UP();
                BlockPos blockPos = roomPos;
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "roomPos");
                SchematicGenerator.INSTANCE.generateSchematic(schematic, world, blockPos, chunkPos, ModLootTables.INSTANCE.getGNOMISH_CITY());
            }
            ++i;
        }
        NBTTagList tunnelsEW = data.func_150295_c(NBT_TUNNELS_EW, 10);
        n2 = 0;
        int room = tunnelsEW.func_74745_c();
        while (n2 < room) {
            void i;
            NBTTagCompound tunnelEW = tunnelsEW.func_150305_b((int)i);
            BlockPos tunnelPos = NBTUtil.func_186861_c((NBTTagCompound)tunnelEW.func_74775_l("position"));
            Schematic schematic = ModSchematics.INSTANCE.getTUNNEL_EW();
            BlockPos blockPos = tunnelPos;
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "tunnelPos");
            SchematicGenerator.generateSchematic$default(SchematicGenerator.INSTANCE, schematic, world, blockPos, chunkPos, null, 16, null);
            ++i;
        }
        NBTTagList tunnelsNS = data.func_150295_c(NBT_TUNNELS_NS, 10);
        room = 0;
        int tunnelEW = tunnelsNS.func_74745_c();
        while (room < tunnelEW) {
            void i;
            NBTTagCompound tunnelNS = tunnelsNS.func_150305_b((int)i);
            BlockPos tunnelPos = NBTUtil.func_186861_c((NBTTagCompound)tunnelNS.func_74775_l("position"));
            Schematic schematic = ModSchematics.INSTANCE.getTUNNEL_NS();
            BlockPos blockPos = tunnelPos;
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "tunnelPos");
            SchematicGenerator.generateSchematic$default(SchematicGenerator.INSTANCE, schematic, world, blockPos, chunkPos, null, 16, null);
            ++i;
        }
        NBTTagCompound surfaceStairs = data.func_74775_l(NBT_SURFACE_STAIRS);
        BlockPos surfaceStairsPos = NBTUtil.func_186861_c((NBTTagCompound)surfaceStairs.func_74775_l("position"));
        Schematic schematic = ModSchematics.INSTANCE.getSTAIRWELL();
        BlockPos blockPos = surfaceStairsPos;
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "surfaceStairsPos");
        SchematicGenerator.generateSchematic$default(SchematicGenerator.INSTANCE, schematic, world, blockPos, chunkPos, null, 16, null);
        Schematic schematic2 = ModSchematics.INSTANCE.getSTAIRWELL();
        BlockPos blockPos2 = surfaceStairsPos.func_177982_a(0, (int)ModSchematics.INSTANCE.getSTAIRWELL().getHeight(), 0);
        Intrinsics.checkExpressionValueIsNotNull(blockPos2, "surfaceStairsPos.add(0, \u2026L.getHeight().toInt(), 0)");
        SchematicGenerator.generateSchematic$default(SchematicGenerator.INSTANCE, schematic2, world, blockPos2, chunkPos, null, 16, null);
        NBTTagCompound enariasLair = data.func_74775_l(NBT_ENARIAS_LAIR);
        BlockPos enariasLairPos = NBTUtil.func_186861_c((NBTTagCompound)enariasLair.func_74775_l("position"));
        Schematic schematic3 = ModSchematics.INSTANCE.getENARIA_LAIR();
        BlockPos blockPos3 = enariasLairPos;
        Intrinsics.checkExpressionValueIsNotNull(blockPos3, "enariasLairPos");
        SchematicGenerator.generateSchematic$default(SchematicGenerator.INSTANCE, schematic3, world, blockPos3, chunkPos, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NBTTagCompound generateStructureData(@NotNull World world, @NotNull BlockPos blockPos, @NotNull BiomeProvider biomeProvider) {
        int n;
        int n2;
        Iterator $this$flatMapTo$iv$iv22;
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        Intrinsics.checkParameterIsNotNull(biomeProvider, "biomeProvider");
        BlockPos blockPos2 = blockPos;
        NBTTagCompound compound = new NBTTagCompound();
        blockPos2 = new BlockPos(blockPos2.func_177958_n(), 5, blockPos2.func_177952_p());
        compound.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)blockPos2));
        int stairSurfaceTo1 = 0;
        int stairs1To2 = 0;
        int stairs2ToEnaria = 0;
        stairSurfaceTo1 = world.field_73012_v.nextInt(9);
        stairs2ToEnaria = 7;
        while (stairSurfaceTo1 == (stairs1To2 = world.field_73012_v.nextInt(9)) || stairs2ToEnaria == stairs1To2) {
        }
        LinkedList<Integer> roomIndicesQueue = new LinkedList<Integer>();
        Iterable $this$flatMap$iv = ArraysKt.getIndices(ModSchematics.INSTANCE.getGNOMISH_CITY_ROOMS());
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv22.iterator();
        while (iterator2.hasNext()) {
            int element$iv$iv;
            int it = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOf(it, it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach322 = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            roomIndicesQueue.add(it);
        }
        $this$forEach$iv = roomIndicesQueue;
        Random random = world.field_73012_v;
        Intrinsics.checkExpressionValueIsNotNull(random, "world.rand");
        Random $i$f$forEach322 = random;
        boolean $this$flatMapTo$iv$iv22 = false;
        Collections.shuffle($this$forEach$iv, $i$f$forEach322);
        NBTTagList rooms = new NBTTagList();
        boolean $i$f$forEach322 = false;
        $this$flatMapTo$iv$iv22 = true;
        while ($i$f$forEach322 <= $this$flatMapTo$iv$iv22) {
            void floor;
            int element$iv = 0;
            n2 = 2;
            while (element$iv <= n2) {
                void xIndex;
                int bl = 0;
                n = 2;
                while (bl <= n) {
                    void zIndex;
                    void currentRoom = xIndex + zIndex * 3;
                    NBTTagCompound room = new NBTTagCompound();
                    room.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)blockPos2.func_177982_a((int)(xIndex * 50), (int)(floor * 15 + 15), (int)(zIndex * 50))));
                    if (currentRoom == stairSurfaceTo1 && floor == true) {
                        room.func_74768_a(NBT_ROOM_INDEX, -2);
                        NBTTagCompound surfaceStairs = new NBTTagCompound();
                        surfaceStairs.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)blockPos2.func_177982_a((int)(xIndex * 50 + 13), (int)(floor * 15 + 30), (int)(zIndex * 50 + 13))));
                        compound.func_74782_a(NBT_SURFACE_STAIRS, (NBTBase)surfaceStairs);
                    } else if (currentRoom == stairs1To2 && floor == true) {
                        room.func_74768_a(NBT_ROOM_INDEX, -1);
                    } else if (currentRoom == stairs1To2 && floor == false) {
                        room.func_74768_a(NBT_ROOM_INDEX, -2);
                    } else if (currentRoom == stairs2ToEnaria && floor == false) {
                        room.func_74768_a(NBT_ROOM_INDEX, -1);
                        NBTTagCompound enariaRoom = new NBTTagCompound();
                        enariaRoom.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)blockPos2.func_177982_a((int)(xIndex * 50 - 14), (int)(floor * 15), (int)(zIndex * 50 - 73))));
                        compound.func_74782_a(NBT_ENARIAS_LAIR, (NBTBase)enariaRoom);
                    } else {
                        Object e = roomIndicesQueue.pop();
                        if (e == null) {
                            Intrinsics.throwNpe();
                        }
                        room.func_74768_a(NBT_ROOM_INDEX, ((Number)e).intValue());
                    }
                    rooms.func_74742_a((NBTBase)room);
                    ++zIndex;
                }
                ++xIndex;
            }
            ++floor;
        }
        compound.func_74782_a(NBT_ROOMS, (NBTBase)rooms);
        NBTTagList tunnelsEW = new NBTTagList();
        NBTTagList tunnelsNS = new NBTTagList();
        int xIndex = 0;
        n2 = 1;
        while (xIndex <= n2) {
            void floor;
            int zIndex = 0;
            n = 2;
            while (zIndex <= n) {
                void i;
                boolean currentRoom = false;
                boolean bl = true;
                while (currentRoom <= bl) {
                    void j;
                    NBTTagCompound tunnelEW = new NBTTagCompound();
                    tunnelEW.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)blockPos2.func_177982_a((int)(i * 50 + 13), (int)(floor * 15 + 15 + 7), (int)(j * 50 + 32))));
                    tunnelsEW.func_74742_a((NBTBase)tunnelEW);
                    NBTTagCompound tunnelNS = new NBTTagCompound();
                    tunnelNS.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)blockPos2.func_177982_a((int)(j * 50 + 32), (int)(floor * 15 + 15 + 7), (int)(i * 50 + 13))));
                    tunnelsNS.func_74742_a((NBTBase)tunnelNS);
                    ++j;
                }
                ++i;
            }
            ++floor;
        }
        compound.func_74782_a(NBT_TUNNELS_EW, (NBTBase)tunnelsEW);
        compound.func_74782_a(NBT_TUNNELS_NS, (NBTBase)tunnelsNS);
        return compound;
    }

    @Override
    public int getXWidth() {
        short roomWidth = ModSchematics.INSTANCE.getROOM_CAVE().getWidth();
        short tunnelWidth = ModSchematics.INSTANCE.getTUNNEL_NS().getWidth();
        return roomWidth * 3 + tunnelWidth * 2 - 4;
    }

    @Override
    public int getZLength() {
        short roomLength = ModSchematics.INSTANCE.getROOM_CAVE().getLength();
        short tunnelLength = ModSchematics.INSTANCE.getTUNNEL_EW().getLength();
        return roomLength * 3 + tunnelLength * 2 - 4;
    }

    public StructureGnomishCity() {
        super("gnomish_city");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/StructureGnomishCity$Companion;", "", "()V", "NBT_ENARIAS_LAIR", "", "NBT_ROOMS", "NBT_ROOM_INDEX", "NBT_SURFACE_STAIRS", "NBT_TUNNELS_EW", "NBT_TUNNELS_NS", "STAIR_DOWNWARD_INDEX", "", "STAIR_UPWARD_INDEX", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

