/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base;

import com.davidm1a2.afraidofthedark.common.capabilities.world.OverworldHeightmap;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.Structure;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.iterator.IChunkIterator;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.iterator.InteriorChunkIterator;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.processor.IChunkProcessor;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.processor.LowestHeightChunkProcessor;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J)\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u00a2\u0006\u0002\u0010\u001cR\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/AOTDStructure;", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/Structure;", "baseName", "", "(Ljava/lang/String;)V", "biomesArray", "", "Lnet/minecraft/world/biome/Biome;", "[Lnet/minecraft/world/biome/Biome;", "generateStructureData", "Lnet/minecraft/nbt/NBTTagCompound;", "world", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "biomeProvider", "Lnet/minecraft/world/biome/BiomeProvider;", "getBiomesInChunk", "", "chunkX", "", "chunkZ", "processChunks", "T", "chunkProcessor", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/processor/IChunkProcessor;", "chunkIterator", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/iterator/IChunkIterator;", "(Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/processor/IChunkProcessor;Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/iterator/IChunkIterator;)Ljava/lang/Object;", "afraidofthedark"})
public abstract class AOTDStructure
extends Structure {
    private final Biome[] biomesArray;

    protected <T> T processChunks(@NotNull IChunkProcessor<T> chunkProcessor, @NotNull IChunkIterator chunkIterator) {
        Intrinsics.checkParameterIsNotNull(chunkProcessor, "chunkProcessor");
        Intrinsics.checkParameterIsNotNull(chunkIterator, "chunkIterator");
        for (ChunkPos chunkPos : chunkIterator.getChunks()) {
            if (chunkProcessor.processChunk(chunkPos)) continue;
            T t = chunkProcessor.getDefaultResult();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            return t;
        }
        return chunkProcessor.getResult();
    }

    @NotNull
    protected Set<Biome> getBiomesInChunk(@NotNull BiomeProvider biomeProvider, int chunkX, int chunkZ) {
        Intrinsics.checkParameterIsNotNull(biomeProvider, "biomeProvider");
        Biome[] biomeArray = biomeProvider.func_76933_b(this.biomesArray, chunkX * 16, chunkZ * 16, 16, 16);
        Intrinsics.checkExpressionValueIsNotNull(biomeArray, "biomeProvider.getBiomes(\u2026 16, chunkZ * 16, 16, 16)");
        return ArraysKt.toSet(biomeArray);
    }

    @Override
    @NotNull
    public NBTTagCompound generateStructureData(@NotNull World world, @NotNull BlockPos blockPos, @NotNull BiomeProvider biomeProvider) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        Intrinsics.checkParameterIsNotNull(biomeProvider, "biomeProvider");
        BlockPos blockPos2 = blockPos;
        NBTTagCompound compound = new NBTTagCompound();
        int yPos = ((Number)this.processChunks(new LowestHeightChunkProcessor(OverworldHeightmap.Companion.get(world)), new InteriorChunkIterator(this, blockPos2))).intValue();
        blockPos2 = new BlockPos(blockPos2.func_177958_n(), yPos, blockPos2.func_177952_p());
        compound.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)blockPos2));
        return compound;
    }

    public AOTDStructure(@NotNull String baseName) {
        Intrinsics.checkParameterIsNotNull(baseName, "baseName");
        this.biomesArray = new Biome[256];
        this.setRegistryName("afraidofthedark:" + baseName);
    }
}

