/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.processor;

import com.davidm1a2.afraidofthedark.common.capabilities.world.IHeightmap;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.processor.IChunkProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/processor/LowestHeightChunkProcessor;", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/processor/IChunkProcessor;", "", "heightmap", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IHeightmap;", "(Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IHeightmap;)V", "minGroundHeight", "getResult", "()Ljava/lang/Integer;", "processChunk", "", "chunkPos", "Lnet/minecraft/util/math/ChunkPos;", "afraidofthedark"})
public final class LowestHeightChunkProcessor
implements IChunkProcessor<Integer> {
    private int minGroundHeight;
    private final IHeightmap heightmap;

    @Override
    public boolean processChunk(@NotNull ChunkPos chunkPos) {
        int n;
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        int groundHeight = this.heightmap.getLowestHeight(chunkPos);
        int n2 = this.minGroundHeight;
        LowestHeightChunkProcessor lowestHeightChunkProcessor = this;
        boolean bl = false;
        lowestHeightChunkProcessor.minGroundHeight = n = Math.min(n2, groundHeight);
        return true;
    }

    @Override
    @NotNull
    public Integer getResult() {
        return this.minGroundHeight;
    }

    public LowestHeightChunkProcessor(@NotNull IHeightmap heightmap) {
        Intrinsics.checkParameterIsNotNull(heightmap, "heightmap");
        this.heightmap = heightmap;
        this.minGroundHeight = 256;
    }

    @Override
    @Nullable
    public Integer getDefaultResult() {
        return IChunkProcessor.DefaultImpls.getDefaultResult(this);
    }
}

