/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft;

import com.windanesz.ancientspellcraft.CommonProxy;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.client.gui.GuiHandlerAS;
import com.windanesz.ancientspellcraft.command.CommandListBiomes;
import com.windanesz.ancientspellcraft.data.RitualDiscoveryData;
import com.windanesz.ancientspellcraft.data.SpellCategorization;
import com.windanesz.ancientspellcraft.integration.artemislib.ASArtemisLibIntegration;
import com.windanesz.ancientspellcraft.integration.baubles.ASBaublesIntegration;
import com.windanesz.ancientspellcraft.item.ItemRelic;
import com.windanesz.ancientspellcraft.item.ItemSoulboundWandUpgrade;
import com.windanesz.ancientspellcraft.packet.ASPacketHandler;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBiomes;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBlocks;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftDimensions;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftLoot;
import com.windanesz.ancientspellcraft.registry.BookshelfItems;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.util.RitualProperties;
import com.windanesz.ancientspellcraft.worldgen.WorldGenCrystalShardOre;
import com.windanesz.ancientspellcraft.worldgen.WorldGenDevoritiumOre;
import java.util.Random;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="ancientspellcraft", name="Ancient Spellcraft by Dan", version="1.12.2-1.2.1", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:ebwizardry@[4.3.4,4.4);after:jei@[4.15.0,);after:artemislib")
public class AncientSpellcraft {
    public static final String MODID = "ancientspellcraft";
    public static final String NAME = "Ancient Spellcraft by Dan";
    public static final Random rand = new Random();
    public static Settings settings = new Settings();
    public static Logger logger;
    @Mod.Instance(value="ancientspellcraft")
    public static AncientSpellcraft instance;
    @SidedProxy(clientSide="com.windanesz.ancientspellcraft.client.ClientProxy", serverSide="com.windanesz.ancientspellcraft.CommonProxy")
    public static CommonProxy proxy;
    public static final Material DEVORITIUM;
    public static final Item.ToolMaterial DEVORITIUM_TOOL_MATERIAL;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        settings = new Settings();
        proxy.registerRenderers();
        AncientSpellcraftLoot.preInit();
        AncientSpellcraftBlocks.registerTileEntities();
        AncientSpellcraftBiomes.preInit();
        BookshelfItems.preInitBookShelfModelTextures();
        ASBaublesIntegration.init();
        ASArtemisLibIntegration.init();
        RitualDiscoveryData.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenCrystalShardOre(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenDevoritiumOre(), (int)0);
        AncientSpellcraftItems.registerDispenseBehaviours();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandlerAS());
        ASPacketHandler.initPackets();
        proxy.registerParticles();
        AncientSpellcraftDimensions.init();
        Ritual.registry.forEach(Ritual::init);
        RitualProperties.init();
        ItemSoulboundWandUpgrade.init();
        proxy.init();
        BookshelfItems.InitBookshelfItems();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ItemRelic.initEffects();
        proxy.initialiseLayers();
        SpellCategorization.init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandListBiomes());
    }

    static {
        DEVORITIUM = new Material(MapColor.field_151646_E);
        DEVORITIUM_TOOL_MATERIAL = EnumHelper.addToolMaterial((String)"devoritium", (int)2, (int)250, (float)6.0f, (float)2.0f, (int)0);
    }
}

