/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="ancientspellcraft", name="AncientSpellcraft")
public class Settings {
    public ResourceLocation[] lootInjectionLocations;
    public ResourceLocation[] artefactInjectionLocations;
    public ResourceLocation[] voidCreeperBiomeBlacklist;
    public List<ResourceLocation> shardEarthShardBiomeWhitelist;
    public List<ResourceLocation> shardSorceryShardBiomeWhitelist;
    public List<ResourceLocation> shardNecromancyShardBiomeWhitelist;
    public List<ResourceLocation> shardHealingBiomeWhitelist;
    public List<ResourceLocation> shardLightningBiomeWhitelist;
    public List<ResourceLocation> shardFireBiomeWhitelist;
    public List<ResourceLocation> shardIceBiomeWhitelist;
    @Config.Name(value="General Settings")
    @Config.LangKey(value="settings.ancientspellcraft:general_settings")
    public static GeneralSettings generalSettings = new GeneralSettings();
    @Config.Name(value="Client Settings")
    @Config.LangKey(value="settings.ancientspellcraft:client_settings")
    public static ClientSettings clientSettings = new ClientSettings();
    @Config.Name(value="Spell Compat Settings")
    @Config.LangKey(value="settings.ancientspellcraft:spell_compat_settings")
    public static SpellCompatSettings spellCompatSettings = new SpellCompatSettings();

    public Settings() {
        this.lootInjectionLocations = electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.DEFAULT_LOOT_INJECTION_LOCATIONS);
        this.artefactInjectionLocations = electroblob.wizardry.Settings.toResourceLocations((String[])generalSettings.ARTEFACT_INJECTION_LOCATIONS);
        this.voidCreeperBiomeBlacklist = electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.void_creeper_biome_blacklist);
        this.shardEarthShardBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.earth_shard_biome_whitelist));
        this.shardSorceryShardBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.sorcery_shard_biome_whitelist));
        this.shardNecromancyShardBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.necromancy_shard_biome_whitelist));
        this.shardHealingBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.healing_shard_biome_whitelist));
        this.shardLightningBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.lightning_shard_biome_whitelist));
        this.shardFireBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.fire_shard_biome_whitelist));
        this.shardIceBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.ice_shard_biome_whitelist));
    }

    public static boolean isArtefactEnabled(Item artefact) {
        if (artefact instanceof ItemArtefact && Wizardry.settings.getConfigCategory("artefacts").containsKey(artefact.getRegistryName().toString())) {
            return Wizardry.settings.getConfigCategory("artefacts").get(artefact.getRegistryName().toString()).getBoolean();
        }
        return true;
    }

    public static class SpellCompatSettings {
        @Config.Name(value="Mine Spell Override")
        @Config.Comment(value={"If enabled, Ancient Spellcraft will override the base Wizardry mod's Mine spell to add compatibility to the Fortune related artefact.Disabling this feature will cause the game to load the default Mine spell class which can be helpful if you are having issues, but it also makes the Circlet of Fortune artefact useless!"})
        @Config.RequiresMcRestart
        public boolean mineSpellOverride = true;
        @Config.Name(value="Mine Spell Network ID")
        @Config.Comment(value={"WARNING! Don't change this value unless you are told you so, otherwise your world won't start! \nThe reason this value exists as a settings is to provide a quick way to fix compatibility (until the A.S. update is released to fix it) if the network ID of the spell is changed by an EBWiz update. \nThis could possibly happen if new spells are added by the base mod and the NetworkIDs shift."})
        @Config.RequiresMcRestart
        public int mineSpellNetworkID = 141;
        @Config.Name(value="Conjure Pickaxe Spell Override")
        @Config.Comment(value={"If enabled, Ancient Spellcraft will override the base Wizardry mod's Conjure Pickaxe spell to add compatibility to the Fortune related artefact.\nDisabling this feature will cause the game to load the default Conjure Pickaxe spell class which can be helpful if you are having issues, but it also makes the Circlet of Fortune artefact useless!"})
        @Config.RequiresMcRestart
        public boolean conjurePickaxeSpellOverride = true;
        @Config.Name(value="Conjure Pickaxe Spell Network ID")
        @Config.Comment(value={"WARNING! Don't change this value unless you are told you so, otherwise your world won't start! \nThe reason this value exists as a settings is to provide a quick way to fix compatibility (until the A.S. update is released to fix it) if the network ID of the spell is changed by an EBWiz update.\nThis could possibly happen if new spells are added by the base mod and the NetworkIDs shift."})
        @Config.RequiresMcRestart
        public int conjurePickaxeSpellNetworkID = 41;
    }

    public static class ClientSettings {
        @Config.Name(value="Show Contingency HUD")
        @Config.Comment(value={"Whether to show the contingency HUD when there are active spell Contingencies."})
        @Config.RequiresMcRestart
        public boolean show_contingency_hud = true;
        @Config.Name(value="Clips Mouse To Hud")
        @Config.Comment(value={"Clips the mouse to the hud, possibly allowing faster spell selection."})
        @Config.RequiresMcRestart
        public boolean clip_mouse_to_circle = true;
        @Config.Name(value="Contingency HUD Left Side Position")
        @Config.Comment(value={"Whether to show the contingency HUD on the left side of the screen (defaults to right side)."})
        @Config.RequiresMcRestart
        public boolean contingency_hud_left_side_position = true;
        @Config.Name(value="Radial Spell Menu Enabled")
        @Config.Comment(value={"If true, you can open the radial spell selector menu with the configured key. Otherwise you must click on a spell to select it."})
        public boolean radial_menu_enabled = true;
        @Config.Name(value="Release To Swap")
        @Config.Comment(value={"If true, the hovered spell will be selected when you release the radial GUI button while having the cursor over a spell."})
        public boolean release_to_swap = true;
    }

    public static class GeneralSettings {
        @Config.Name(value="JEI integration")
        @Config.Comment(value={"Enables or disables the JEI integration of the mod"})
        @Config.RequiresMcRestart
        public boolean jei_integration = true;
        @Config.Name(value="ArtemisLib integration")
        @Config.Comment(value={"Enables or disables the ArtemisLib integration of the mod"})
        @Config.RequiresMcRestart
        public boolean artemislib_integration = true;
        @Config.Name(value="Generate Crystal Ore Shards")
        @Config.Comment(value={"Determines whether to generate elemental crystal shards in the Overworld or not"})
        @Config.RequiresMcRestart
        public boolean generate_ore_shards = true;
        @Config.Name(value="Generate Devoritium Ore")
        @Config.Comment(value={"Determines whether to generate devoritium ore blocks in the Overworld or not"})
        @Config.RequiresMcRestart
        public boolean generate_devoritium_ore = true;
        @Config.Name(value="Sphere Spell Identify Chance")
        @Config.Comment(value={"The chance of identifying unknown spells when researching them with the Sphere of Cognizance. This doesn't affects the other hint texts given by the Sphere. 0 = never identify a spell, 1.0 = always"})
        @Config.RequiresMcRestart
        public double sphere_spell_identification_chance = 0.05;
        @Config.Name(value="Loot Inject Locations")
        @Config.Comment(value={"List of loot tables to inject Ancient Spellcraft loot (as specified in loot_tables/chests/dungeon_additions.json) into. This currently includes stuff like Stone Tablets."})
        public String[] DEFAULT_LOOT_INJECTION_LOCATIONS = new String[]{"ebwizardry:chests/wizard_tower", "ebwizardry:chests/shrine", "ebwizardry:chests/obelisk", "minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/stronghold_corridor", "minecraft:chests/stronghold_crossing", "minecraft:chests/stronghold_library", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion", "minecraft:chests/end_city_treasure"};
        @Config.Name(value="Artefact Inject locations")
        @Config.Comment(value={"List of loot tables to inject Ancient Spellcraft artefacts into."})
        private String[] ARTEFACT_INJECTION_LOCATIONS = new String[]{"ebwizardry:subsets/uncommon_artefacts", "ebwizardry:subsets/rare_artefacts", "ebwizardry:subsets/epic_artefacts"};
        @Config.Name(value="Essence Extraction Screen Shake")
        @Config.Comment(value={"Determines whether to the Essence Extraction spell shakes the screen while extracting powerful blocks or not."})
        @Config.RequiresMcRestart
        public boolean shake_screen = true;
        @Config.Name(value="Baubles Integration")
        @Config.Comment(value={"Enable/Disable Baubles integration for the new artefact types (belt, helm, etc). This does NOT affect Electroblob's Wizardry's own Baubles support implementation (ring, amulet, charm)!"})
        @Config.RequiresMcRestart
        public boolean baubles_integration = true;
        @Config.Name(value="Void Creeper Spawn Rate")
        @Config.Comment(value={"Spawn rate for naturally-spawned void creepers; higher numbers mean more void creepers will spawn. Set to 0 do disable spawning entirely"})
        @Config.RequiresMcRestart
        public int void_creeper_spawn_rate = 2;
        @Config.Name(value="Class Armour Evil Wizard Spawn Rate")
        @Config.Comment(value={"Spawn rate for naturally-spawned class (sage, warlock, battlemage) wizards; higher numbers mean more wizards will spawn. Set to 0 do disable spawning entirely"})
        @Config.RequiresMcRestart
        public int evil_class_wizard_spawn_rate = 2;
        @Config.Name(value="Orb Artefact Potency Percent Bonus")
        @Config.Comment(value={"Determines the potency bonus of the elemental orb artefacts in a percentage value"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0, max=100)
        public int orb_artefact_potency_bonus = 30;
        @Config.Name(value="Void Creeper Biome Blacklist")
        @Config.Comment(value={"List of Biomes where Void Creepers will never spawn."})
        @Config.RequiresMcRestart
        public String[] void_creeper_biome_blacklist = new String[]{"mushroom_island", "mushroom_island_shore"};
        @Config.Name(value="Void Creeper Dimension Whitelist")
        @Config.Comment(value={"List of Dimensions where Void Creepers are allowed to spawn. Defaults to Overworld only.\n make"})
        @Config.RequiresMcRestart
        public Integer[] void_creeper_dimension_whitelist = new Integer[]{0};
        @Config.Name(value="Elemental Fire Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Fire Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] fire_shard_biome_whitelist = new String[]{"desert", "desert_hills", "mutated_desert"};
        @Config.Name(value="Elemental Earth Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Earth Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] earth_shard_biome_whitelist = new String[]{"forest", "birch_forest", "roofed_forest"};
        @Config.Name(value="Elemental Sorcery Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Sorcery Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] sorcery_shard_biome_whitelist = new String[]{"plains", "mutated_plains"};
        @Config.Name(value="Elemental Necromancy Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Necromancy Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] necromancy_shard_biome_whitelist = new String[]{"swampland", "mutated_swampland"};
        @Config.Name(value="Elemental Healing Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Healing Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] healing_shard_biome_whitelist = new String[]{"jungle", "jungle_hills", "jungle_edge"};
        @Config.Name(value="Elemental Lightning Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Lightning Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] lightning_shard_biome_whitelist = new String[]{"extreme_hills", "smaller_extreme_hills", "extreme_hills_with_trees", "mutated_extreme_hills", "mutated_extreme_hills_with_trees"};
        @Config.Name(value="Elemental Ice Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Ice Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] ice_shard_biome_whitelist = new String[]{"taiga", "taiga_hills", "taiga_cold", "taiga_cold_hills", "mutated_taiga", "mutated_taiga_cold"};
        @Config.Name(value="[UNUSED] Pocket Biome registry ID")
        @Config.Comment(value={"Allows you to change the pocket biome registry ID if you encounter biome ID conflicts"})
        @Config.RequiresMcRestart
        public int pocket_biome_registry_id = 168;
        @Config.Name(value="Immobility Contingency Spell Trigger Effects")
        @Config.Comment(value={"List of potion effects which can be considered as an immobilizing effect. Receiving one of these will trigger the stored Contingency - Immobility spell"})
        @Config.RequiresMcRestart
        public String[] immobility_contingency_effects = new String[]{"ebwizardry:paralysis", "ebwizardry:containment", "ebwizardry:slow_time", "ebwizardry:frost", "minecraft:slowness"};
        @Config.Name(value="Wizards Buy Ancient Element Books")
        @Config.Comment(value={"If true, friendly Wizards will buy ancient element books (the gray ones)"})
        @Config.RequiresMcRestart
        public boolean wizards_buy_ancient_element_books = true;
        @Config.Name(value="Wizards Buy Ancient Spellcraft Spell Books")
        @Config.Comment(value={"If true, friendly Wizards will buy ancient spellcraft element books (the blue/dark books)"})
        @Config.RequiresMcRestart
        public boolean wizards_buy_ancient_spellcraft_books = true;
        @Config.Name(value="Wizards Buy Ancient Spellcraft Ritual Books")
        @Config.Comment(value={"If true, friendly Wizards will buy ancient spellcraft ritual books"})
        @Config.RequiresMcRestart
        public boolean wizards_buy_ancient_spellcraft_ritual_books = true;
        @Config.Name(value="Enable Wizard Entity Changes")
        @Config.Comment(value={"If true, A.S. will alter the wizard entities to inject into their trade list. Disable if you are having issues related to this feature."})
        @Config.RequiresMcRestart
        public boolean apply_wizard_entity_changes = true;
        @Config.Name(value="Transportation Portal Teleports Any Entites")
        @Config.Comment(value={"If true, Transportation Portals can transport non-player entities. If false, only players can use the portal."})
        public boolean transportation_portal_teleports_any_entites = true;
    }

    @Mod.EventBusSubscriber(modid="ancientspellcraft")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("ancientspellcraft")) {
                ConfigManager.sync((String)"ancientspellcraft", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

