/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.block;

import com.windanesz.ancientspellcraft.block.BlockMagicMushroom;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockMushroomExplosive
extends BlockMagicMushroom {
    @Override
    public boolean applyHarmfulEffect(World world, @Nullable Block block, BlockPos pos, DamageSource source, float damage, IBlockState state, @Nullable EntityLivingBase caster, EntityLivingBase target, float potency) {
        damage *= 2.0f;
        if (target != null) {
            if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FIRE, (Entity)target)) {
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)source, (float)damage);
            }
            target.func_70015_d(Spells.firebomb.getProperty("burn_duration").intValue());
        }
        int blastMultiplier = 1;
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).scale((float)(5 * blastMultiplier)).clr(1.0f, 0.6f, 0.0f).spawn(world);
            for (int i = 0; i < 60 * blastMultiplier; ++i) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE, (Random)world.field_73012_v, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(2 * blastMultiplier), (boolean)false).time(10 + world.field_73012_v.nextInt(4)).scale(2.0f + world.field_73012_v.nextFloat()).spawn(world);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC, (Random)world.field_73012_v, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(2 * blastMultiplier), (boolean)false).clr(1.0f, 0.2f + world.field_73012_v.nextFloat() * 0.4f, 0.0f).spawn(world);
            }
            world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
        }
        if (!world.field_72995_K) {
            double range = Spells.firebomb.getProperty("blast_radius").floatValue() * (float)blastMultiplier;
            List targets = EntityUtils.getLivingWithinRadius((double)range, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (World)world);
            for (EntityLivingBase currTarget : targets) {
                if (currTarget == target || currTarget == caster || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FIRE, (Entity)currTarget)) continue;
                EntityUtils.attackEntityWithoutKnockback((Entity)currTarget, (DamageSource)source, (float)damage);
                currTarget.func_70015_d(4);
            }
        }
        return true;
    }

    public static int getColorFromTile(Block block, int layer) {
        if (layer == 0) {
            return 1099713;
        }
        if (layer == 1) {
            return 1099713;
        }
        return 0;
    }
}

