/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.block;

import com.windanesz.ancientspellcraft.block.BlockMagicMushroom;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockMushroomHeal
extends BlockMagicMushroom {
    @Override
    public boolean applyBeneficialEffect(World world, @Nullable Block block, BlockPos pos, DamageSource source, float damage, IBlockState state, @Nullable EntityLivingBase caster, EntityLivingBase target, float potency) {
        if (target.func_110143_aJ() < target.func_110138_aP()) {
            if (!world.field_72995_K) {
                target.func_70691_i(1.5f * potency);
            } else {
                BlockMushroomHeal.spawnRedHealingParticles(world, target);
            }
            target.func_184185_a(AncientSpellcraftSounds.ENTITY_HEALING_HEATH_HEALS, 0.9f, 1.2f / (world.field_73012_v.nextFloat() * 0.2f + 0.9f));
            return true;
        }
        return false;
    }

    @Override
    public boolean applyHarmfulEffect(World world, @Nullable Block block, BlockPos pos, DamageSource source, float damage, IBlockState state, @Nullable EntityLivingBase caster, EntityLivingBase target, float potency) {
        if (target.func_70662_br()) {
            EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)source, (float)(damage * 2.0f));
            return true;
        }
        return false;
    }

    public static void spawnRedHealingParticles(World world, EntityLivingBase entity) {
        for (int i = 0; i < 10; ++i) {
            double x = entity.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = entity.field_70163_u + (double)entity.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = entity.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(245, 47, 47).spawn(world);
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)entity).clr(245, 47, 47).spawn(world);
    }
}

