/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.block;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftTabs;
import com.windanesz.ancientspellcraft.tileentity.TileEntityRevertingBlock;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface ITemporaryBlock {
    default public void setTemporaryBlockProperties(Block block) {
        block.func_149647_a(AncientSpellcraftTabs.ANCIENTSPELLCRAFT);
        block.func_149722_s();
        block.func_149752_b(6000000.0f);
    }

    default public TileEntity createNewTileEntityDelegate(World world, int meta) {
        return new TileEntityRevertingBlock();
    }

    default public Item getItemDroppedDelegate(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    default public void harvestBlockDelegate(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
    }

    public static boolean placeTemporaryBlock(EntityLivingBase placer, World world, Block temporaryBlock, BlockPos pos, int lifetime) {
        return ITemporaryBlock.placeTemporaryBlock(placer, world, temporaryBlock, pos, lifetime, true);
    }

    public static boolean placeTemporaryBlock(EntityLivingBase placer, World world, Block temporaryBlock, BlockPos pos, int lifetime, boolean replaceAir) {
        if (!(temporaryBlock instanceof ITemporaryBlock)) {
            return false;
        }
        if (!replaceAir && world.func_175623_d(pos)) {
            return false;
        }
        if (world.func_175625_s(pos) instanceof TileEntityRevertingBlock || world.func_175625_s(pos) != null) {
            return false;
        }
        NBTTagCompound oldStateCompound = NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)world.func_180495_p(pos));
        world.func_175656_a(pos, temporaryBlock.func_176223_P());
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityRevertingBlock) {
            TileEntityRevertingBlock tileEntityRevertingBlock = (TileEntityRevertingBlock)tileentity;
            tileEntityRevertingBlock.setLifetime(lifetime);
            if (placer != null) {
                tileEntityRevertingBlock.setCaster(placer);
            }
            tileEntityRevertingBlock.setOldState(NBTUtil.func_190008_d((NBTTagCompound)oldStateCompound));
            tileEntityRevertingBlock.sync();
        } else {
            world.func_175656_a(pos, NBTUtil.func_190008_d((NBTTagCompound)oldStateCompound));
        }
        return true;
    }
}

