/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.client;

import com.google.common.collect.Lists;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.client.ClientProxy;
import com.windanesz.ancientspellcraft.packet.ASPacketHandler;
import com.windanesz.ancientspellcraft.packet.PacketSelectRadialItemSpell;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiRadialMenu
extends GuiScreen {
    public static final ResourceLocation UNKNOWN_SPELL_IMAGE = new ResourceLocation("ancientspellcraft", "textures/spells/unknown.png");
    private boolean closing;
    private boolean doneClosing;
    private double startAnimation;
    private int selectedItem = -1;
    private final ISpellCastingItem spellCastingItem;
    private int spellCount;
    private List<Spell> spells;
    private int currentIndex = 0;
    private static final float PRECISION = 5.0f;

    GuiRadialMenu(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ISpellCastingItem)) {
            throw new IllegalArgumentException("Attempted to open Radial spell menu with an item not implementing ISpellCastingItem!");
        }
        this.spellCastingItem = (ISpellCastingItem)stack.func_77973_b();
        this.spellCount = this.spellCastingItem.getSpells(stack).length;
        this.spells = Arrays.asList(this.spellCastingItem.getSpells(stack));
        this.startAnimation = (double)Minecraft.func_71410_x().field_71441_e.func_82737_E() + (double)Minecraft.func_71410_x().func_184121_ak();
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiRadialMenu) {
            event.setCanceled(true);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.closing) {
            if (this.doneClosing) {
                Minecraft.func_71410_x().func_147108_a(null);
                ClientProxy.wipeOpen();
            }
            return;
        }
        if (!GameSettings.func_100015_a((KeyBinding)ClientProxy.KEY_ACTIVATE_RADIAL_SPELL_MENU)) {
            if (Settings.clientSettings.release_to_swap) {
                this.processClick();
            } else {
                this.animateClose();
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.processClick();
    }

    private void processClick() {
        if (this.closing) {
            return;
        }
        PacketSelectRadialItemSpell.Message msg = new PacketSelectRadialItemSpell.Message(this.currentIndex);
        ASPacketHandler.net.sendToServer((IMessage)msg);
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            items.add(i);
        }
        int numItems = items.size();
        if (++numItems <= 0) {
            return;
        }
        this.animateClose();
    }

    private void animateClose() {
        this.closing = true;
        this.doneClosing = false;
        this.startAnimation = (double)Minecraft.func_71410_x().field_71441_e.func_82737_E() + (double)Minecraft.func_71410_x().func_184121_ak();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        float e;
        float s;
        int i;
        float openAnimation;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int numItems = this.spellCount;
        if (numItems <= 0) {
            if (this.closing) {
                this.doneClosing = true;
            }
            return;
        }
        float OPEN_ANIMATION_LENGTH = 2.5f;
        float f = openAnimation = this.closing ? (float)(1.0 - ((double)((float)Minecraft.func_71410_x().field_71441_e.func_82737_E() + partialTicks) - this.startAnimation) / 2.5) : (float)(((double)((float)Minecraft.func_71410_x().field_71441_e.func_82737_E() + partialTicks) - this.startAnimation) / 2.5);
        if (this.closing && openAnimation <= 0.0f) {
            this.doneClosing = true;
        }
        float animProgress = MathHelper.func_76131_a((float)openAnimation, (float)0.0f, (float)1.0f);
        float radiusIn = Math.max(0.1f, 30.0f * animProgress);
        float radiusOut = radiusIn * 2.0f;
        float itemRadius = (radiusIn + radiusOut) * 0.5f;
        float animTop = (1.0f - animProgress) * (float)this.field_146295_m / 2.0f;
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        double a = Math.toDegrees(Math.atan2(mouseY - y, mouseX - x));
        double d = Math.sqrt(Math.pow(mouseX - x, 2.0) + Math.pow(mouseY - y, 2.0));
        float s0 = (-0.5f / (float)numItems + 0.25f) * 360.0f;
        if (a < (double)s0) {
            a += 360.0;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)animTop, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        boolean hasMouseOver = false;
        ItemStack itemMouseOver = ItemStack.field_190927_a;
        Spell spellOver = Spells.none;
        if (!this.closing) {
            this.selectedItem = -1;
            for (i = 0; i < numItems; ++i) {
                s = (((float)i - 0.5f) / (float)numItems + 0.25f) * 360.0f;
                e = (((float)i + 0.5f) / (float)numItems + 0.25f) * 360.0f;
                if (!(a >= (double)s) || !(a < (double)e) || !(d >= (double)radiusIn) || !(d < (double)radiusOut)) continue;
                this.selectedItem = i;
                break;
            }
        }
        for (i = 0; i < numItems; ++i) {
            s = (((float)i - 0.5f) / (float)numItems + 0.25f) * 360.0f;
            e = (((float)i + 0.5f) / (float)numItems + 0.25f) * 360.0f;
            if (this.selectedItem == i && i >= 0) {
                ItemStack inSlot;
                int[] colour;
                spellOver = this.spells.get(i);
                this.currentIndex = i;
                int[] nArray = colour = this.isKnownSpell(spellOver) ? (int[])BlockReceptacle.PARTICLE_COLOURS.get(spellOver.getElement()) : (int[])BlockReceptacle.PARTICLE_COLOURS.get(Element.MAGIC);
                if (spellOver.applicableForItem(AncientSpellcraftItems.ancient_spell_book)) {
                    this.drawPieArc(buffer, x, y, this.field_73735_i, radiusIn, radiusOut, s, e, 219, 180, 72, 64);
                } else if (spellOver.getElement() == Element.MAGIC) {
                    this.drawPieArc(buffer, x, y, this.field_73735_i, radiusIn, radiusOut, s, e, 200, 200, 200, 64);
                } else {
                    this.drawPieArc(buffer, x, y, this.field_73735_i, radiusIn, radiusOut, s, e, Color.decode(String.valueOf(colour[0])).getRed(), Color.decode(String.valueOf(colour[2])).getGreen(), Color.decode(String.valueOf(colour[2])).getBlue(), 64);
                }
                hasMouseOver = true;
                itemMouseOver = inSlot = ItemStack.field_190927_a;
                continue;
            }
            this.drawPieArc(buffer, x, y, this.field_73735_i, radiusIn, radiusOut, s, e, 0, 0, 0, 64);
        }
        double scaledX = (float)Mouse.getX() - (float)this.field_146297_k.field_71443_c / 2.0f;
        double scaledY = (float)Mouse.getY() - (float)this.field_146297_k.field_71440_d / 2.0f;
        double distance = Math.sqrt(scaledX * scaledX + scaledY * scaledY);
        double radius = 60.0 * (double)(this.field_146297_k.field_71443_c / this.field_146294_l);
        if (Settings.clientSettings.clip_mouse_to_circle && distance > radius) {
            double fixedX = scaledX * radius / distance;
            double fixedY = scaledY * radius / distance;
            Mouse.setCursorPosition((int)((int)((double)(this.field_146297_k.field_71443_c / 2) + fixedX)), (int)((int)((double)(this.field_146297_k.field_71440_d / 2) + fixedY)));
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        RenderHelper.func_74520_c();
        for (int index = 0; index < this.spellCount; ++index) {
            float angle1 = ((float)index / (float)this.spellCount + 0.25f) * 2.0f * (float)Math.PI;
            float posX = (float)(x - 8) + itemRadius * (float)Math.cos(angle1);
            float posY = (float)(y - 8) + itemRadius * (float)Math.sin(angle1);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            Spell spell = this.spells.get(index);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.isKnownSpell(spell) ? spell.getIcon() : UNKNOWN_SPELL_IMAGE);
            DrawingUtils.drawTexturedRect((int)((int)posX * 2), (int)((int)posY * 2), (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
            GlStateManager.func_179121_F();
        }
        if (hasMouseOver && spellOver != null && spellOver != Spells.none && this.isKnownSpell(spellOver)) {
            GlStateManager.func_179094_E();
            this.func_73732_a(this.field_146289_q, spellOver.getDisplayNameWithFormatting(), this.field_146294_l / 2, (this.field_146295_m - this.field_146289_q.field_78288_b) / 2, -1);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        if (itemMouseOver.func_190916_E() > 0) {
            this.func_146285_a(itemMouseOver, mouseX, mouseY);
        }
    }

    private void drawPieArc(BufferBuilder buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int r, int g, int b, int a) {
        float angle = endAngle - startAngle;
        int sections = Math.max(1, MathHelper.func_76123_f((float)(angle / 5.0f)));
        startAngle = (float)Math.toRadians(startAngle);
        endAngle = (float)Math.toRadians(endAngle);
        angle = endAngle - startAngle;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i / (float)sections * angle;
            float angle2 = startAngle + (float)(i + 1) / (float)sections * angle;
            float pos1InX = x + radiusIn * (float)Math.cos(angle1);
            float pos1InY = y + radiusIn * (float)Math.sin(angle1);
            float pos1OutX = x + radiusOut * (float)Math.cos(angle1);
            float pos1OutY = y + radiusOut * (float)Math.sin(angle1);
            float pos2OutX = x + radiusOut * (float)Math.cos(angle2);
            float pos2OutY = y + radiusOut * (float)Math.sin(angle2);
            float pos2InX = x + radiusIn * (float)Math.cos(angle2);
            float pos2InY = y + radiusIn * (float)Math.sin(angle2);
            buffer.func_181662_b((double)pos1OutX, (double)pos1OutY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)pos1InX, (double)pos1InY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)pos2InX, (double)pos2InY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)pos2OutX, (double)pos2OutY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private boolean isKnownSpell(Spell spell) {
        if (this.field_146297_k.field_71439_g != null) {
            WizardData data = WizardData.get((EntityPlayer)this.field_146297_k.field_71439_g);
            return data != null && data.hasSpellBeenDiscovered(spell);
        }
        return false;
    }
}

