/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.client.gui;

import com.google.common.hash.Hashing;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.item.ItemRitualBook;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.util.LangUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.client.gui.GuiButtonTurnPage;
import electroblob.wizardry.registry.WizardrySounds;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.apache.commons.lang3.RandomStringUtils;
import org.lwjgl.input.Keyboard;

public class GuiRitualBook
extends GuiScreen {
    protected static final String TRANSLATION_KEY_PREFIX = "gui.ebwizardry:spell_book";
    protected static final ResourceLocation TEXTURE = new ResourceLocation("ancientspellcraft", "textures/gui/ritual_book.png");
    protected static final ResourceLocation TEXTURE_DOUBLE_PAGE = new ResourceLocation("ancientspellcraft", "textures/gui/ritual_book_double_page.png");
    private static final int PAGE_BUTTON_INSET_X = 22;
    private static final int PAGE_BUTTON_INSET_Y = 13;
    private final int xSize = 288;
    private final int ySize = 180;
    protected int textureWidth = 512;
    protected int textureHeight = 256;
    boolean doublePage = false;
    private GuiButton nextPageButton;
    private GuiButton prevPageButton;
    private ItemStack ritualBook;
    private Ritual ritual;
    private String glyphName;
    private int currentPage = 0;

    public GuiRitualBook(ItemStack ritualBook) {
        this.ritualBook = ritualBook;
        this.ritual = ItemRitualBook.getRitual(ritualBook);
        this.glyphName = Hashing.md5().hashString((CharSequence)this.ritual.getRegistryName().toString(), StandardCharsets.UTF_8).toString();
    }

    public Ritual getRitual() {
        return this.ritual;
    }

    public ResourceLocation getTexture() {
        return this.doublePage && this.currentPage == 0 ? TEXTURE_DOUBLE_PAGE : TEXTURE;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int left = this.field_146294_l / 2 - 144;
        int top = this.field_146295_m / 2 - this.ySize / 2;
        this.func_146276_q_();
        this.drawBackgroundLayer(left, top, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawForegroundLayer(left, top, mouseX, mouseY);
    }

    protected void drawBackgroundLayer(int left, int top, int mouseX, int mouseY) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTexture());
        DrawingUtils.drawTexturedRect((int)left, (int)top, (int)0, (int)0, (int)288, (int)180, (int)this.textureWidth, (int)this.textureHeight);
    }

    protected void drawForegroundLayer(int left, int top, int mouseX, int mouseY) {
        boolean doublePage;
        String fullDesc = this.getRitual().getDescription();
        int splitIndex = 320;
        boolean bl = doublePage = fullDesc.length() > 320;
        if (doublePage) {
            int i = 320;
            for (int j = 0; j < 30 && !Character.isWhitespace(fullDesc.charAt(i)); ++j) {
                if (j < 15) {
                    ++i;
                    continue;
                }
                --i;
            }
            splitIndex = i;
        }
        boolean discovered = AncientSpellcraft.proxy.shouldDisplayDiscovered(this.getRitual(), this.ritualBook);
        String rightSideDesc = "";
        String name = discovered ? this.getRitual().getDisplayName() : LangUtils.toElderFuthark(this.getRitual().getDisplayName());
        String desc = fullDesc;
        this.field_146289_q.func_78264_a(true);
        this.field_146289_q.func_78276_b(name, left + 20, top + 20, 0);
        this.field_146289_q.func_78264_a(false);
        if (doublePage && this.currentPage == 0) {
            doublePage = true;
            desc = fullDesc.substring(0, splitIndex);
            rightSideDesc = fullDesc.substring(splitIndex);
        } else {
            RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
            ItemStack stackTooltip = ItemStack.field_190927_a;
            int patternWidth = this.ritual.getRitualProperties().width;
            int patternHeight = this.ritual.getRitualProperties().height;
            int offset = patternWidth * 16 / 2;
            int x = left + 146 + 48 + 16 - offset;
            int y = top + 16 + 74 + -offset;
            int index = 0;
            for (int j = 0; j < patternHeight; ++j) {
                for (int k = 0; k < patternWidth; ++k) {
                    int xPos = x + 16 * k;
                    if (((Ingredient)this.ritual.getRitualProperties().pattern.get(index)).func_193365_a().length > 0) {
                        Item item = ((Ingredient)this.ritual.getRitualProperties().pattern.get(index)).func_193365_a()[0].func_77973_b();
                        ItemStack stack = new ItemStack(item);
                        itemRenderer.func_180450_b(stack, xPos, y);
                        if (mouseX >= xPos && mouseX <= xPos + 16 && mouseY >= y && mouseY <= y + 16) {
                            stackTooltip = stack;
                        }
                    }
                    ++index;
                }
                y += 16;
            }
            if (stackTooltip != ItemStack.field_190927_a) {
                this.func_146285_a(stackTooltip, mouseX, mouseY);
            }
        }
        if (discovered) {
            if (this.currentPage == 0) {
                this.field_146289_q.func_78264_a(true);
                this.field_146289_q.func_78279_b(desc, left + 17, top + 44, 118, 0);
                this.field_146289_q.func_78264_a(false);
            }
            if (doublePage && this.currentPage == 0) {
                this.field_146289_q.func_78264_a(true);
                this.field_146289_q.func_78279_b(rightSideDesc, left + 17 + 133, top + 14, 118, 0);
                this.field_146289_q.func_78264_a(false);
            }
        } else {
            if (this.currentPage == 0) {
                desc = LangUtils.toElderFuthark(this.getRitual().getDescription());
                this.field_146289_q.func_78279_b(desc, left + 17, top + 44, 118, 0);
            }
            if (doublePage && this.currentPage == 0) {
                desc = LangUtils.toElderFuthark(rightSideDesc);
                this.field_146289_q.func_78279_b(LangUtils.toElderFuthark(rightSideDesc), left + 17 + 133, top + 14, 118, 0);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int buttonID = 0;
        int left = this.field_146294_l / 2 - this.xSize / 2;
        int top = this.field_146295_m / 2 - this.ySize / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        boolean bl = this.doublePage = this.getRitual().getDescription().length() > 320;
        if (this.doublePage) {
            this.nextPageButton = new GuiButtonTurnPage(buttonID++, left + 288 - 22 - 20, top + 180 - 13 - 12, GuiButtonTurnPage.Type.NEXT_PAGE, TEXTURE, this.textureWidth, this.textureHeight);
            this.field_146292_n.add(this.nextPageButton);
            this.prevPageButton = new GuiButtonTurnPage(buttonID++, left + 22, top + 180 - 13 - 12, GuiButtonTurnPage.Type.PREVIOUS_PAGE, TEXTURE, this.textureWidth, this.textureHeight);
            this.field_146292_n.add(this.prevPageButton);
            this.prevPageButton.field_146125_m = this.currentPage > 0;
        }
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.MISC_BOOK_OPEN, (float)1.0f));
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return Wizardry.settings.booksPauseGame;
    }

    private String generateRandomName(Random random) {
        String name = "";
        for (int i = 0; i < random.nextInt(2) + 2; ++i) {
            name = name + RandomStringUtils.random((int)(3 + random.nextInt(5)), (String)"abcdefghijklmnopqrstuvwxyz") + " ";
        }
        return name.trim();
    }

    protected void func_146284_a(GuiButton button) {
        int lastPage = 1;
        if (button == this.nextPageButton) {
            if (this.currentPage < lastPage) {
                ++this.currentPage;
            }
        } else if (button == this.prevPageButton && this.currentPage > 0) {
            --this.currentPage;
        }
        if (this.currentPage == 0) {
            this.prevPageButton.field_146125_m = false;
            this.nextPageButton.field_146125_m = true;
        } else {
            this.nextPageButton.field_146125_m = false;
            this.prevPageButton.field_146125_m = true;
        }
    }
}

