/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.client.renderer;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.spell.Contingency;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.spell.Spell;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class RenderContingency {
    private static final int SPELL_ICON_SIZE = 16;
    private static final ResourceLocation CONTIGENCY_ARROW = new ResourceLocation("ancientspellcraft", "textures/gui/contingency_arrow.png");

    @SubscribeEvent
    public static void draw(RenderGameOverlayEvent.Post event) {
        if (Settings.clientSettings.show_contingency_hud && event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            NBTTagCompound activeContingencies;
            int x = 20;
            if (!Settings.clientSettings.contingency_hud_left_side_position) {
                x = event.getResolution().func_78326_a() - (x + 60);
            }
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            LinkedHashMap<Spell, Spell> contingencyMap = new LinkedHashMap<Spell, Spell>();
            WizardData data = WizardData.get((EntityPlayer)player);
            if (data != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null) {
                for (String key : activeContingencies.func_150296_c()) {
                    Spell contingency = (Spell)Spell.registry.getValue(new ResourceLocation(key));
                    Spell storedSpell = (Spell)Spell.registry.getValue(new ResourceLocation(activeContingencies.func_74779_i(key)));
                    contingencyMap.putIfAbsent(contingency, storedSpell);
                }
            }
            int i = 0;
            for (Map.Entry entry : contingencyMap.entrySet()) {
                Minecraft mc = Minecraft.func_71410_x();
                int y = 40 + 18 * i;
                RenderContingency.renderRect(mc, x, y, 0, 0, 16, 16, 16, 16, ((Spell)entry.getKey()).getIcon());
                RenderContingency.renderRect(mc, x + 16, y, 0, 0, 16, 16, 16, 16, CONTIGENCY_ARROW);
                RenderContingency.renderRect(mc, x + 32, y, 0, 0, 16, 16, 16, 16, ((Spell)entry.getValue()).getIcon());
                ++i;
            }
        }
    }

    private static void renderRect(Minecraft mc, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, ResourceLocation texture) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(texture);
        DrawingUtils.drawTexturedRect((int)x, (int)y, (int)u, (int)v, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
        GlStateManager.func_179121_F();
    }
}

